/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.embedded.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.bytecode.ConstPool;
import javassist.gluonj.embedded.bytecode.annotation.AnnotationsWriter;
import javassist.gluonj.embedded.bytecode.annotation.MemberValue;
import javassist.gluonj.embedded.bytecode.annotation.MemberValueVisitor;

public class FloatMemberValue
extends MemberValue {
    int valueIndex;
    static /* synthetic */ Class class$0;

    public FloatMemberValue(int index, ConstPool cp) {
        super('F', cp);
        this.valueIndex = index;
    }

    public FloatMemberValue(float f, ConstPool cp) {
        super('F', cp);
        this.setValue(f);
    }

    public FloatMemberValue(ConstPool cp) {
        super('F', cp);
        this.setValue(0.0f);
    }

    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return new Float(this.getValue());
    }

    Class getType(ClassLoader cl) {
        return Float.TYPE;
    }

    public float getValue() {
        return this.cp.getFloatInfo(this.valueIndex);
    }

    public void setValue(float newValue) {
        this.valueIndex = this.cp.addFloatInfo(newValue);
    }

    public String toString() {
        return Float.toString(this.getValue());
    }

    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    public void accept(MemberValueVisitor visitor) {
        visitor.visitFloatMemberValue(this);
    }
}

