/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.embedded.util.proxy;

import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Method;
import javassist.gluonj.embedded.util.proxy.MethodHandler;
import javassist.gluonj.embedded.util.proxy.ProxyFactory;
import javassist.gluonj.embedded.util.proxy.SerializedProxy;

public class RuntimeSupport {
    public static MethodHandler default_interceptor = new DefaultMethodHandler();

    public static Method findMethod(Object self, String name, String desc) {
        Method m = RuntimeSupport.findMethod2(self.getClass(), name, desc);
        if (m == null) {
            RuntimeSupport.error(self, name, desc);
        }
        return m;
    }

    public static Method findSuperMethod(Object self, String name, String desc) {
        Class<?> clazz = self.getClass();
        Method m = RuntimeSupport.findSuperMethod2(clazz.getSuperclass(), name, desc);
        if (m == null) {
            m = RuntimeSupport.searchInterfaces(clazz, name, desc);
        }
        if (m == null) {
            RuntimeSupport.error(self, name, desc);
        }
        return m;
    }

    private static void error(Object self, String name, String desc) {
        throw new RuntimeException("not found " + name + ":" + desc + " in " + self.getClass().getName());
    }

    private static Method findSuperMethod2(Class clazz, String name, String desc) {
        Method m = RuntimeSupport.findMethod2(clazz, name, desc);
        if (m != null) {
            return m;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (m = RuntimeSupport.findSuperMethod2(superClass, name, desc)) != null) {
            return m;
        }
        return RuntimeSupport.searchInterfaces(clazz, name, desc);
    }

    private static Method searchInterfaces(Class clazz, String name, String desc) {
        Method m = null;
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            m = RuntimeSupport.findSuperMethod2(interfaces[i], name, desc);
            if (m != null) {
                return m;
            }
            ++i;
        }
        return m;
    }

    private static Method findMethod2(Class clazz, String name, String desc) {
        Method[] methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int i = 0;
        while (i < n) {
            if (methods[i].getName().equals(name) && RuntimeSupport.makeDescriptor(methods[i]).equals(desc)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static String makeDescriptor(Method m) {
        Class[] params = m.getParameterTypes();
        return RuntimeSupport.makeDescriptor(params, m.getReturnType());
    }

    public static String makeDescriptor(Class[] params, Class retType) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        int i = 0;
        while (i < params.length) {
            RuntimeSupport.makeDesc(sbuf, params[i]);
            ++i;
        }
        sbuf.append(')');
        RuntimeSupport.makeDesc(sbuf, retType);
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void makeDesc(StringBuffer sbuf, Class type) {
        if (type.isArray()) {
            sbuf.append('[');
            RuntimeSupport.makeDesc(sbuf, type.getComponentType());
            return;
        } else if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                sbuf.append('V');
                return;
            } else if (type == Integer.TYPE) {
                sbuf.append('I');
                return;
            } else if (type == Byte.TYPE) {
                sbuf.append('B');
                return;
            } else if (type == Long.TYPE) {
                sbuf.append('J');
                return;
            } else if (type == Double.TYPE) {
                sbuf.append('D');
                return;
            } else if (type == Float.TYPE) {
                sbuf.append('F');
                return;
            } else if (type == Character.TYPE) {
                sbuf.append('C');
                return;
            } else if (type == Short.TYPE) {
                sbuf.append('S');
                return;
            } else {
                if (type != Boolean.TYPE) throw new RuntimeException("bad type: " + type.getName());
                sbuf.append('Z');
            }
            return;
        } else {
            sbuf.append('L').append(type.getName().replace('.', '/')).append(';');
        }
    }

    public static SerializedProxy makeSerializedProxy(Object proxy) throws InvalidClassException {
        Class<?> clazz = proxy.getClass();
        return new SerializedProxy(clazz, ProxyFactory.getFilter(clazz), ProxyFactory.getHandler(clazz));
    }

    static class DefaultMethodHandler
    implements MethodHandler,
    Serializable {
        DefaultMethodHandler() {
        }

        public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Exception {
            return proceed.invoke(self, args);
        }
    }
}

