/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.pc;

import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.CtBehavior;
import javassist.gluonj.pc.AccessPc;
import javassist.gluonj.pc.PatternParser;
import javassist.gluonj.pc.PointcutVisitor;
import javassist.gluonj.runtime.Cflow;

public class CflowPc
extends AccessPc {
    private static String threadVar = Cflow.class.getName() + ".singleton";
    private static int uniqueNo = 0;
    private String cflowName = "_" + uniqueNo++;
    private int counter = 0;

    public CflowPc(String pat) {
        super(pat);
    }

    public String getExpr() throws RuntimeException {
        return threadVar + ".check(\"" + this.cflowName + "\")";
    }

    public void accept(PointcutVisitor v) throws WeaveException {
        v.visit(this);
    }

    public String toString() {
        return "cflow(" + this.patternStr + ")";
    }

    public void prepare(PatternParser p) throws WeaveException {
        super.prepare(p);
        if (!this.pattern.isMethod()) {
            throw new WeaveException("bad pattern: " + this.toString());
        }
        this.cflowName = p.getGlueName() + this.cflowName;
    }

    public void instrument(CtBehavior method) throws WeaveException {
        String className = method.getDeclaringClass().getName();
        if (this.getPattern().matchMethod(className, method.getName(), method.getSignature())) {
            try {
                if (this.counter++ > 0) {
                    throw new WeaveException("cflow() cannot include an wild card");
                }
                method.insertBefore(threadVar + ".enter(\"" + this.cflowName + "\");");
                method.insertAfter(threadVar + ".exit(\"" + this.cflowName + "\");", true);
            }
            catch (CannotCompileException e) {
                throw new WeaveException(e);
            }
        }
    }
}

