/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.expr.Expr;
import javassist.gluonj.embedded.expr.ExprEditor;
import javassist.gluonj.pc.PointcutNode;
import javassist.gluonj.weave.AliasList;
import javassist.gluonj.weave.Hook;

public class Advice {
    public static final String[] kinds = new String[]{"before", "after", "around"};
    public static final int BEFORE = 1;
    public static final int AFTER = 2;
    public static final int AROUND = 3;
    public static final char DOUBLE_QUOTE = '`';
    int kind;
    private PointcutNode pointcut;
    private AliasList aliases;
    private String advice;
    private String body;

    public Advice(int k, String adv) {
        this.kind = k;
        this.pointcut = null;
        this.aliases = null;
        this.advice = Advice.makeBody(adv);
        this.body = null;
    }

    protected Advice(int k) {
        this.kind = k;
        this.pointcut = null;
        this.aliases = null;
        this.advice = null;
        this.body = null;
    }

    public void setPointcut(PointcutNode p, AliasList alist) {
        this.pointcut = p;
        this.aliases = alist;
        this.body = alist != null && this.advice != null ? alist.expand(this.advice) : this.advice;
    }

    private static String makeBody(String body) {
        StringBuffer sbuf = new StringBuffer();
        int len = body.length();
        boolean change = false;
        for (int i = 0; i < len; ++i) {
            int c = body.charAt(i);
            if (c == 92) {
                if (i + 1 < len && body.charAt(i + 1) == '`') {
                    change = true;
                    c = 96;
                    ++i;
                }
            } else if (c == 96) {
                change = true;
                c = 34;
            }
            sbuf.append((char)c);
        }
        return change ? sbuf.toString() : body;
    }

    public int getKind() {
        return this.kind;
    }

    public PointcutNode getPointcut() {
        return this.pointcut;
    }

    public String getBody(Expr expr, Advice proceed) throws CannotCompileException {
        return this.body;
    }

    public String getMethodName() {
        return null;
    }

    public String toString() {
        return this.getKindName() + AliasList.toString(this.aliases) + ": " + this.pointcut.toString() + " { " + this.advice + " }";
    }

    public String getMessage() {
        return null;
    }

    protected String getKindName() {
        if (this.kind < kinds.length) {
            return kinds[this.kind];
        }
        return "unknown";
    }

    public ExprEditor makeEditor(Hook.Iterator iterator, Expr expr) {
        return null;
    }
}

