/*
 * Decompiled with CFR 0.152.
 */
package javassist.gluonj.weave;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javassist.gluonj.Aspect;
import javassist.gluonj.Glue;
import javassist.gluonj.Refine;
import javassist.gluonj.WeaveException;
import javassist.gluonj.embedded.CannotCompileException;
import javassist.gluonj.embedded.ClassPool;
import javassist.gluonj.embedded.CtClass;
import javassist.gluonj.embedded.Loader;
import javassist.gluonj.embedded.NotFoundException;
import javassist.gluonj.weave.Gluon;
import javassist.gluonj.weave.Weaver;

public class OfflineWeaver {
    private String directory;
    private ArrayList notSavedClasses;
    private Weaver2 weaver;

    public OfflineWeaver(String glueName, String[] classpath) throws NotFoundException, WeaveException {
        this.weaver = OfflineWeaver.makeWeaver(glueName, classpath);
        this.directory = ".";
        this.notSavedClasses = new ArrayList();
    }

    private static Weaver2 makeWeaver(String glueName, String[] classpath) throws NotFoundException, WeaveException {
        ClassPool cp = new ClassPool(true);
        ClassPool cp2 = new ClassPool(true);
        if (classpath != null) {
            for (int i = 0; i < classpath.length; ++i) {
                String path = OfflineWeaver.dirName(classpath[i]);
                cp.appendClassPath(path);
                cp2.appendClassPath(path);
            }
        }
        Loader cloader = new Loader(Gluon.class.getClassLoader(), cp);
        cloader.delegateLoadingOf("javassist.gluonj.embedded.");
        return new Weaver2(glueName, cp2, cloader);
    }

    private static String dirName(String dir) {
        int len;
        String path = dir.replace(File.separatorChar, '/');
        if (path.charAt((len = path.length()) - 1) == '/') {
            path = path.substring(0, len - 1);
        }
        return path;
    }

    public void setDirectory(String dir) {
        this.directory = OfflineWeaver.dirName(dir);
    }

    public void transformFiles(File baseDir, String[] fileNames) throws WeaveException, NotFoundException {
        try {
            this.transformFiles2(baseDir, fileNames);
        }
        catch (IOException e) {
            OfflineWeaver.printError(e.getMessage());
            throw new WeaveException(e);
        }
        catch (CannotCompileException e) {
            OfflineWeaver.printError(e.getMessage());
            throw new WeaveException(e);
        }
    }

    private void transformFiles2(File baseDir, String[] fileNames) throws WeaveException, NotFoundException, IOException, CannotCompileException {
        int len = fileNames.length;
        this.notSavedClasses.ensureCapacity(len);
        ArrayList classes = new ArrayList(len);
        ClassPool cp = this.weaver.getSrcPool();
        for (int i = 0; i < len; ++i) {
            String fname = fileNames[i];
            if (!fname.endsWith(".class")) continue;
            try {
                this.readFile(cp, baseDir, fname, classes);
                continue;
            }
            catch (WeaveException e) {
                OfflineWeaver.showTransformError(fname, e);
                throw e;
            }
        }
        for (CtClass c : classes) {
            try {
                CtClass cc = this.weaver.transform(c.getName());
                cc.writeFile(this.directory);
            }
            catch (WeaveException e) {
                OfflineWeaver.showTransformError(c.getName(), e);
                throw e;
            }
        }
    }

    private void readFile(ClassPool cp, File baseDir, String name, ArrayList classes) throws WeaveException, CannotCompileException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(baseDir, name)));
        CtClass clazz = cp.makeClass(is);
        ((InputStream)is).close();
        if (this.notGlue(clazz)) {
            this.weaver.runInspectors0(clazz);
            classes.add(clazz);
        } else {
            clazz.writeFile(this.directory);
        }
    }

    private boolean notGlue(CtClass clazz) {
        boolean result = true;
        Object[] anno = clazz.getAvailableAnnotations();
        for (int j = 0; j < anno.length; ++j) {
            Object a = anno[j];
            if (!(a instanceof Glue) && !(a instanceof Aspect) && !(a instanceof Refine)) continue;
            result = false;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        OfflineWeaver.run0(OfflineWeaver.class.getName(), args);
    }

    public static void run(String mainClass, String[] args) {
        block2: {
            try {
                OfflineWeaver.run0(mainClass, args);
            }
            catch (Exception e) {
                if (!Gluon.stackTrace) break block2;
                e.printStackTrace(System.err);
            }
        }
    }

    private static void run0(String mainClass, String[] args) throws Exception {
        if (args.length < 2) {
            OfflineWeaver.showUsage(mainClass);
            return;
        }
        String directory = ".";
        int index = 0;
        if (args[0].equals("-d")) {
            if (args.length < 4) {
                OfflineWeaver.showUsage(mainClass);
                return;
            }
            directory = args[1];
            index = 2;
        }
        String[] srcDirs = new String[]{"."};
        OfflineWeaver w = OfflineWeaver.make(args[index], srcDirs);
        w.setDirectory(directory);
        String[] fileNames = new String[args.length - index - 1];
        for (int i = index + 1; i < args.length; ++i) {
            fileNames[i - index - 1] = args[i];
        }
        w.transformFiles(null, fileNames);
    }

    public static OfflineWeaver make(String glueName, String[] classpath) throws NotFoundException, WeaveException {
        try {
            return new OfflineWeaver(glueName, classpath);
        }
        catch (NotFoundException e) {
            OfflineWeaver.printError("cannot find a glue " + glueName);
            throw e;
        }
        catch (WeaveException e) {
            OfflineWeaver.printError("cannot read a glue " + glueName);
            throw e;
        }
    }

    private static void showUsage(String mainClass) {
        System.err.println("Usage: java " + mainClass + " [ -d <output direcotry> ]" + " <glue class name> <java class file> ...");
    }

    public static void showTransformError(String className, WeaveException e) {
        String msg = "cannot transform a class: " + className.replace('/', '.');
        OfflineWeaver.printError(msg);
        System.err.println("  by " + e);
    }

    private static void printError(String msg) {
        System.err.println("GluonJ Error: " + msg);
    }

    static class Weaver2
    extends Weaver {
        Weaver2(String glueName, ClassPool cp, ClassLoader cl) throws NotFoundException, WeaveException {
            super(glueName, cp, cl);
        }

        protected void runInspectors(CtClass clazz) throws WeaveException {
        }

        protected void runInspectors0(CtClass clazz) throws WeaveException {
            super.runInspectors(clazz);
        }

        ClassPool getSrcPool() {
            return this.srcPool;
        }
    }
}

