/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.util.HashMap;
import java.util.Map;
import org.ujac.chart.BarChart2D;
import org.ujac.chart.Chart;
import org.ujac.chart.ChartAttributes;
import org.ujac.chart.ChartException;
import org.ujac.chart.ChartModel;
import org.ujac.chart.DonutChart3D;
import org.ujac.chart.LineChart2D;
import org.ujac.chart.PieChart2D;
import org.ujac.chart.PieChart3D;
import org.ujac.chart.StackedAreaChart2D;
import org.ujac.chart.StackedBarChart2D;

public class ChartFactory {
    private static final Map CHART_TYPES = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void registerChart(String name, Class clazz) {
        Map map = CHART_TYPES;
        synchronized (map) {
            CHART_TYPES.put(name, clazz);
        }
    }

    public static Chart createChart(String type) throws ChartException {
        return ChartFactory.createChart(type, null, null);
    }

    public static Chart createChart(String type, ChartModel model, ChartAttributes attributes) throws ChartException {
        try {
            Class clazz = (Class)CHART_TYPES.get(type);
            Chart chart = (Chart)clazz.newInstance();
            chart.setModel(model);
            chart.setAttributes(attributes);
            return chart;
        }
        catch (IllegalAccessException ex) {
            throw new ChartException("The chart type '" + type + "' is not allowed to be accessed: " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new ChartException("The chart type '" + type + "' cannot get instanciated: " + ex.getMessage(), ex);
        }
    }

    static {
        ChartFactory.registerChart("bar-2d", BarChart2D.class);
        ChartFactory.registerChart("stacked-bar-2d", StackedBarChart2D.class);
        ChartFactory.registerChart("line-2d", LineChart2D.class);
        ChartFactory.registerChart("stacked-area-2d", StackedAreaChart2D.class);
        ChartFactory.registerChart("pie-2d", PieChart2D.class);
        ChartFactory.registerChart("pie-3d", PieChart3D.class);
        ChartFactory.registerChart("donut-3d", DonutChart3D.class);
    }
}

