/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import org.ujac.chart.BasePieChart;

public class PieChart2D
extends BasePieChart {
    protected int getNumDrawingSteps() {
        return 1;
    }

    protected void drawSlice(Graphics2D graphics, Color color, int sliceIdx, int stepIdx) {
        double deltaY = this.getDeltaY();
        double startAngle = this.startAngles[sliceIdx];
        double angleDiff = this.angleDiffs[sliceIdx];
        double startArc = this.startArcs[sliceIdx];
        double endArc = this.endArcs[sliceIdx];
        double pieWidth = this.getPieSize().getWidth();
        double pieHeight = this.getPieSize().getHeight();
        AffineTransform rotate = new AffineTransform();
        Line2D.Double startLine = new Line2D.Double(0.0, this.halfPieHeight, 0.0, this.halfPieHeight);
        PathIterator pIterStart = startLine.getPathIterator(rotate);
        rotate.rotate(-startArc);
        double[] coordFrom = new double[2];
        pIterStart.currentSegment(coordFrom);
        coordFrom[0] = coordFrom[0] / deltaY;
        rotate = new AffineTransform();
        rotate.rotate(-endArc);
        double[] coordTo = new double[2];
        pIterStart.currentSegment(coordTo);
        coordTo[0] = coordTo[0] / deltaY;
        GeneralPath path = new GeneralPath();
        path.append(new Line2D.Double(coordTo[0], coordTo[1], 0.0, 0.0), true);
        path.append(new Arc2D.Double(-this.halfPieWidth, -this.halfPieHeight, pieWidth, pieHeight, startAngle, angleDiff, 0), true);
        path.append(new Line2D.Double(0.0, 0.0, coordFrom[0], coordFrom[1]), true);
        path.transform(this.moveToCenter);
        graphics.setColor(color);
        graphics.fill(path);
    }

    protected void drawSliceShadow(Graphics2D graphics, Color color, int sliceIdx) {
        double deltaY = this.getDeltaY();
        double startAngle = this.startAngles[sliceIdx];
        double angleDiff = this.angleDiffs[sliceIdx];
        double startArc = this.startArcs[sliceIdx];
        double endArc = this.endArcs[sliceIdx];
        double pieWidth = this.getPieSize().getWidth();
        double pieHeight = this.getPieSize().getHeight();
        AffineTransform rotate = new AffineTransform();
        Line2D.Double startLine = new Line2D.Double(0.0, this.halfPieHeight, 0.0, this.halfPieHeight);
        PathIterator pIterStart = startLine.getPathIterator(rotate);
        rotate.rotate(-startArc);
        double[] coordFrom = new double[2];
        pIterStart.currentSegment(coordFrom);
        coordFrom[0] = coordFrom[0] / deltaY;
        rotate = new AffineTransform();
        rotate.rotate(-endArc);
        double[] coordTo = new double[2];
        pIterStart.currentSegment(coordTo);
        coordTo[0] = coordTo[0] / deltaY;
        GeneralPath path = new GeneralPath();
        path.append(new Line2D.Double(coordTo[0], coordTo[1], 0.0, 0.0), true);
        path.append(new Arc2D.Double(-this.halfPieWidth, -this.halfPieHeight, pieWidth, pieHeight, startAngle, angleDiff, 0), true);
        path.append(new Line2D.Double(0.0, 0.0, coordFrom[0], coordFrom[1]), true);
        path.transform(this.moveToCenter);
        graphics.setColor(color);
        graphics.fill(path);
    }
}

