/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.ujac.chart.BaseChartItem;
import org.ujac.chart.ChartItemPosition;

public class TextChartItem
extends BaseChartItem {
    public static final Color DEFAULT_TEXT_COLOR = Color.black;
    private String text = null;
    private List textSegments = new ArrayList();
    private int maxWidth = 0;
    private Font font = null;
    private Color color = null;
    private int hAlign = 1;
    private boolean rotate = false;

    public TextChartItem(ChartItemPosition position, String text, Font font) {
        this(position, (int)position.getHorizontalPositionMode(), text, font, null);
    }

    public TextChartItem(ChartItemPosition position, String text, Font font, Color color, boolean rotate) {
        this(position, (int)position.getHorizontalPositionMode(), text, font, color);
        this.rotate = rotate;
    }

    public TextChartItem(ChartItemPosition position, String text, Font font, Color color) {
        this(position, (int)position.getHorizontalPositionMode(), text, font, color);
    }

    public TextChartItem(ChartItemPosition position, int hAlign, String text, Font font) {
        this(position, 0, hAlign, text, font, null);
    }

    public TextChartItem(ChartItemPosition position, int hAlign, String text, Font font, Color color) {
        this(position, 0, hAlign, text, font, color);
    }

    public TextChartItem(ChartItemPosition position, int maxWidth, int hAlign, String text, Font font) {
        this(position, maxWidth, hAlign, text, font, null);
    }

    public TextChartItem(ChartItemPosition position, int maxWidth, int hAlign, String text, Font font, Color color) {
        super(position);
        this.maxWidth = maxWidth;
        this.hAlign = hAlign;
        this.text = text;
        this.font = font;
        this.color = color == null ? DEFAULT_TEXT_COLOR : color;
    }

    public String getText() {
        return this.text;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getHAlign() {
        return this.hAlign;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean getRotate() {
        return this.rotate;
    }

    public TextChartItem setRotate(boolean rotate) {
        this.rotate = rotate;
        return this;
    }

    public Rectangle2D calculateOutputArea(Rectangle2D viewport, Graphics2D graphics) {
        int xPos = 0;
        int yPos = 0;
        Font oldFont = graphics.getFont();
        graphics.setFont(this.font);
        Rectangle2D textMetrics = graphics.getFontMetrics().getStringBounds(this.text, graphics);
        int maxWidth = this.maxWidth;
        if (textMetrics.getWidth() > viewport.getWidth() && (maxWidth == 0 || (double)maxWidth > viewport.getWidth())) {
            maxWidth = (int)viewport.getWidth();
        }
        double width = 0.0;
        double height = 0.0;
        if (maxWidth > 0 && textMetrics.getWidth() > (double)maxWidth || this.text.indexOf(10) != -1) {
            char[] textChars = this.text.toCharArray();
            int segmentOffset = 0;
            int lastWhitespace = 0;
            double yOffset = 0.0;
            block15: for (int i = 0; i < textChars.length; ++i) {
                char c = textChars[i];
                switch (c) {
                    case '\t': 
                    case ' ': {
                        String segmentText = new String(textChars, segmentOffset, i - segmentOffset);
                        Rectangle2D segmentMetrics = graphics.getFontMetrics().getStringBounds(segmentText, graphics);
                        if (maxWidth > 0 && segmentMetrics.getWidth() > (double)maxWidth) {
                            if (lastWhitespace > 0) {
                                for (int j = lastWhitespace; j > segmentOffset; --j) {
                                    if (textChars[j] != '(' && textChars[j] != '[') continue;
                                    lastWhitespace = j - 1;
                                    break;
                                }
                                segmentText = new String(textChars, segmentOffset, lastWhitespace - segmentOffset + 1).trim();
                                segmentMetrics = graphics.getFontMetrics().getStringBounds(segmentText, graphics);
                                this.textSegments.add(new TextSegment(segmentText, 0.0, yOffset, segmentMetrics.getWidth(), segmentMetrics.getHeight()));
                                yOffset += segmentMetrics.getHeight();
                                height += segmentMetrics.getHeight();
                                width = Math.max(width, segmentMetrics.getWidth());
                                segmentOffset = lastWhitespace + 1;
                                lastWhitespace = 0;
                            } else {
                                this.textSegments.add(new TextSegment(segmentText, 0.0, yOffset, segmentMetrics.getWidth(), segmentMetrics.getHeight()));
                                yOffset += segmentMetrics.getHeight();
                                height += segmentMetrics.getHeight();
                                width = Math.max(width, segmentMetrics.getWidth());
                                segmentOffset = i + 1;
                                lastWhitespace = 0;
                            }
                        }
                        lastWhitespace = --i;
                        continue block15;
                    }
                    case '\r': {
                        continue block15;
                    }
                    case '\n': {
                        String segmentText = new String(textChars, segmentOffset, i - segmentOffset).trim();
                        Rectangle2D segmentMetrics = graphics.getFontMetrics().getStringBounds(segmentText, graphics);
                        this.textSegments.add(new TextSegment(segmentText, 0.0, yOffset, segmentMetrics.getWidth(), segmentMetrics.getHeight()));
                        yOffset += segmentMetrics.getHeight();
                        height += segmentMetrics.getHeight();
                        width = Math.max(width, segmentMetrics.getWidth());
                        segmentOffset = i + 1;
                        lastWhitespace = 0;
                    }
                }
            }
            if (segmentOffset < textChars.length) {
                String segmentText = new String(textChars, segmentOffset, textChars.length - segmentOffset).trim();
                Rectangle2D segmentMetrics = graphics.getFontMetrics().getStringBounds(segmentText, graphics);
                if (maxWidth > 0 && segmentMetrics.getWidth() > (double)maxWidth) {
                    if (lastWhitespace > 0) {
                        for (int j = lastWhitespace; j > segmentOffset; --j) {
                            if (textChars[j] != '(' && textChars[j] != '[') continue;
                            lastWhitespace = j - 1;
                            break;
                        }
                        segmentText = new String(textChars, segmentOffset, lastWhitespace - segmentOffset + 1).trim();
                        segmentMetrics = graphics.getFontMetrics().getStringBounds(segmentText, graphics);
                        this.textSegments.add(new TextSegment(segmentText, 0.0, yOffset, segmentMetrics.getWidth(), segmentMetrics.getHeight()));
                        yOffset += segmentMetrics.getHeight();
                        height += segmentMetrics.getHeight();
                        width = Math.max(width, segmentMetrics.getWidth());
                        segmentOffset = lastWhitespace + 1;
                        segmentText = new String(textChars, segmentOffset, textChars.length - segmentOffset);
                        segmentMetrics = graphics.getFontMetrics().getStringBounds(segmentText, graphics);
                        this.textSegments.add(new TextSegment(segmentText, 0.0, yOffset, segmentMetrics.getWidth(), segmentMetrics.getHeight()));
                        height += segmentMetrics.getHeight();
                        width = Math.max(width, segmentMetrics.getWidth());
                    } else {
                        this.textSegments.add(new TextSegment(segmentText, 0.0, yOffset, segmentMetrics.getWidth(), segmentMetrics.getHeight()));
                        yOffset += segmentMetrics.getHeight();
                        height += segmentMetrics.getHeight();
                        width = Math.max(width, segmentMetrics.getWidth());
                    }
                } else {
                    this.textSegments.add(new TextSegment(segmentText, 0.0, yOffset, segmentMetrics.getWidth(), segmentMetrics.getHeight()));
                    width = Math.max(width, segmentMetrics.getWidth());
                    yOffset += segmentMetrics.getHeight();
                    height += segmentMetrics.getHeight();
                }
            }
        } else {
            width = textMetrics.getWidth();
            height = textMetrics.getHeight();
            this.textSegments.add(new TextSegment(this.text, 0.0, 0.0, width, height));
        }
        switch (this.position.getHorizontalPositionMode()) {
            case 0: {
                xPos = (int)this.position.getX();
                break;
            }
            case 2: {
                xPos = (int)(viewport.getCenterX() - width / 2.0);
                break;
            }
            case 3: {
                xPos = (int)(viewport.getX() + viewport.getWidth() - width);
                break;
            }
            default: {
                xPos = (int)viewport.getX();
            }
        }
        switch (this.position.getVerticalPositionMode()) {
            case 0: {
                yPos = (int)(viewport.getY() + this.position.getY());
                break;
            }
            case 5: {
                yPos = (int)(viewport.getCenterY() - height / 2.0);
                break;
            }
            case 6: {
                yPos = (int)(viewport.getY() + viewport.getHeight() - height);
                break;
            }
            default: {
                yPos = (int)viewport.getY();
            }
        }
        graphics.setFont(oldFont);
        if (this.rotate) {
            return new Rectangle(xPos, yPos, (int)height, (int)width);
        }
        return new Rectangle(xPos, yPos, (int)width, (int)height);
    }

    public void draw(Rectangle2D viewport, Graphics2D graphics) {
        Rectangle2D area = this.getOutputArea(viewport, graphics);
        int xOffset = 0;
        int yOffset = 0;
        xOffset = (int)area.getX();
        TextSegment firstSegment = (TextSegment)this.textSegments.get(0);
        switch (this.position.getHorizontalPositionMode()) {
            case 0: {
                xOffset = (int)area.getX();
                break;
            }
            case 2: {
                xOffset = (int)(viewport.getCenterX() - area.getWidth() / 2.0);
                break;
            }
            case 3: {
                xOffset = (int)(viewport.getMinX() + viewport.getWidth() - area.getWidth());
                break;
            }
            default: {
                xOffset = (int)viewport.getMinX();
            }
        }
        switch (this.position.getVerticalPositionMode()) {
            case 4: {
                if (this.rotate) {
                    yOffset = (int)(area.getCenterY() - area.getWidth() / 2.0 + firstSegment.getHeight());
                    break;
                }
                yOffset = (int)(viewport.getMinY() + firstSegment.getHeight());
                break;
            }
            case 6: {
                yOffset = (int)(viewport.getMaxY() - area.getHeight() + firstSegment.getHeight());
                break;
            }
            case 5: {
                if (this.rotate) {
                    yOffset = (int)(area.getCenterY() - area.getWidth() / 2.0 + firstSegment.getHeight());
                    break;
                }
                yOffset = (int)(area.getCenterY() - area.getHeight() / 2.0 + firstSegment.getHeight());
                break;
            }
            case 0: {
                yOffset = (int)(area.getY() + firstSegment.getHeight());
                break;
            }
            default: {
                yOffset = (int)(viewport.getMaxY() - area.getHeight() + firstSegment.getHeight());
            }
        }
        Graphics2D g = graphics;
        if (this.rotate) {
            g = (Graphics2D)graphics.create();
            g.rotate(4.71238898038469, area.getCenterX(), area.getCenterY());
        }
        g.setFont(this.font);
        g.setColor(this.color);
        int xPos = 0;
        int yPos = 0;
        int numSegments = this.textSegments.size();
        for (int i = 0; i < numSegments; ++i) {
            TextSegment segment = (TextSegment)this.textSegments.get(i);
            xPos = (int)((double)xOffset + segment.getXOffset());
            yPos = (int)((double)yOffset + segment.getYOffset());
            switch (this.hAlign) {
                case 3: {
                    if (this.rotate) {
                        xPos += (int)(area.getHeight() / 2.0 + area.getWidth() / 2.0 - segment.getWidth());
                        break;
                    }
                    xPos += (int)(area.getWidth() - segment.getWidth());
                    break;
                }
                case 2: {
                    xPos += (int)((area.getWidth() - segment.getWidth()) / 2.0);
                }
            }
            g.drawString(segment.getSegmentText(), xPos, yPos);
        }
        if (this.rotate) {
            g.dispose();
        }
    }

    private class TextSegment {
        private String segmentText;
        private double xOffset;
        private double yOffset;
        private double width;
        private double height;

        public TextSegment(String segmentText, double xOffset, double yOffset, double width, double height) {
            this.segmentText = segmentText;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.width = width;
            this.height = height;
        }

        public double getHeight() {
            return this.height;
        }

        public String getSegmentText() {
            return this.segmentText;
        }

        public double getWidth() {
            return this.width;
        }

        public double getXOffset() {
            return this.xOffset;
        }

        public double getYOffset() {
            return this.yOffset;
        }
    }
}

