/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.ujac.print.AttributeDefinition;

public class AttributeDefinitionMap
extends HashMap {
    private static final long serialVersionUID = 6712410303870062267L;

    public AttributeDefinitionMap() {
    }

    public AttributeDefinitionMap(AttributeDefinition attrDef) {
        this.addDefinition(attrDef);
    }

    public AttributeDefinitionMap addDefinition(AttributeDefinition attrDef) {
        this.put(attrDef.getName(), attrDef);
        Iterator iterLocalAliases = attrDef.getAliases().iterator();
        String aliasName = null;
        while (iterLocalAliases.hasNext()) {
            aliasName = iterLocalAliases.next().toString();
            this.put(aliasName, attrDef);
        }
        return this;
    }

    public AttributeDefinitionMap removeDefinition(AttributeDefinition attrDef) {
        this.remove(attrDef.getName());
        Iterator iterLocalAliases = attrDef.getAliases().iterator();
        String aliasName = null;
        while (iterLocalAliases.hasNext()) {
            aliasName = iterLocalAliases.next().toString();
            this.remove(aliasName);
        }
        return this;
    }

    public AttributeDefinitionMap(AttributeDefinitionMap attrDefMap) {
        this.putAll(attrDefMap);
    }

    public List getSortedAttributeNames() {
        ArrayList attributeNames = new ArrayList(this.keySet());
        Collections.sort(attributeNames, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String a1 = (String)arg0;
                String a2 = (String)arg1;
                return a1.compareTo(a2);
            }
        });
        return attributeNames;
    }

    public List getSortedAttributes() {
        ArrayList attributes = new ArrayList(this.values());
        Collections.sort(attributes, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                AttributeDefinition a1 = (AttributeDefinition)arg0;
                AttributeDefinition a2 = (AttributeDefinition)arg1;
                return a1.getName().compareTo(a2.getName());
            }
        });
        return attributes;
    }
}

