/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.AttributeHandler;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.Condition;
import org.ujac.print.ContentFilter;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.DynamicContentContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PhraseHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.StyleParser;
import org.ujac.print.TagAttributeException;
import org.ujac.print.TagInstantiationException;
import org.ujac.print.TypedAttributeHandler;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.BeanUtils;
import org.ujac.util.CollectionUtils;
import org.ujac.util.StringUtils;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.template.TemplateException;
import org.ujac.util.xml.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

public abstract class BaseDocumentTag {
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    public static final String IMAGE_CHUNK_ATTR = "IMAGE";
    public static final String NUMBER_OF_PAGES_TEMPLATES = "UJAC_NUMBER_OF_PAGES_TEMPLATES";
    public static final String DEFAULT_FONT_FAMILY = "Helvetica";
    public static final String DEFAULT_FONT_ENCODING = "Cp1252";
    public static final float DEFAULT_FONT_SIZE = 10.0f;
    public static final Color DEFAULT_FONT_COLOR = Color.black;
    public static final int DEFAULT_FONT_STYLE = 0;
    public static DocumentFont DEFAULT_FONT = new DocumentFont(FontFactory.getFont((String)"Helvetica", (String)"Cp1252", (float)10.0f, (int)0, (Color)DEFAULT_FONT_COLOR), "Helvetica", "Cp1252", 10.0f, 0, DEFAULT_FONT_COLOR);
    public static final float DEFAULT_LEADING = 0.0f;
    public static final float DEFAULT_LINE_SPACING = 1.2f;
    private static final Map colorMap = new HashMap();
    protected Log log = null;
    protected DocumentHandler documentHandler = null;
    protected DocumentTagFactory tagFactory = null;
    protected int depth = 0;
    protected AttributeDefinitionMap supportedAttributeMap = null;
    protected AttributeDefinitionMap supportedStyleAttributeMap = null;
    protected ChildDefinitionMap supportedChildMap = null;
    private String name = null;
    protected Attributes attributes = null;
    protected Map customAttributes = null;
    protected String actualContent = null;
    protected StringBuffer content = null;
    protected BaseDocumentTag parentItem = null;
    protected BaseDocumentTag previousItem = null;
    protected Condition condition = null;
    private Locator locator = null;
    private FontHolder fontHolder = null;
    private boolean ignoreFlush = false;
    private XMLReader dynamicContentXmlReader = null;
    private boolean itemOpened = false;
    private boolean itemClosed = false;
    private boolean trimBody = true;
    private boolean trimNextHead = false;
    private boolean evaluateXml = true;
    private DocumentFont localFont = null;
    private Color backgroundColor = null;
    private String styleClass = null;
    private String style = null;
    private String renderedAttr = null;
    private boolean rendered = true;
    protected StyleHolder styleParent = null;
    private Map styleAttributes = null;
    private StyleParser styleParser = null;
    private AttributeHandler attributeHandler = null;
    private CommonAttributesHolder commonAttributesHolder = null;

    public BaseDocumentTag() {
    }

    public BaseDocumentTag(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public abstract String getDescription();

    public String getExamples() {
        return null;
    }

    public AttributeDefinitionMap getSupportedAttributes() {
        AttributeDefinitionMap attrDefs;
        if (this.supportedAttributeMap != null) {
            return this.supportedAttributeMap;
        }
        this.supportedAttributeMap = attrDefs = this.documentHandler.getSupportedAttributes(this);
        return attrDefs;
    }

    public AttributeDefinitionMap getSupportedStyleAttributes() {
        AttributeDefinitionMap attrDefs;
        if (this.supportedStyleAttributeMap != null) {
            return this.supportedStyleAttributeMap;
        }
        this.supportedStyleAttributeMap = attrDefs = this.documentHandler.getSupportedStyleAttributes(this);
        return attrDefs;
    }

    public ChildDefinitionMap getSupportedChilds() {
        ChildDefinitionMap childDefs;
        if (this.supportedChildMap != null) {
            return this.supportedChildMap;
        }
        this.supportedChildMap = childDefs = this.documentHandler.getSupportedChilds(this);
        return childDefs;
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return new AttributeDefinitionMap().addDefinition(CommonAttributes.ID);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return new AttributeDefinitionMap();
    }

    protected ChildDefinitionMap buildSupportedChilds() {
        return new ChildDefinitionMap();
    }

    public List getSortedAttributeDefinitions() {
        AttributeDefinitionMap attrMap = this.getSupportedAttributes();
        if (attrMap == null) {
            return null;
        }
        return attrMap.getSortedAttributes();
    }

    public List getSortedStyleAttributeDefinitions() {
        AttributeDefinitionMap attrMap = this.getSupportedStyleAttributes();
        if (attrMap == null) {
            return null;
        }
        return attrMap.getSortedAttributes();
    }

    public boolean isVirtualContainer() {
        return false;
    }

    public boolean isDocumentRoot() {
        return false;
    }

    public boolean isTextBodyAllowed() {
        return false;
    }

    public boolean isStructureChecksDisabled() {
        return false;
    }

    public List getSupportedChildTags() throws TagInstantiationException {
        return this.tagFactory.getSupportedChildTags(this);
    }

    public DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    protected void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
        this.attributeHandler = documentHandler.getAttributeHandler();
        this.styleParser = documentHandler.getStyleParser();
        this.log = documentHandler.getLog();
    }

    public DocumentTagFactory getTagFactory() {
        return this.tagFactory;
    }

    protected void setTagFactory(DocumentTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public int getDepth() {
        return this.depth;
    }

    protected void setDepth(int depth) {
        this.depth = depth;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    protected void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public Map getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(Map customAttributes) {
        this.customAttributes = customAttributes;
    }

    public BaseDocumentTag getParentItem() {
        return this.parentItem;
    }

    public void setParentItem(BaseDocumentTag item) {
        this.parentItem = item;
        if (item != null) {
            item.setItemOpened(false);
        }
    }

    public BaseDocumentTag getPreviousItem() {
        return this.previousItem;
    }

    protected void setPreviousItem(BaseDocumentTag item) {
        this.previousItem = item;
    }

    public void setItemOpened(boolean itemOpened) {
        this.itemOpened = itemOpened;
    }

    public boolean isItemOpened() {
        return this.itemOpened;
    }

    public boolean isTrimBody() {
        return this.trimBody;
    }

    public void setTrimBody(boolean trimBody) {
        this.trimBody = trimBody;
    }

    public void setTrimNextHead(boolean trimNextHead) {
        this.trimNextHead = trimNextHead && this.trimBody;
    }

    public boolean isTrimNextHead() {
        return this.trimNextHead;
    }

    public void setItemClosed(boolean itemClosed) {
        this.itemClosed = itemClosed;
    }

    public boolean isItemClosed() {
        return this.itemClosed;
    }

    public Locator locator() {
        return this.locator;
    }

    public void preInitialize() throws DocumentHandlerException {
    }

    public void initialize() throws DocumentHandlerException {
        this.supportedAttributeMap = this.getSupportedAttributes();
        if (this.supportedAttributeMap == null) {
            this.supportedAttributeMap = new AttributeDefinitionMap();
        }
        this.supportedStyleAttributeMap = this.getSupportedStyleAttributes();
        if (this.supportedStyleAttributeMap == null) {
            this.supportedStyleAttributeMap = new AttributeDefinitionMap();
        } else if (this.supportedStyleAttributeMap.containsKey(CommonStyleAttributes.FONT_NAME.getName())) {
            try {
                this.supportedStyleAttributeMap.addDefinition(CommonStyleAttributes.FONT_COLOR);
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                this.supportedStyleAttributeMap.addDefinition(CommonStyleAttributes.FONT_ENCODING);
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                this.supportedStyleAttributeMap.addDefinition(CommonStyleAttributes.FONT_FAMILY);
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                this.supportedStyleAttributeMap.addDefinition(CommonStyleAttributes.FONT_NAME);
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                this.supportedStyleAttributeMap.addDefinition(CommonStyleAttributes.FONT_SIZE);
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                this.supportedStyleAttributeMap.addDefinition(CommonStyleAttributes.FONT_STYLE);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.renderedAttr = this.getStringAttribute(CommonAttributes.RENDERED, false, null);
        this.condition = this.documentHandler.latestCondition();
        this.styleParent = (StyleHolder)((Object)this.documentHandler.latestOfType(StyleHolder.class));
        this.commonAttributesHolder = this.documentHandler.latestCommonAttributesHolder();
        if (this.locator == null) {
            this.locator = new LocatorImpl(this.documentHandler.locator());
        }
        this.fontHolder = this.documentHandler.latestFontHolder();
        this.checkAttributes();
    }

    protected void checkAttributes() throws TagAttributeException {
        int numAttributes = this.attributes.getLength();
        for (int i = 0; i < numAttributes; ++i) {
            String attrName = this.attributes.getLocalName(i);
            AttributeDefinition attrDef = (AttributeDefinition)this.supportedAttributeMap.get(attrName);
            if (attrDef == null) {
                StringBuffer messageBuf = new StringBuffer("Unsupported attribute '").append(attrName).append("' for item ").append(this.getName());
                if (this.supportedAttributeMap.size() == 0) {
                    messageBuf.append(". This tag doesn't support any attribute.");
                } else {
                    messageBuf.append(". Supported attributes are: ");
                    List attributeNames = this.supportedAttributeMap.getSortedAttributeNames();
                    int numAttributeNames = attributeNames.size();
                    for (int j = 0; j < numAttributeNames; ++j) {
                        if (j > 0) {
                            messageBuf.append(", ");
                        }
                        messageBuf.append(attributeNames.get(j));
                    }
                    messageBuf.append(".");
                }
                throw new TagAttributeException(this.locator(), messageBuf.toString());
            }
            String deprecation = attrDef.getDeprecation();
            if (deprecation == null) continue;
            this.log.warn((Object)("At line " + this.locator().getLineNumber() + ": Detected usage of deprecated attribute '" + attrName + "' for tag <" + this.getName() + ">: " + deprecation));
        }
    }

    public void resetContent() {
        if (this.content != null) {
            this.actualContent = this.content.toString();
            this.content.setLength(0);
        }
    }

    public void addContent(char[] content, int offset, int length) {
        char first;
        if (this.content == null) {
            this.content = new StringBuffer();
        }
        if (length == 1 && ((first = content[offset]) == '<' || first == '>')) {
            this.evaluateXml = false;
        }
        this.content.append(content, offset, length);
    }

    public void addContent(String content) {
        char first;
        if (this.content == null) {
            this.content = new StringBuffer();
        }
        if (content.length() == 1 && ((first = content.charAt(0)) == '<' || first == '>')) {
            this.evaluateXml = false;
        }
        this.content.append(content);
    }

    public boolean hasContent() {
        if (this.content == null) {
            return false;
        }
        return this.content.length() > 0;
    }

    public String getContent() {
        if (this.content == null) {
            return null;
        }
        return this.content.toString();
    }

    public String getActualContent() {
        return this.actualContent;
    }

    public String getTrimmedContent() {
        if (this.content == null) {
            return "";
        }
        return this.content.toString().trim();
    }

    public void flushContent() throws DocumentHandlerException {
    }

    protected void trimContentHead() {
        if (this.content == null) {
            return;
        }
        int length = this.content.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(this.content.charAt(i))) continue;
            if (i <= 0) break;
            this.content.delete(0, i);
            break;
        }
    }

    protected void trimContentTail() {
        int length;
        if (this.content == null) {
            return;
        }
        for (length = this.content.length(); length > 0 && Character.isWhitespace(this.content.charAt(length - 1)); --length) {
        }
        if (length > 0 && this.documentHandler.isTranslateEscapeSequences()) {
            int escapeCount = 0;
            for (int i = length - 1; i >= 0 && this.content.charAt(i) == '\\'; --i) {
                ++escapeCount;
            }
            if (escapeCount % 2 != 0) {
                ++length;
            }
        }
        this.content.setLength(length);
    }

    protected boolean isIgnoreFlush() {
        return this.ignoreFlush;
    }

    public boolean isAttributeSupported(String name) {
        AttributeDefinition attrDef = (AttributeDefinition)this.supportedAttributeMap.get(name);
        return attrDef != null;
    }

    public boolean isAttributeSupported(AttributeDefinition attrDef) {
        AttributeDefinition ad = (AttributeDefinition)this.supportedAttributeMap.get(attrDef.getName());
        return ad != null;
    }

    public boolean isAttributeSupported(String name, String styleName) {
        AttributeDefinition attrDef = null;
        if (name != null) {
            attrDef = (AttributeDefinition)this.supportedAttributeMap.get(name);
        }
        if (attrDef != null) {
            return true;
        }
        if (styleName != null) {
            attrDef = (AttributeDefinition)this.supportedStyleAttributeMap.get(styleName);
        }
        return attrDef != null;
    }

    public boolean isAttributeSupported(AttributeDefinition attrDef, AttributeDefinition styleAttrDef) {
        AttributeDefinition ad = null;
        if (attrDef != null) {
            ad = (AttributeDefinition)this.supportedAttributeMap.get(attrDef.getName());
        }
        if (ad != null) {
            return true;
        }
        if (styleAttrDef != null) {
            ad = (AttributeDefinition)this.supportedStyleAttributeMap.get(styleAttrDef.getName());
        }
        return ad != null;
    }

    public AttributeDefinition getAttributeDefinition(String name) {
        if (name == null) {
            return null;
        }
        AttributeDefinition attrDef = (AttributeDefinition)this.supportedAttributeMap.get(name);
        return attrDef;
    }

    protected void addAttributeDefinition(AttributeDefinition definition) {
        this.supportedAttributeMap.put(definition.getName(), definition);
    }

    public boolean isAttributeDefined(AttributeDefinition attrDef) {
        String name = attrDef.getName();
        String attrValue = this.attributes.getValue(name);
        if (attrValue != null) {
            return true;
        }
        return this.customAttributes != null && this.customAttributes.containsKey(name);
    }

    public boolean isAttributeDefined(String name) {
        String attrValue = this.attributes.getValue(name);
        if (attrValue != null) {
            return true;
        }
        return this.customAttributes != null && this.customAttributes.containsKey(name);
    }

    public boolean isAttributeDefined(String name, String styleName) {
        String attrValue = this.attributes.getValue(name);
        if (attrValue != null) {
            return true;
        }
        if (this.customAttributes != null && this.customAttributes.containsKey(name)) {
            return true;
        }
        return this.isStyleAttributeDefined(styleName);
    }

    public boolean isAttributeDefined(AttributeDefinition attrDef, AttributeDefinition styleAttrDef) {
        String styleAttrName = null;
        if (styleAttrDef == null) {
            return this.isAttributeDefined(attrDef);
        }
        styleAttrName = styleAttrDef.getName();
        String attrName = null;
        if (attrDef != null) {
            attrName = attrDef.getName();
        }
        return this.isAttributeDefined(attrName, styleAttrName);
    }

    public AttributeDefinition getStyleAttributeDefinition(String name) {
        if (name == null) {
            return null;
        }
        AttributeDefinition attrDef = (AttributeDefinition)this.supportedStyleAttributeMap.get(name);
        return attrDef;
    }

    protected void addStyleAttributeDefinition(AttributeDefinition definition) {
        this.supportedStyleAttributeMap.put(definition.getName(), definition);
    }

    public boolean isStyleAttributeDefined(String name) {
        Object attrValue = this.styleAttributes.get(name);
        return attrValue != null;
    }

    public Object evalAttribute(String name) throws TagAttributeException {
        AttributeDefinition attrDef = this.getAttributeDefinition(name);
        if (attrDef == null) {
            throw new TagAttributeException(this.locator(), "The attribute '" + name + "' is not supported for element '" + this.getName() + "'.");
        }
        String attrValue = this.attributes.getValue(name);
        try {
            return this.documentHandler.evalObject(attrValue);
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Failed to evaluate attribute '" + name + "' at the element '" + this.getName() + "'.", ex);
        }
    }

    public String getRawAttribute(String name) throws TagAttributeException {
        AttributeDefinition attrDef = this.getAttributeDefinition(name);
        if (attrDef == null) {
            throw new TagAttributeException(this.locator(), "The attribute '" + name + "' is not supported for element '" + this.getName() + "'.");
        }
        String attrValue = this.attributes.getValue(name);
        if (attrValue == null) {
            attrValue = (String)this.customAttributes.get(name);
        }
        return attrValue;
    }

    public Object evalAttribute(AttributeDefinition attrDef) throws TagAttributeException {
        String attrName = attrDef.getName();
        AttributeDefinition ad = this.getAttributeDefinition(attrName);
        if (ad == null) {
            throw new TagAttributeException(this.locator(), "The attribute '" + attrName + "' is not supported for element '" + this.getName() + "'.");
        }
        String attrValue = this.attributes.getValue(attrName);
        try {
            return this.documentHandler.evalObject(attrValue);
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Failed to evaluate attribute '" + attrName + "' at the element '" + this.getName() + "'.", ex);
        }
    }

    public Object getAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef, TypedAttributeHandler attrHandler) throws TagAttributeException {
        return this.getAttribute(attrDef, null, evaluate, styleAttrDef, attrHandler);
    }

    public Object getAttribute(AttributeDefinition attrDef, Object defaultValue, boolean evaluate, AttributeDefinition styleAttrDef, TypedAttributeHandler attrHandler) throws TagAttributeException {
        Object value;
        if (attrDef != null) {
            String name = attrDef.getName();
            String attrValue = this.attributes.getValue(name);
            if (attrValue == null && this.customAttributes != null) {
                attrValue = (String)this.customAttributes.get(name);
            }
            if (attrValue == null) {
                Iterator aliases = attrDef.getAliases().iterator();
                while (aliases.hasNext() && attrValue == null) {
                    String aliasName = aliases.next().toString();
                    attrValue = this.attributes.getValue(aliasName);
                    if (attrValue != null || this.customAttributes == null) continue;
                    attrValue = (String)this.customAttributes.get(aliasName);
                }
                if (attrValue == null && attrDef.isRequired()) {
                    throw new TagAttributeException(this.locator(), "The required attribute '" + name + "' was not defined for element '" + this.getName() + "'.");
                }
            }
            if (attrValue != null) {
                return attrHandler.parseAttribute(this.locator, name, attrValue, evaluate);
            }
        }
        if (styleAttrDef != null && (value = this.getStyleAttribute(styleAttrDef)) != null) {
            return attrHandler.parseAttribute(this.locator, styleAttrDef.getName(), value, false);
        }
        return defaultValue;
    }

    public Object getLocalAttribute(String name, boolean evaluate) throws TagAttributeException {
        String attrValue = this.attributes.getValue(name);
        if (attrValue == null && this.customAttributes != null) {
            attrValue = (String)this.customAttributes.get(name);
        }
        try {
            String value = attrValue;
            if (evaluate && attrValue != null) {
                return this.documentHandler.evalObject(attrValue);
            }
            return value;
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Expression evaluation failed: " + ex.getMessage(), ex);
        }
    }

    public boolean isStyleable() {
        return false;
    }

    public Object getStyleAttribute(String name) throws TagAttributeException {
        AttributeDefinition attrDef = this.getStyleAttributeDefinition(name);
        if (attrDef == null) {
            return null;
        }
        return this.getLocalStyleAttribute(name);
    }

    public Object getStyleAttribute(AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getLocalStyleAttribute(styleAttrDef.getName());
    }

    public Object getLocalStyleAttribute(String name) throws TagAttributeException {
        Object value;
        if (!this.isStyleable()) {
            return null;
        }
        if (this.styleAttributes != null && (value = this.styleAttributes.get(name)) != null) {
            return value;
        }
        if (this.styleParent != null) {
            return this.styleParent.getStyleAttribute(name);
        }
        return null;
    }

    public Map getStyleAttributes() {
        return this.styleAttributes;
    }

    public AttributeHandler getAttributeHandler() {
        return this.attributeHandler;
    }

    public String getTextAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getTextAttribute(attrDef, null, evaluate, styleAttrDef);
    }

    public String getTextAttribute(AttributeDefinition attrDef, String defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        String rawText = this.getStringAttribute(attrDef, defaultValue, evaluate, styleAttrDef);
        if (rawText == null) {
            return null;
        }
        return this.attributeHandler.parseTextAttribute(this.locator(), attrDef.getName(), rawText, evaluate, true);
    }

    public String getStringAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getStringAttribute(attrDef, null, evaluate, styleAttrDef);
    }

    public String getStringAttribute(AttributeDefinition attrDef, String defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, defaultValue, evaluate, styleAttrDef, this.attributeHandler.getTextHandler());
        return (String)attr;
    }

    public String getStringAttribute(String attrName, String defaultValue, boolean evaluate, String styleAttrName) throws TagAttributeException {
        AttributeDefinition attrDef = this.getAttributeDefinition(attrName);
        AttributeDefinition styleAttrDef = this.getStyleAttributeDefinition(styleAttrName);
        Object attr = this.getAttribute(attrDef, defaultValue, evaluate, styleAttrDef, this.attributeHandler.getTextHandler());
        return (String)attr;
    }

    public float getFloatAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getFloatAttribute(attrDef, 0.0f, evaluate, styleAttrDef);
    }

    public float getFloatAttribute(AttributeDefinition attrDef, float defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, new Float(defaultValue), evaluate, styleAttrDef, this.attributeHandler.getFloatHandler());
        return ((Number)attr).floatValue();
    }

    public float getDimensionAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getDimensionAttribute(attrDef, 0.0f, evaluate, styleAttrDef);
    }

    public float getDimensionAttribute(AttributeDefinition attrDef, float defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getDimensionAttribute(attrDef, new Float(defaultValue), evaluate, styleAttrDef);
    }

    public float getDimensionAttribute(AttributeDefinition attrDef, Float defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, defaultValue, evaluate, styleAttrDef, this.attributeHandler.getDimensionHandler());
        return ((Number)attr).floatValue();
    }

    public int getIntegerAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getIntegerAttribute(attrDef, 0, evaluate, styleAttrDef);
    }

    public int getIntegerAttribute(AttributeDefinition attrDef, int defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, new Integer(defaultValue), evaluate, styleAttrDef, this.attributeHandler.getIntegerHandler());
        return ((Number)attr).intValue();
    }

    public boolean getBooleanAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getBooleanAttribute(attrDef, false, evaluate, styleAttrDef);
    }

    public boolean getBooleanAttribute(AttributeDefinition attrDef, boolean defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, new Boolean(defaultValue), evaluate, styleAttrDef, this.attributeHandler.getBooleanHandler());
        return (Boolean)attr;
    }

    public Color getColorAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getColorAttribute(attrDef, null, evaluate, styleAttrDef);
    }

    public Color getColorAttribute(AttributeDefinition attrDef, Color defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, defaultValue, evaluate, styleAttrDef, this.attributeHandler.getColorHandler());
        return (Color)attr;
    }

    public int getBorderAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getBorderAttribute(attrDef, 0, evaluate, styleAttrDef);
    }

    public int getBorderAttribute(AttributeDefinition attrDef, int defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, new Integer(defaultValue), evaluate, styleAttrDef, this.attributeHandler.getBorderHandler());
        return ((Number)attr).intValue();
    }

    public int getHorizontalAlignmentAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getHorizontalAlignmentAttribute(attrDef, 0, evaluate, styleAttrDef);
    }

    public int getHorizontalAlignmentAttribute(AttributeDefinition attrDef, int defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, new Integer(defaultValue), evaluate, styleAttrDef, this.attributeHandler.getHorizontalAlignmentHandler());
        return ((Number)attr).intValue();
    }

    public int getVerticalAlignmentAttribute(AttributeDefinition attrDef, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        return this.getVerticalAlignmentAttribute(attrDef, 7, evaluate, styleAttrDef);
    }

    public int getVerticalAlignmentAttribute(AttributeDefinition attrDef, int defaultValue, boolean evaluate, AttributeDefinition styleAttrDef) throws TagAttributeException {
        Object attr = this.getAttribute(attrDef, new Integer(defaultValue), evaluate, styleAttrDef, this.attributeHandler.getVerticalAlignmentHandler());
        return ((Number)attr).intValue();
    }

    public void openItem() throws DocumentHandlerException {
        String localStyle;
        Map styles;
        this.itemOpened = true;
        this.itemClosed = false;
        this.evaluateXml = true;
        this.rendered = true;
        this.resetContent();
        if (!this.isValid()) {
            return;
        }
        if (this.isAttributeSupported(CommonAttributes.RENDERED) && !BeanUtils.isEmpty(this.renderedAttr)) {
            try {
                this.rendered = this.documentHandler.evalBoolean(this.renderedAttr);
            }
            catch (ExpressionException ex) {
                throw new DocumentHandlerException(this.locator(), "Failed to evaluate value '" + this.renderedAttr + "' of attribute 'rendered': " + ex.getMessage(), ex);
            }
        }
        if (!this.rendered) {
            return;
        }
        this.styleAttributes = new HashMap();
        this.styleClass = null;
        this.style = null;
        if (this.parentItem != null) {
            Map parentStyles = this.parentItem.getStyleAttributes();
            this.mergeStyleAttributes(parentStyles);
        }
        if (this.isAttributeSupported(CommonAttributes.CLASS)) {
            this.styleClass = this.getStringAttribute(CommonAttributes.CLASS, this.styleClass, true, null);
        }
        if ((styles = this.documentHandler.getStyle(this, this.styleClass)) != null) {
            this.mergeStyleAttributes(styles);
        }
        if (this.isAttributeSupported(CommonAttributes.STYLE) && (localStyle = this.getStringAttribute(CommonAttributes.STYLE, null, true, null)) != null) {
            this.style = localStyle;
            HashMap localStyles = new HashMap();
            this.styleParser.parseStyle(this.locator(), this.style, this.supportedStyleAttributeMap, localStyles);
            this.mergeStyleAttributes(localStyles);
        }
        if (this.isAttributeSupported(CommonAttributes.BACKGROUND_COLOR, CommonStyleAttributes.BACKGROUND_COLOR)) {
            this.setBackgroundColor(this.getColorAttribute(CommonAttributes.BACKGROUND_COLOR, true, CommonStyleAttributes.BACKGROUND_COLOR));
        }
        this.handleFontAttributes();
    }

    private void mergeStyleAttributes(Map styleAttrs) throws TagAttributeException {
        String fn = (String)CollectionUtils.get(styleAttrs, "font-name");
        if (fn != null) {
            DocumentFont df = this.documentHandler.getFont(fn);
            styleAttrs.remove("font-name");
            Color color = df.getColor();
            if (color != null) {
                this.styleAttributes.put("font-color", color);
            }
            this.styleAttributes.put("font-encoding", df.getEncoding());
            this.styleAttributes.put("font-family", df.getFamily());
            this.styleAttributes.put("font-size", Float.toString(df.getSize()));
            String fontStyle = this.int2FontStyle(df.getStyle());
            this.styleAttributes.put("font-style", fontStyle);
            this.styleAttributes.put("text-rise", Float.toString(df.getTextRise()));
        }
        CollectionUtils.putAll(this.styleAttributes, styleAttrs);
    }

    protected void handleFontAttributes() throws DocumentHandlerException {
        if (this.isAttributeSupported(CommonAttributes.FONT, CommonStyleAttributes.FONT_NAME)) {
            String encoding;
            String family;
            Color color;
            String fontDef = this.getStringAttribute(CommonAttributes.FONT, true, null);
            DocumentFont font = null;
            if (fontDef != null) {
                font = this.documentHandler.getFont(fontDef);
                this.setLocalFont(font);
                this.styleAttributes.remove("font-color");
                this.styleAttributes.remove("font-encoding");
                this.styleAttributes.remove("font-family");
                this.styleAttributes.remove("font-size");
                this.styleAttributes.remove("font-style");
                this.styleAttributes.remove("text-rise");
                return;
            }
            fontDef = this.getStringAttribute(null, true, CommonStyleAttributes.FONT_NAME);
            if (fontDef != null) {
                font = this.documentHandler.getFont(fontDef);
            }
            if ((color = this.getColorAttribute(null, false, CommonStyleAttributes.FONT_COLOR)) == null && font != null) {
                color = font.getColor();
            }
            if ((family = this.getStringAttribute(null, false, CommonStyleAttributes.FONT_FAMILY)) == null && font != null) {
                family = font.getFamily();
            }
            if ((encoding = this.getStringAttribute(null, false, CommonStyleAttributes.FONT_ENCODING)) == null && font != null) {
                encoding = font.getEncoding();
            }
            if (encoding == null) {
                encoding = DEFAULT_FONT_ENCODING;
            }
            float size = -1.0f;
            if (font != null) {
                size = font.getSize();
            }
            if (this.isAttributeDefined(null, CommonStyleAttributes.FONT_SIZE)) {
                size = this.getDimensionAttribute(null, false, CommonStyleAttributes.FONT_SIZE);
            } else if (font != null) {
                size = font.getSize();
            }
            String styleAttribute = this.getStringAttribute(null, false, CommonStyleAttributes.FONT_STYLE);
            int style = 0;
            if (styleAttribute != null) {
                style = Font.getStyleValue((String)styleAttribute);
            } else if (font != null) {
                style = font.getStyle();
            }
            float textRise = 0.0f;
            if (this.isAttributeDefined(null, CommonStyleAttributes.TEXT_RISE)) {
                textRise = this.getDimensionAttribute(null, false, CommonStyleAttributes.TEXT_RISE);
            } else if (font != null) {
                textRise = font.getTextRise();
            }
            if (family != null) {
                font = this.createFont(family, encoding, size, style, textRise, color);
                this.setLocalFont(font);
            }
        }
    }

    protected String int2FontStyle(int fontStyle) {
        StringBuffer styleBuf = new StringBuffer();
        if ((fontStyle & 1) != 0) {
            if (styleBuf.length() > 0) {
                styleBuf.append('|');
            }
            styleBuf.append("bold");
        }
        if ((fontStyle & 2) != 0) {
            if (styleBuf.length() > 0) {
                styleBuf.append('|');
            }
            styleBuf.append("italic");
        }
        if ((fontStyle & 4) != 0) {
            if (styleBuf.length() > 0) {
                styleBuf.append('|');
            }
            styleBuf.append("underline");
        }
        if ((fontStyle & 8) != 0) {
            if (styleBuf.length() > 0) {
                styleBuf.append('|');
            }
            styleBuf.append("strikethru");
        }
        if (styleBuf.length() == 0) {
            styleBuf.append("normal");
        }
        return styleBuf.toString();
    }

    public void closeItem() throws DocumentHandlerException {
    }

    public Phrase addChunk(Phrase phrase, float fixedLeading, float lineSpacing) throws DocumentHandlerException {
        try {
            DocumentFont docFont = this.getFont();
            float textRise = docFont.getTextRise();
            String content = this.getContent();
            int pageCountPos = this.checkPageCount(content);
            if (pageCountPos < 0) {
                return this.addChunk(this, phrase, this.documentHandler.executeTemplate(content), docFont, fixedLeading, lineSpacing);
            }
            String part1 = content.substring(0, pageCountPos);
            Phrase localPhrase = this.addChunk(this, phrase, this.documentHandler.executeTemplate(part1), docFont, fixedLeading, lineSpacing);
            PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
            try {
                Chunk ch = new Chunk(Image.getInstance((PdfTemplate)this.ensureNumberOfPagesTemplate(this.getFont(), writer.getDirectContent())), 0.0f, -1.0f);
                if (this.backgroundColor != null) {
                    ch.setBackground(this.backgroundColor);
                }
                if (textRise != 0.0f) {
                    ch.setTextRise(textRise);
                }
                localPhrase.add((Object)ch);
            }
            catch (BadElementException ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to add ${pageCount} to phase.");
            }
            String part2 = content.substring(pageCountPos + 12);
            return this.addChunk(this, localPhrase, this.documentHandler.executeTemplate(part2), docFont, fixedLeading, lineSpacing);
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Template evaluation failed: " + ex.getMessage(), ex);
        }
    }

    public void handleContent(PhraseHolder phraseHolder) throws DocumentHandlerException {
        try {
            DocumentFont docFont = this.getFont();
            float textRise = docFont.getTextRise();
            String content = this.getContent();
            int pageCountPos = this.checkPageCount(content);
            if (pageCountPos < 0) {
                phraseHolder.addChunk(this, this.documentHandler.executeTemplate(content), docFont);
                return;
            }
            String part1 = content.substring(0, pageCountPos);
            phraseHolder.addChunk(this, this.documentHandler.executeTemplate(part1), docFont);
            PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
            try {
                Chunk ch = new Chunk(Image.getInstance((PdfTemplate)this.ensureNumberOfPagesTemplate(this.getFont(), writer.getDirectContent())), 0.0f, -1.0f);
                if (this.backgroundColor != null) {
                    ch.setBackground(this.backgroundColor);
                }
                if (textRise != 0.0f) {
                    ch.setTextRise(textRise);
                }
                phraseHolder.addChunk(this, ch);
            }
            catch (BadElementException ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to add ${pageCount} to phase.");
            }
            String part2 = content.substring(pageCountPos + 12);
            phraseHolder.addChunk(this, this.documentHandler.executeTemplate(part2), docFont);
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Template evaluation failed: " + ex.getMessage(), ex);
        }
    }

    private int checkPageCount(String content) {
        if (content == null) {
            return -1;
        }
        return content.indexOf("${pageCount}");
    }

    public Phrase addChunk(Phrase phrase, Chunk chunk, float fixedLeading, float lineSpacing) {
        if (this.backgroundColor != null) {
            chunk.setBackground(this.backgroundColor);
        }
        phrase.add((Object)chunk);
        this.extendLeading(phrase, chunk, fixedLeading, lineSpacing);
        return phrase;
    }

    public Phrase addChunk(BaseDocumentTag tag, Phrase phrase, String chunk, DocumentFont font, float fixedLeading, float lineSpacing) throws DocumentHandlerException {
        Phrase localPhrase = phrase;
        if (localPhrase == null) {
            localPhrase = new Phrase(0.0f);
        }
        if (localPhrase.getChunks().size() == 0 && this.isEmptyString(chunk)) {
            return localPhrase;
        }
        this.processContents(tag, localPhrase, chunk, font, fixedLeading, lineSpacing);
        return localPhrase;
    }

    public Phrase processContents(float fixedLeading, float lineSpacing) throws DocumentHandlerException {
        try {
            DocumentFont docFont = this.getFont();
            String content = this.getContent();
            int pageCountPos = this.checkPageCount(content);
            if (pageCountPos < 0) {
                return this.processContents(this, null, this.documentHandler.executeTemplate(content), docFont, fixedLeading, lineSpacing);
            }
            String part1 = content.substring(0, pageCountPos);
            Phrase phrase = this.processContents(this, null, this.documentHandler.executeTemplate(part1), docFont, fixedLeading, lineSpacing);
            if (phrase == null) {
                phrase = new Phrase(0.0f);
            }
            PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
            try {
                Chunk ch = new Chunk(Image.getInstance((PdfTemplate)this.ensureNumberOfPagesTemplate(this.getFont(), writer.getDirectContent())), 0.0f, -1.0f);
                if (this.backgroundColor != null) {
                    ch.setBackground(this.backgroundColor);
                }
                phrase.add((Object)ch);
            }
            catch (BadElementException ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to add ${pageCount} to phase.");
            }
            String part2 = content.substring(pageCountPos + 12);
            return this.processContents(this, phrase, this.documentHandler.executeTemplate(part2), docFont, fixedLeading, lineSpacing);
        }
        catch (TemplateException ex) {
            throw new TagAttributeException(this.locator(), "Template evaluation failed: " + ex.getMessage(), ex);
        }
    }

    public Phrase processContents(BaseDocumentTag tag, Phrase phrase, String contents, DocumentFont font, float fixedLeading, float lineSpacing) throws DocumentHandlerException {
        if (this.isIgnoreFlush()) {
            return null;
        }
        if (contents == null || contents.length() == 0) {
            return phrase;
        }
        Phrase localPhrase = phrase;
        if (localPhrase == null) {
            localPhrase = new Phrase(0.0f);
        }
        int textLen = contents.length();
        char c = '\u0000';
        boolean parsePhrase = false;
        StringBuffer chunkBuf = new StringBuffer(textLen);
        this.filterContents(tag, contents, chunkBuf, this.isTrimNextHead());
        textLen = chunkBuf.length();
        int cDataBegin = -1;
        int cDataEnd = -1;
        if (this.documentHandler.isParseDynamicContent() && this.evaluateXml) {
            block3: for (int i = 0; i < textLen; ++i) {
                int curPos;
                c = chunkBuf.charAt(i);
                if (c == '<') {
                    if (textLen > i + 1 && chunkBuf.charAt(i + 1) == '!') {
                        int cDataBeginLen = CDATA_BEGIN.length();
                        for (int j = 0; j < cDataBeginLen; ++j) {
                            char cdc;
                            char cc = chunkBuf.charAt(i + j);
                            if (cc != (cdc = CDATA_BEGIN.charAt(j))) {
                                cDataBegin = -1;
                                cDataEnd = -1;
                                break;
                            }
                            if (j != cDataBeginLen - 1) continue;
                            cDataBegin = i + cDataBeginLen;
                            parsePhrase = false;
                        }
                        if (cDataBegin == -1) break;
                        block5: for (i = cDataBegin; i < textLen; ++i) {
                            c = chunkBuf.charAt(i);
                            if (c != ']' || chunkBuf.charAt(i + 1) != ']') continue;
                            int cDataEndLen = CDATA_END.length();
                            for (int j = 0; j < cDataEndLen; ++j) {
                                char cdc;
                                char cc = chunkBuf.charAt(i + j);
                                if (cc != (cdc = CDATA_END.charAt(j))) {
                                    cDataEnd = -1;
                                    continue block5;
                                }
                                if (j != cDataEndLen - 1) continue;
                                cDataEnd = i;
                                break block3;
                            }
                        }
                        break;
                    }
                    int startIdx = i;
                    while (i < textLen) {
                        c = chunkBuf.charAt(i);
                        if (c == '>') {
                            if (i - startIdx < 2) {
                                parsePhrase = false;
                                break block3;
                            }
                            parsePhrase = true;
                            break block3;
                        }
                        if (Character.isWhitespace(c)) {
                            parsePhrase = false;
                            break block3;
                        }
                        ++i;
                    }
                    continue;
                }
                if (c != '&' || textLen - (curPos = i) <= 3 || chunkBuf.charAt(i + 3) != ';') continue;
                parsePhrase = true;
                break;
            }
        }
        if (cDataBegin != -1 && cDataEnd != -1) {
            chunkBuf = new StringBuffer(chunkBuf.substring(cDataBegin, cDataEnd));
        }
        if (parsePhrase) {
            try {
                this.ignoreFlush = true;
                DynamicContentContainer dynamicContentContainer = this.documentHandler.getDynamicContentContainer();
                dynamicContentContainer.setContents(localPhrase);
                if (this.dynamicContentXmlReader == null) {
                    this.dynamicContentXmlReader = XmlUtils.createXmlReader(this.documentHandler.getXmlReaderClass());
                }
                this.dynamicContentXmlReader.setContentHandler(this.documentHandler);
                this.documentHandler.disableTemplateCopyWriter();
                String dynaContent = "<_DYNAMIC_CONTENT_>" + chunkBuf.toString() + "</" + "_DYNAMIC_CONTENT_" + ">";
                this.dynamicContentXmlReader.parse(new InputSource(new StringReader(dynaContent)));
                this.ignoreFlush = false;
                this.documentHandler.enableTemplateCopyWriter();
                return dynamicContentContainer.getContents();
            }
            catch (SAXException ex) {
                throw new DocumentHandlerException(tag.locator(), "Error while parsing expression result: " + ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new DocumentHandlerException(tag.locator(), "Error while parsing expression result: " + ex.getMessage(), ex);
            }
        }
        if (chunkBuf.length() > 0) {
            float textRise;
            Chunk chnk = null;
            chnk = font == null ? new Chunk(chunkBuf.toString()) : new Chunk(chunkBuf.toString(), font.getFont());
            if (this.backgroundColor != null) {
                chnk.setBackground(this.backgroundColor);
            }
            if ((textRise = font.getTextRise()) != 0.0f) {
                chnk.setTextRise(textRise);
            }
            this.addChunk(localPhrase, chnk, fixedLeading, lineSpacing);
        }
        return localPhrase;
    }

    protected void filterContents(BaseDocumentTag tag, String contents, StringBuffer buffer, boolean trimHead) throws DocumentHandlerException {
        ContentFilter contentFilter;
        int offset;
        int textLen = StringUtils.getLength(contents);
        if (trimHead) {
            char c;
            for (offset = 0; offset < textLen && Character.isWhitespace(c = contents.charAt(offset)); ++offset) {
            }
        }
        if ((contentFilter = this.documentHandler.getContentFilter()) != null) {
            contentFilter.filterContents(this, contents, offset, buffer);
        } else if (offset > 0) {
            buffer.append(contents.substring(offset));
        } else {
            buffer.append(contents);
        }
    }

    protected void extendLeading(Phrase phrase, float leading) {
        float currentLeading = phrase.getLeading();
        phrase.setLeading(Math.max(currentLeading, leading));
    }

    protected void extendLeading(Phrase phrase, Font font, float fixedLeading, float lineSpacing) {
        float currentLeading = phrase.getLeading();
        phrase.setLeading(Math.max(currentLeading, fixedLeading + font.getSize() * lineSpacing));
    }

    protected void extendLeading(Phrase phrase, Chunk extender, float fixedLeading, float lineSpacing) {
        Object image;
        HashMap chunkAttributes = extender.getAttributes();
        if (chunkAttributes != null && (image = chunkAttributes.get(IMAGE_CHUNK_ATTR)) != null) {
            Object[] imgData = (Object[])image;
            Image img = (Image)imgData[0];
            this.extendLeading(phrase, fixedLeading + img.getScaledHeight() * lineSpacing);
            return;
        }
        this.extendLeading(phrase, extender.getFont(), fixedLeading, lineSpacing);
    }

    protected void extendLeading(Phrase phrase, Phrase extender) {
        float currentLeading = phrase.getLeading();
        phrase.setLeading(Math.max(currentLeading, extender.getLeading()));
    }

    protected Chunk createChunk(String text, DocumentFont font) {
        float textRise;
        Chunk chunk = new Chunk(text, font.getFont());
        if (this.backgroundColor != null) {
            chunk.setBackground(this.backgroundColor);
        }
        if ((textRise = font.getTextRise()) != 0.0f) {
            chunk.setTextRise(textRise);
        }
        return chunk;
    }

    protected Color colorFromString(String attrName, Object color, boolean evaluate) throws TagAttributeException {
        if (color == null) {
            return null;
        }
        return this.attributeHandler.parseColorAttribute(this.locator(), attrName, color, evaluate);
    }

    public DocumentFont getFont() {
        if (this.localFont != null) {
            return this.localFont;
        }
        if (this.fontHolder != null) {
            return this.fontHolder.getFont();
        }
        return DEFAULT_FONT;
    }

    public DocumentFont getLocalFont() {
        return this.localFont;
    }

    protected void setLocalFont(DocumentFont localFont) {
        this.localFont = localFont;
    }

    protected void setLocalFont(String fontDef) throws TagAttributeException {
        if (fontDef != null) {
            this.setLocalFont(this.documentHandler.getFont(fontDef));
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public String getStyle() {
        return this.style;
    }

    protected void addToLatestElementContainer(Element element) throws DocumentHandlerException {
        this.documentHandler.latestElementContainer().addElement(this, element);
    }

    protected void addToLatestCellContainer(Cell cell) throws DocumentHandlerException {
        this.documentHandler.latestCellContainer().addCell(this, cell);
    }

    protected void addToLatestPdfCellContainer(PdfPCell cell) throws DocumentHandlerException {
        this.documentHandler.latestPdfCellContainer().addCell(this, cell);
    }

    protected boolean isEmptyContent() {
        StringBuffer cnt = this.content;
        if (cnt == null) {
            return true;
        }
        int len = cnt.length();
        for (int i = 0; i < len; ++i) {
            char c = cnt.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEmptyString(String text) {
        if (text == null) {
            return true;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValid() throws DocumentHandlerException {
        if (this.parentItem != null && !this.parentItem.isValid()) {
            return false;
        }
        if (this.condition != null) {
            return this.condition.isTrue();
        }
        return this.rendered;
    }

    protected boolean isRendered() {
        return this.rendered;
    }

    protected DocumentFont createFont(String family, String encoding, float size, int style, float textRise, Color color) throws DocumentHandlerException {
        return this.documentHandler.createFont(family, encoding, size, style, textRise, color);
    }

    protected float getPhraseWidth(Phrase item) {
        float width = 0.0f;
        if (item == null) {
            return width;
        }
        ArrayList chunks = item.getChunks();
        int numChunks = chunks.size();
        for (int i = 0; i < numChunks; ++i) {
            Object image;
            Chunk chunk = (Chunk)chunks.get(i);
            HashMap chunkAttributes = chunk.getAttributes();
            if (chunkAttributes != null && (image = chunkAttributes.get(IMAGE_CHUNK_ATTR)) != null) {
                Object[] imgData = (Object[])image;
                Image img = (Image)imgData[0];
                width += img.getScaledWidth();
                continue;
            }
            Font font = chunk.getFont();
            BaseFont bf = font.getBaseFont();
            String content = chunk.getContent();
            if (bf == null) continue;
            float chunkWidth = bf.getWidthPoint(content, font.getSize());
            width += chunkWidth;
        }
        return width;
    }

    protected float getPhraseHeight(Phrase item) {
        float height = 0.0f;
        ArrayList chunks = item.getChunks();
        int numChunks = chunks.size();
        for (int i = 0; i < numChunks; ++i) {
            Object image;
            Chunk chunk = (Chunk)chunks.get(i);
            HashMap chunkAttributes = chunk.getAttributes();
            if (chunkAttributes != null && (image = chunkAttributes.get(IMAGE_CHUNK_ATTR)) != null) {
                Object[] imgData = (Object[])image;
                Image img = (Image)imgData[0];
                height = Math.max(height, img.getScaledWidth());
                continue;
            }
            Font font = chunk.getFont();
            height = Math.max(height, font.getSize());
        }
        return height;
    }

    protected String getPhraseContent(Phrase item) {
        StringBuffer contentBuffer = new StringBuffer();
        ArrayList chunks = item.getChunks();
        int numChunks = chunks.size();
        for (int i = 0; i < numChunks; ++i) {
            Object image;
            Chunk chunk = (Chunk)chunks.get(i);
            HashMap chunkAttributes = chunk.getAttributes();
            if (chunkAttributes != null && (image = chunkAttributes.get(IMAGE_CHUNK_ATTR)) != null) continue;
            contentBuffer.append(chunk.getContent());
        }
        return contentBuffer.toString();
    }

    protected Phrase rotatePhrase(Phrase phrase, float rotate) throws DocumentHandlerException {
        try {
            PdfContentByte cb = ((PdfWriter)this.documentHandler.getDocumentWriter()).getDirectContent();
            cb.saveState();
            float phraseWidth = this.getPhraseWidth(phrase);
            float phraseHeight = this.getPhraseHeight(phrase);
            if (phraseWidth == 0.0f || phraseHeight == 0.0f) {
                return phrase;
            }
            PdfTemplate template = cb.createTemplate(phraseWidth, phraseHeight);
            if (this.backgroundColor != null) {
                template.setColorFill(this.backgroundColor);
                template.rectangle(0.0f, 0.0f, phraseWidth, phraseHeight);
                template.fill();
            }
            template.beginText();
            this.printPhrase(template, phrase, 0.0f, phraseHeight * 0.25f);
            template.endText();
            cb.restoreState();
            Image img = Image.getInstance((PdfTemplate)template);
            img.setRotation((float)Math.PI * rotate / 180.0f);
            Chunk ch = new Chunk(img, 0.0f, 0.0f);
            Phrase localPhrase = new Phrase(ch);
            localPhrase.setLeading(img.getScaledHeight());
            return localPhrase;
        }
        catch (BadElementException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to rotate phrase: " + ex.getMessage(), ex);
        }
    }

    protected void printPhrase(PdfTemplate template, Phrase phrase, float xPos, float yPos) throws DocumentHandlerException {
        float localXPos = xPos;
        ArrayList chunks = phrase.getChunks();
        int numChunks = chunks.size();
        for (int i = 0; i < numChunks; ++i) {
            Element elem = (Element)chunks.get(i);
            if (elem instanceof Chunk) {
                Object image;
                Chunk chunk = (Chunk)elem;
                HashMap chunkAttributes = chunk.getAttributes();
                if (chunkAttributes != null && (image = chunkAttributes.get(IMAGE_CHUNK_ATTR)) != null) {
                    Object[] imgData = (Object[])image;
                    Image img = (Image)imgData[0];
                    try {
                        template.endText();
                        template.addImage(img, img.getScaledWidth(), 0.0f, 0.0f, img.getScaledHeight(), localXPos, yPos);
                        template.beginText();
                    }
                    catch (DocumentException ex) {
                        throw new DocumentHandlerException(this.locator(), "Unable to handle image: " + ex.getMessage(), ex);
                    }
                    localXPos += img.getScaledWidth();
                    continue;
                }
                Font chunkFont = chunk.getFont();
                BaseFont bf = chunkFont.getBaseFont();
                Color color = chunkFont.getColor();
                if (color == null) {
                    template.setColorStroke(Color.black);
                    template.setColorFill(Color.black);
                } else {
                    template.setColorStroke(color);
                    template.setColorFill(color);
                }
                template.setFontAndSize(bf, chunkFont.getSize());
                template.setTextMatrix(localXPos, yPos);
                template.showText(chunk.getContent());
                String content = chunk.getContent();
                float chunkWidth = bf.getWidthPoint(content, chunkFont.getSize());
                localXPos += chunkWidth;
                continue;
            }
            if (!(elem instanceof Phrase)) continue;
            this.printPhrase(template, (Phrase)elem, localXPos, yPos);
        }
    }

    protected Object typeCastValue(String text, String type) throws DocumentHandlerException {
        try {
            if (type.equalsIgnoreCase("boolean")) {
                return new Boolean(this.documentHandler.evalBoolean(text));
            }
            if (type.equalsIgnoreCase("int")) {
                return new Integer(this.documentHandler.evalInt(text));
            }
            if (type.equalsIgnoreCase("long")) {
                return new Long(this.documentHandler.evalLong(text));
            }
            if (type.equalsIgnoreCase("float")) {
                return new Float(this.documentHandler.evalFloat(text));
            }
            if (type.equalsIgnoreCase("double")) {
                return new Double(this.documentHandler.evalDouble(text));
            }
            if (type.equalsIgnoreCase("date")) {
                return this.documentHandler.evalDate(text);
            }
            if (type.equalsIgnoreCase("time")) {
                return this.documentHandler.evalTime(text);
            }
            if (type.equalsIgnoreCase("timestamp")) {
                return this.documentHandler.evalTimestamp(text);
            }
            if (type.equalsIgnoreCase("object")) {
                return this.documentHandler.evalObject(text);
            }
            return this.documentHandler.evalString(text);
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), ex.getMessage(), ex);
        }
    }

    protected PdfTemplate ensureNumberOfPagesTemplate(DocumentFont font, PdfContentByte cb) {
        PdfTemplate numberOfPagesTemplate;
        float numberOfPagesWidth = 0.0f;
        Font numberOfPagesFont = font.getFont();
        BaseFont bf = numberOfPagesFont.getBaseFont();
        String expectedNumberOfPages = Integer.toString(this.documentHandler.getExpectedNumberOfPages());
        numberOfPagesWidth = bf.getWidthPoint(expectedNumberOfPages, numberOfPagesFont.getSize());
        HashMap<DocumentFont, PdfTemplate> numberOfPagesTemplates = (HashMap<DocumentFont, PdfTemplate>)this.documentHandler.getResource(NUMBER_OF_PAGES_TEMPLATES);
        if (numberOfPagesTemplates == null) {
            numberOfPagesTemplates = new HashMap<DocumentFont, PdfTemplate>();
            this.documentHandler.registerResource(NUMBER_OF_PAGES_TEMPLATES, numberOfPagesTemplates);
        }
        if ((numberOfPagesTemplate = (PdfTemplate)numberOfPagesTemplates.get(font)) == null) {
            float height = font.getSize();
            numberOfPagesTemplate = cb.createTemplate(numberOfPagesWidth, height + 1.0f);
            numberOfPagesTemplates.put(font, numberOfPagesTemplate);
        }
        return numberOfPagesTemplate;
    }

    protected boolean isPhraseEmpty(Phrase phrase) {
        if (phrase == null) {
            return true;
        }
        int numChunks = phrase.size();
        for (int i = 0; i < numChunks; ++i) {
            Chunk chunk;
            Object element = phrase.get(i);
            if (!(element instanceof Phrase ? !this.isPhraseEmpty((Phrase)element) : (chunk = (Chunk)element).getContent().length() > 0)) continue;
            return false;
        }
        return true;
    }

    public CommonAttributesHolder getCommonAttributesHolder() {
        return this.commonAttributesHolder;
    }

    static {
        colorMap.put("null", null);
        colorMap.put("NULL", null);
        colorMap.put("none", null);
        colorMap.put("NONE", null);
        colorMap.put("black", Color.black);
        colorMap.put("BLACK", Color.black);
        colorMap.put("blue", Color.blue);
        colorMap.put("BLUE", Color.blue);
        colorMap.put("cyan", Color.cyan);
        colorMap.put("CYAN", Color.cyan);
        colorMap.put("darkGray", Color.darkGray);
        colorMap.put("DARK_GRAY", Color.darkGray);
        colorMap.put("gray", Color.gray);
        colorMap.put("GRAY", Color.gray);
        colorMap.put("green", Color.green);
        colorMap.put("GREEN", Color.green);
        colorMap.put("lightGray", Color.lightGray);
        colorMap.put("LIGHT_GRAY", Color.lightGray);
        colorMap.put("magenta", Color.magenta);
        colorMap.put("MAGENTA", Color.magenta);
        colorMap.put("orange", Color.orange);
        colorMap.put("ORANGE", Color.orange);
        colorMap.put("pink", Color.pink);
        colorMap.put("PINK", Color.pink);
        colorMap.put("red", Color.red);
        colorMap.put("RED", Color.red);
        colorMap.put("white", Color.white);
        colorMap.put("WHITE", Color.white);
        colorMap.put("yellow", Color.yellow);
        colorMap.put("YELLOW", Color.yellow);
    }
}

