/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;

public class ChildDefinitionMap
extends HashMap {
    private static final long serialVersionUID = -2184710357984808726L;

    public ChildDefinitionMap() {
    }

    public ChildDefinitionMap(ChildDefinition childDef) {
        this.addDefinition(childDef);
    }

    public ChildDefinitionMap addDefinition(ChildDefinition childDef) {
        if (this.containsKey(childDef.getType())) {
            throw new RuntimeException("Key " + childDef.getType().getName() + " already exists");
        }
        this.put(childDef.getType(), childDef);
        return this;
    }

    public ChildDefinitionMap removeDefinition(ChildDefinition childDef) {
        this.remove(childDef.getType());
        return this;
    }

    public ChildDefinitionMap(ChildDefinitionMap childDefMap) {
        this.putAll(childDefMap);
    }

    public ChildDefinition getCompatibleDefinition(BaseDocumentTag tag) {
        ChildDefinition cd = (ChildDefinition)this.get(tag.getClass());
        if (cd != null) {
            return cd;
        }
        Collection childDefinitions = this.values();
        Iterator cdIter = childDefinitions.iterator();
        while (cdIter.hasNext()) {
            cd = (ChildDefinition)cdIter.next();
            if (!cd.getType().isInstance(tag)) continue;
            return cd;
        }
        return null;
    }

    public List getSortedChildNames() {
        ArrayList childNames = new ArrayList(this.keySet());
        Collections.sort(childNames, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String a1 = ((Class)arg0).getName();
                String a2 = ((Class)arg1).getName();
                return a1.compareTo(a2);
            }
        });
        return childNames;
    }

    public List getSortedChilds() {
        ArrayList childs = new ArrayList(this.values());
        Collections.sort(childs, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ChildDefinition a1 = (ChildDefinition)arg0;
                ChildDefinition a2 = (ChildDefinition)arg1;
                return a1.getClass().getName().compareTo(a2.getClass().getName());
            }
        });
        return childs;
    }
}

