/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import org.ujac.print.DocumentHandler;

public class DocumentFontMapper
implements FontMapper {
    private DocumentHandler documentHandler = null;
    private static final FontMapper defaultFontMapper = new DefaultFontMapper();

    public DocumentFontMapper(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public BaseFont awtToPdf(Font font) {
        BaseFont bf;
        int style = 0;
        if (font.isBold()) {
            style |= 1;
        }
        if (font.isItalic()) {
            style |= 2;
        }
        if ((bf = this.documentHandler.getBaseFont(font.getName(), style)) == null) {
            bf = defaultFontMapper.awtToPdf(font);
        }
        return bf;
    }

    public Font pdfToAwt(BaseFont font, int size) {
        return null;
    }
}

