/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.xmp.XmpWriter;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SimpleLog;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.AttributeHandler;
import org.ujac.print.AwtFont;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.CellContainer;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.ColorRegistry;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.Condition;
import org.ujac.print.ContentFilter;
import org.ujac.print.DefaultAttributeHandler;
import org.ujac.print.DefaultStyleParser;
import org.ujac.print.DocumentDataAccessor;
import org.ujac.print.DocumentEvent;
import org.ujac.print.DocumentEventRecorder;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentFontMapper;
import org.ujac.print.DocumentHandlerComponentRegistry;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentMetaData;
import org.ujac.print.DocumentPageEventHandler;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.DocumentTagInterceptor;
import org.ujac.print.DynamicContentContainer;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.ImageCopy;
import org.ujac.print.OutlineItem;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.PhraseHolder;
import org.ujac.print.StyleParser;
import org.ujac.print.TagAttributeException;
import org.ujac.print.TocItem;
import org.ujac.print.TrueTypeFontHolder;
import org.ujac.print.tag.MacroDefTag;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.io.ResourceLoader;
import org.ujac.util.template.DefaultTemplateInterpreterFactory;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;
import org.ujac.util.template.TemplateInterpreter;
import org.ujac.util.text.FormatHelper;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class DocumentHandler
extends DefaultHandler
implements ColorRegistry {
    private static final String CDATA_BEGIN = "<![CDATA[";
    private Log log = null;
    private DocumentTagFactory tagFactory = null;
    private String xmlReaderClass = null;
    private List documentStack = new ArrayList();
    private Map topDocumentElements = new HashMap();
    private BaseDocumentTag topRealTag = null;
    private List eventRecorderStack = new ArrayList();
    private DocumentEventRecorder topEventRecorder = null;
    private Document document = null;
    private OutputStream outputStream = null;
    private TemplateInterpreter templateInterpreter = null;
    private TemplateContext templateContext = null;
    private DocWriter documentWriter = null;
    private Locator locator = null;
    private Map fontMap = new HashMap();
    private BaseDocumentTag lastItem = null;
    private PageEventHandler pageEventHandler = new PageEventHandler();
    private ResourceLoader resourceLoader = null;
    private Map macroDefinitionMap = new HashMap();
    private Map styleRegistry = new HashMap();
    private Map colorRegistry = new HashMap();
    private Map fontRegistry = new HashMap();
    private DocumentHandlerComponentRegistry documentHandlerComponentRegistry = DocumentHandlerComponentRegistry.getInstance();
    private FontMapper fontMapper = null;
    private List tocItems = null;
    private Map tocItemMap = new HashMap();
    private List outlineItems = null;
    private List unnumberedTocItems = null;
    private DocumentDataAccessor dataAccessor = null;
    private DocumentTagInterceptor tagInterceptor = null;
    private ContentFilter contentFilter = null;
    private Map resourceRegistry = new HashMap();
    private DynamicContentContainer dynamicContentContainer = new DynamicContentContainer();
    private boolean translateEscapeSequences = true;
    private boolean parseDynamicContent = true;
    private boolean evaluateExpressions = true;
    private boolean cacheImages = true;
    private boolean strictlyCheckDocumentStructure = true;
    private int expectedNumberOfPages = 999;
    private boolean includeHeadSection = false;
    private PrintWriter templateCopyWriter = null;
    private PrintWriter disabledTemplateCopyWriter = null;
    protected PdfPageLabels pdfLabels = new PdfPageLabels();
    private DocumentMetaData metaData = null;
    private byte[] xmpMetaData = null;
    private StyleParser styleParser = null;
    private AttributeHandler attributeHandler = null;
    private int logicalPageNumberStyle = 0;
    private String logicalPageNumberText = "";
    private int pageNumberOffset = 0;
    private boolean tocFreezed = false;
    private boolean destinationsSupported = true;

    public void setLogicalPageNumberStyle(int logicalPageNumberStyle) {
        this.logicalPageNumberStyle = logicalPageNumberStyle;
    }

    public void setLogicalPageNumberText(String logicalPageNumberText) {
        this.logicalPageNumberText = logicalPageNumberText;
    }

    public void applyCurrentLogicalPageNumberStyle() {
        int pageNumber;
        PdfWriter writer = (PdfWriter)this.getDocumentWriter(false);
        if (this.isDestinationsSupported() && (pageNumber = this.getPageNumber(writer)) > 0) {
            this.pdfLabels.addPageLabel(pageNumber, this.logicalPageNumberStyle, this.logicalPageNumberText, pageNumber);
        }
    }

    public int getPageNumber(PdfWriter writer) {
        return writer.getPageNumber() + this.pageNumberOffset;
    }

    public DocumentHandler(OutputStream outputStream, TemplateContext templateContext, DocumentTagFactory tagFactory) {
        this.init(outputStream, null, templateContext, tagFactory);
    }

    public DocumentHandler(OutputStream outputStream, TemplateInterpreter templateInterpreter, TemplateContext templateContext, DocumentTagFactory tagFactory) {
        this.init(outputStream, templateInterpreter, templateContext, tagFactory);
    }

    private void init(OutputStream outputStream, TemplateInterpreter templateInterpreter, TemplateContext templateContext, DocumentTagFactory tagFactory) {
        try {
            this.log = LogFactory.getLog((String)"DocumentHandler");
        }
        catch (Throwable ex) {
            this.log = new SimpleLog("DocumentHandler");
            this.log.warn((Object)"Unable to obtain log from the jakarta.commons log factory, using SimpleLog instead.", ex);
        }
        this.outputStream = outputStream;
        this.templateInterpreter = templateInterpreter != null ? templateInterpreter : new DefaultTemplateInterpreterFactory().createTemplateInterpreter();
        this.templateContext = templateContext;
        this.tagFactory = tagFactory;
        this.fontMapper = new DocumentFontMapper(this);
        if (this.styleParser == null) {
            this.setStyleParser(new DefaultStyleParser());
        }
        if (this.attributeHandler == null) {
            this.setAttributeHandler(new DefaultAttributeHandler());
        }
    }

    protected void reset(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.documentWriter = null;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public String getXmlReaderClass() {
        return this.xmlReaderClass;
    }

    public void setXmlReaderClass(String xmlReaderClass) {
        this.xmlReaderClass = xmlReaderClass;
    }

    public FormatHelper getFormatHelper() {
        return this.templateContext.getFormatHelper();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public byte[] loadResource(String location) throws IOException {
        if (this.resourceLoader == null) {
            throw new IOException("No resource loaders specified!");
        }
        return this.resourceLoader.loadResource(location);
    }

    public void registerStyle(String styleName, Map attributes) {
        this.styleRegistry.put(styleName, attributes);
    }

    public Map getStyle(String styleName) {
        return (Map)this.styleRegistry.get(styleName);
    }

    public Map getStyle(BaseDocumentTag tag, String clazz) {
        HashMap styleMap = new HashMap();
        Map styles = (Map)this.styleRegistry.get(tag.getName());
        if (styles != null) {
            styleMap.putAll(styles);
        }
        if (clazz == null) {
            return styleMap;
        }
        StringTokenizer tknClass = new StringTokenizer(clazz, " ");
        while (tknClass.hasMoreTokens()) {
            String styleClazz = tknClass.nextToken();
            this.getStyleAttributes(styleMap, tag, styleClazz);
        }
        return styleMap;
    }

    private void getStyleAttributes(Map styleMap, BaseDocumentTag tag, String clazz) {
        String fqName;
        String qName = "." + clazz;
        Map style = (Map)this.styleRegistry.get(qName);
        if (style != null) {
            styleMap.putAll(style);
        }
        if ((style = (Map)this.styleRegistry.get(fqName = tag.getName() + qName)) != null) {
            styleMap.putAll(style);
        }
    }

    public void registerColor(String colorName, Color color) {
        this.colorRegistry.put(colorName, color);
    }

    public Color getColor(String colorName) {
        return (Color)this.colorRegistry.get(colorName);
    }

    public void registerFont(String fontName, byte[] fontBytes, int style, boolean embed, boolean cached) throws IOException, DocumentException {
        TrueTypeFontHolder fontHolder = (TrueTypeFontHolder)this.fontRegistry.get(fontName);
        if (fontHolder == null) {
            fontHolder = new TrueTypeFontHolder(fontName);
            this.fontRegistry.put(fontName, fontHolder);
        }
        int baseFontStyle = style & 3;
        switch (baseFontStyle) {
            case 0: {
                fontHolder.setNormalFont(fontBytes);
                break;
            }
            case 1: {
                fontHolder.setBoldFont(fontBytes);
                break;
            }
            case 2: {
                fontHolder.setItalicFont(fontBytes);
                break;
            }
            case 3: {
                fontHolder.setBoldItalicFont(fontBytes);
                break;
            }
            default: {
                fontHolder.setNormalFont(fontBytes);
            }
        }
        fontHolder.setEmbedded(embed);
        fontHolder.setCached(cached);
    }

    public DocumentFont createFont(String fontName, String encoding, float size, int style, float textRise, Color color) throws DocumentHandlerException {
        StringTokenizer tkn = new StringTokenizer(fontName, ", ");
        while (tkn.hasMoreTokens()) {
            String name = tkn.nextToken();
            TrueTypeFontHolder fontHolder = this.getRegisteredFont(name);
            if (fontHolder == null) {
                com.lowagie.text.Font font = FontFactory.getFont((String)name, (String)encoding, (float)size, (int)style, (Color)color);
                if (font.getFamily() < 0 && font.getBaseFont() == null) continue;
                return new DocumentFont(font, name, encoding, size, style, textRise, color);
            }
            BaseFont baseFont = null;
            int fontStyle = style & 0xC;
            int baseFontStyle = style & 3;
            switch (baseFontStyle) {
                case 0: {
                    baseFont = fontHolder.getNormalFont();
                    break;
                }
                case 3: {
                    baseFont = fontHolder.getBoldItalicFont();
                    if (baseFont == null) {
                        fontStyle = style;
                        if (fontHolder.getBoldFont() == null) break;
                        baseFont = fontHolder.getBoldFont();
                        fontStyle ^= 1;
                        break;
                    }
                    if (baseFont.getFontDescriptor(4, size) != 0.0f) break;
                    fontStyle |= 2;
                    break;
                }
                case 1: {
                    baseFont = fontHolder.getBoldFont();
                    if (baseFont != null) break;
                    fontStyle = style;
                    break;
                }
                case 2: {
                    baseFont = fontHolder.getItalicFont();
                    if (baseFont != null && baseFont.getFontDescriptor(4, size) != 0.0f) break;
                    fontStyle = style;
                    break;
                }
                default: {
                    baseFont = fontHolder.getNormalFont();
                }
            }
            if (baseFont == null) {
                baseFont = fontHolder.getNormalFont();
            }
            return new DocumentFont(new com.lowagie.text.Font(baseFont, size, fontStyle, color), fontName, encoding, size, style, textRise, color);
        }
        throw new DocumentHandlerException(this.locator(), "Unable to create font '" + fontName + "', make sure that the family has been registered properly.");
    }

    public BaseFont getBaseFont(String fontName, int style) {
        TrueTypeFontHolder fontHolder = (TrueTypeFontHolder)this.fontRegistry.get(fontName);
        if (fontHolder == null) {
            return null;
        }
        BaseFont baseFont = null;
        int baseFontStyle = style & 3;
        switch (baseFontStyle) {
            case 0: {
                baseFont = fontHolder.getNormalFont();
                break;
            }
            case 1: {
                baseFont = fontHolder.getBoldFont();
                break;
            }
            case 2: {
                baseFont = fontHolder.getItalicFont();
                break;
            }
            case 3: {
                baseFont = fontHolder.getBoldItalicFont();
                break;
            }
            default: {
                baseFont = fontHolder.getNormalFont();
            }
        }
        if (baseFont == null) {
            baseFont = fontHolder.getNormalFont();
        }
        return baseFont;
    }

    public Font getAwtFont(DocumentFont font) {
        String name = font.getFamily();
        int baseFontStyle = font.getStyle() & 3;
        int style = 0;
        switch (baseFontStyle) {
            case 0: {
                break;
            }
            case 1: {
                style |= 1;
                break;
            }
            case 2: {
                style |= 2;
                break;
            }
            case 3: {
                style |= 3;
                break;
            }
        }
        return new AwtFont(name, style, (int)font.getSize());
    }

    public TrueTypeFontHolder[] getRegisteredFonts() {
        int numRegisterdFonts = this.fontRegistry.size();
        TrueTypeFontHolder[] fonts = new TrueTypeFontHolder[numRegisterdFonts];
        Iterator iterFonts = this.fontRegistry.entrySet().iterator();
        int idx = 0;
        while (iterFonts.hasNext()) {
            TrueTypeFontHolder font;
            fonts[idx] = font = (TrueTypeFontHolder)((Object)iterFonts.next());
            ++idx;
        }
        return fonts;
    }

    public TrueTypeFontHolder getRegisteredFont(String name) {
        TrueTypeFontHolder fontHolder = (TrueTypeFontHolder)this.fontRegistry.get(name);
        return fontHolder;
    }

    public FontMapper getFontMapper() {
        return this.fontMapper;
    }

    public Image getCachedImage(Object source) {
        Image img = (Image)this.getResource(source);
        if (!this.cacheImages || img == null) {
            return null;
        }
        return new ImageCopy(img);
    }

    public void cacheImage(Object source, Image img) {
        if (this.cacheImages) {
            this.registerResource(source, img);
        }
    }

    public AttributeDefinitionMap getSupportedAttributes(BaseDocumentTag tag) {
        return this.documentHandlerComponentRegistry.getSupportedAttributes(tag);
    }

    public AttributeDefinitionMap getSupportedStyleAttributes(BaseDocumentTag tag) {
        return this.documentHandlerComponentRegistry.getSupportedStyleAttributes(tag);
    }

    public ChildDefinitionMap getSupportedChilds(BaseDocumentTag tag) {
        return this.documentHandlerComponentRegistry.getSupportedChilds(tag);
    }

    public PdfPageEvent getPageEventHandler() {
        return this.pageEventHandler;
    }

    public PdfPageEvent createPageEventHandler() {
        return new PageEventHandler();
    }

    public void setPageEventHandler(Object key, PdfPageEvent handler) {
        this.pageEventHandler.setHandler(key, handler);
    }

    public void removePageEventHandler(Object key) {
        this.pageEventHandler.removeHandler(key);
    }

    public void clearPageEventHandlers() {
        this.pageEventHandler.clearHandlers();
    }

    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    public void setTemplateContext(TemplateContext templateContext) {
        this.templateContext = templateContext;
    }

    public DocumentTagFactory getTagFactory() {
        return this.tagFactory;
    }

    public boolean isTranslateEscapeSequences() {
        return this.translateEscapeSequences;
    }

    public void setTranslateEscapeSequences(boolean translateEscapeSequences) {
        this.translateEscapeSequences = translateEscapeSequences;
    }

    public boolean isParseDynamicContent() {
        return this.parseDynamicContent;
    }

    public void setParseDynamicContent(boolean parseDynamicContent) {
        this.parseDynamicContent = parseDynamicContent;
    }

    public boolean isEvaluateExpressions() {
        return this.evaluateExpressions;
    }

    public void setEvaluateExpressions(boolean evaluateExpressions) {
        this.evaluateExpressions = evaluateExpressions;
    }

    public boolean isCacheImages() {
        return this.cacheImages;
    }

    public void setCacheImages(boolean cacheImages) {
        this.cacheImages = cacheImages;
    }

    public boolean isStrictlyCheckDocumentStructure() {
        return this.strictlyCheckDocumentStructure;
    }

    public void setStrictlyCheckDocumentStructure(boolean strictlyCheckDocumentStructure) {
        this.strictlyCheckDocumentStructure = strictlyCheckDocumentStructure;
    }

    public int getExpectedNumberOfPages() {
        return this.expectedNumberOfPages;
    }

    public void setExpectedNumberOfPages(int expectedNumberOfPages) {
        this.expectedNumberOfPages = expectedNumberOfPages;
    }

    public boolean isIncludeHeadSection() {
        return this.includeHeadSection;
    }

    protected void setIncludeHeadSection(boolean includeHeadSection) {
        this.includeHeadSection = includeHeadSection;
    }

    public String executeTemplate(String templateSource) throws TemplateException {
        if (!this.evaluateExpressions || templateSource == null || templateSource.indexOf(CDATA_BEGIN) != -1) {
            return templateSource;
        }
        return this.templateInterpreter.execute(templateSource, this.templateContext);
    }

    public boolean evalBoolean(String expression) throws ExpressionException {
        return this.templateInterpreter.evalBooleanExpr(expression, this.templateContext);
    }

    public int evalInt(String expression) throws ExpressionException {
        return this.templateInterpreter.evalIntExpr(expression, this.templateContext);
    }

    public long evalLong(String expression) throws ExpressionException {
        return this.templateInterpreter.evalLongExpr(expression, this.templateContext);
    }

    public float evalFloat(String expression) throws ExpressionException {
        return this.templateInterpreter.evalFloatExpr(expression, this.templateContext);
    }

    public double evalDouble(String expression) throws ExpressionException {
        return this.templateInterpreter.evalDoubleExpr(expression, this.templateContext);
    }

    public Date evalDate(String expression) throws ExpressionException {
        return this.templateInterpreter.evalDateExpr(expression, this.templateContext);
    }

    public Time evalTime(String expression) throws ExpressionException {
        return this.templateInterpreter.evalTimeExpr(expression, this.templateContext);
    }

    public Timestamp evalTimestamp(String expression) throws ExpressionException {
        return this.templateInterpreter.evalTimestampExpr(expression, this.templateContext);
    }

    public String evalString(String expression) throws ExpressionException {
        if (!this.evaluateExpressions) {
            return expression;
        }
        return this.templateInterpreter.evalStringExpr(expression, this.templateContext);
    }

    public Object evalObject(String expression) throws ExpressionException {
        return this.templateInterpreter.evalObjectExpr(expression, this.templateContext);
    }

    public void registerFormat(String formatString, Format formatInstance) {
        this.getFormatHelper().registerFormat(formatString, formatInstance);
    }

    public Format lookupFormat(String formatString) {
        return this.getFormatHelper().lookupFormat(formatString);
    }

    public void registerMacroDefinition(String macroName, MacroDefTag macroDefinition) {
        this.macroDefinitionMap.put(macroName, macroDefinition);
    }

    public MacroDefTag lookupMacroDefinition(String macroName) {
        return (MacroDefTag)this.macroDefinitionMap.get(macroName);
    }

    public void pushItem(BaseDocumentTag item) {
        String tagBody = item.getContent();
        if (tagBody != null && tagBody.length() > 0) {
            this.templateContext.setProperty("body", tagBody);
        }
        this.documentStack.add(item);
        this.registerTopDocumentElement(item);
    }

    public BaseDocumentTag popItem() {
        String tagBody;
        BaseDocumentTag pop = (BaseDocumentTag)this.documentStack.remove(this.documentStack.size() - 1);
        this.updateTopDocumentElements();
        BaseDocumentTag top = this.topItem();
        if (top != null && (tagBody = top.getContent()) != null && tagBody.length() > 0) {
            this.templateContext.setProperty("body", tagBody);
        }
        return pop;
    }

    private void updateTopDocumentElements() {
        this.topDocumentElements.clear();
        this.topRealTag = null;
        BaseDocumentTag item = null;
        int stackSize = this.documentStack.size();
        for (int i = 0; i < stackSize; ++i) {
            item = (BaseDocumentTag)this.documentStack.get(i);
            this.registerTopDocumentElement(item);
        }
    }

    private void registerTopDocumentElement(BaseDocumentTag item) {
        this.topDocumentElements.put(item.getName(), item);
        if (item instanceof ElementContainer) {
            this.topDocumentElements.put(ElementContainer.class, item);
        }
        if (item instanceof CellContainer) {
            this.topDocumentElements.put(CellContainer.class, item);
        }
        if (item instanceof PdfCellContainer) {
            this.topDocumentElements.put(PdfCellContainer.class, item);
        }
        if (item instanceof Condition) {
            this.topDocumentElements.put(Condition.class, item);
        }
        if (item instanceof FontHolder) {
            this.topDocumentElements.put(FontHolder.class, item);
        }
        if (item instanceof PhraseHolder) {
            this.topDocumentElements.put(PhraseHolder.class, item);
        }
        if (item instanceof CommonAttributesHolder) {
            this.topDocumentElements.put(CommonAttributesHolder.class, item);
        }
        if (!item.isVirtualContainer()) {
            this.topRealTag = item;
        }
    }

    public BaseDocumentTag topItem() {
        try {
            return (BaseDocumentTag)this.documentStack.get(this.documentStack.size() - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void pushEventRecorder(DocumentEventRecorder recorder) {
        this.eventRecorderStack.add(recorder);
        this.topEventRecorder = recorder;
    }

    public DocumentEventRecorder popEventRecorder() {
        DocumentEventRecorder top = (DocumentEventRecorder)this.eventRecorderStack.remove(this.eventRecorderStack.size() - 1);
        int stackSize = this.eventRecorderStack.size();
        this.topEventRecorder = stackSize > 0 ? (DocumentEventRecorder)this.eventRecorderStack.get(stackSize - 1) : null;
        return top;
    }

    public DocumentEventRecorder topEventRecorder() {
        return this.topEventRecorder;
    }

    public BaseDocumentTag latestOfType(String type) {
        return (BaseDocumentTag)this.topDocumentElements.get(type);
    }

    public BaseDocumentTag latestRealTag() {
        return this.topRealTag;
    }

    public BaseDocumentTag latestOfType(Class type) {
        BaseDocumentTag item = null;
        int stackSize = this.documentStack.size();
        for (int i = stackSize - 1; i >= 0; --i) {
            item = (BaseDocumentTag)this.documentStack.get(i);
            if (!type.isInstance(item)) continue;
            return item;
        }
        return null;
    }

    public ElementContainer latestElementContainer() {
        return (ElementContainer)this.topDocumentElements.get(ElementContainer.class);
    }

    public CellContainer latestCellContainer() {
        return (CellContainer)this.topDocumentElements.get(CellContainer.class);
    }

    public PdfCellContainer latestPdfCellContainer() {
        return (PdfCellContainer)this.topDocumentElements.get(PdfCellContainer.class);
    }

    public Condition latestCondition() {
        return (Condition)this.topDocumentElements.get(Condition.class);
    }

    public FontHolder latestFontHolder() {
        return (FontHolder)this.topDocumentElements.get(FontHolder.class);
    }

    public PhraseHolder latestPhraseHolder() {
        return (PhraseHolder)this.topDocumentElements.get(PhraseHolder.class);
    }

    public CommonAttributesHolder latestCommonAttributesHolder() {
        return (CommonAttributesHolder)this.topDocumentElements.get(CommonAttributesHolder.class);
    }

    public int numItems() {
        return this.documentStack.size();
    }

    public Document getDocument() {
        return this.document;
    }

    public Document getDocument(boolean openDocumentRequired) throws DocumentHandlerException {
        if (this.document == null) {
            throw new DocumentHandlerException(this.locator, "No document format has been specified so far. Make sure that you have eigher defined the format at the &lt;document&gt; tag or at a  &lt;page-format&gt; tag before the occurrence of this tag!");
        }
        if (openDocumentRequired && !this.document.isOpen()) {
            this.document.open();
        }
        return this.document;
    }

    public DocWriter setDocument(Document document) throws DocumentHandlerException {
        this.document = document;
        try {
            this.documentWriter = PdfWriter.getInstance((Document)document, (OutputStream)this.outputStream);
            ((PdfWriter)this.documentWriter).setPageEvent((PdfPageEvent)this.pageEventHandler);
            if (this.metaData != null) {
                ((PdfWriter)this.documentWriter).setPDFXConformance(this.metaData.getPdfxConformance());
                ((PdfWriter)this.documentWriter).setPdfVersion(this.metaData.getPdfVersion());
                ((PdfWriter)this.documentWriter).setXmpMetadata(this.getXmpMetaData());
            }
            return this.documentWriter;
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator, "Unable to initialize the document writer:" + ex.getMessage(), ex);
        }
    }

    public DocWriter setDocumentAndWriter(Document document, DocWriter writer) {
        DocWriter oldWriter = this.documentWriter;
        this.document = document;
        this.documentWriter = writer;
        return oldWriter;
    }

    public DocWriter setDocumentAndWriter(Document document, DocWriter writer, Map resourceRegistry, PdfPageEvent eventHandler) {
        DocWriter oldWriter = this.documentWriter;
        this.document = document;
        this.documentWriter = writer;
        this.resourceRegistry = resourceRegistry;
        this.pageEventHandler = (PageEventHandler)eventHandler;
        ((PdfWriter)this.documentWriter).setPageEvent((PdfPageEvent)this.pageEventHandler);
        return oldWriter;
    }

    public DocWriter getDocumentWriter() {
        return this.getDocumentWriter(true);
    }

    public DocWriter getDocumentWriter(boolean openDocumentRequired) {
        if (openDocumentRequired && !this.document.isOpen()) {
            this.document.open();
        }
        return this.documentWriter;
    }

    public Locator locator() {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        return this.locator;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.locator != null && locator.getLineNumber() < this.locator.getLineNumber()) {
            return;
        }
        this.locator = locator;
    }

    public void registerFont(String name, DocumentFont font) {
        this.fontMap.put(name, font);
    }

    public DocumentFont getFont(String name) throws TagAttributeException {
        DocumentFont font = (DocumentFont)this.fontMap.get(name);
        if (font == null) {
            throw new TagAttributeException(this.locator, "The font '" + name + "' is not defined at this position in the document.");
        }
        return font;
    }

    public List getTocItems() {
        return this.tocItems;
    }

    public void addTocItem(TocItem tocItem) {
        if (this.tocItems == null) {
            this.tocItems = new ArrayList();
        }
        if (this.unnumberedTocItems == null) {
            this.unnumberedTocItems = new ArrayList();
        }
        if (this.tocFreezed) {
            if (tocItem.getPosition() < 0.0f) {
                this.unnumberedTocItems.add(tocItem);
            }
        } else {
            TocItem ti = null;
            ti = "index".equals(tocItem.getTocRelevance()) ? (TocItem)this.tocItemMap.get(tocItem.getTitle()) : (TocItem)this.tocItemMap.get(tocItem.getNumber());
            if (ti != null) {
                this.tocItems.set(ti.getIndex(), ti);
                if (tocItem.getPosition() < 0.0f) {
                    this.unnumberedTocItems.add(ti);
                }
            } else {
                tocItem.setIndex(this.tocItems.size());
                this.tocItems.add(tocItem);
                this.tocItemMap.put(tocItem.getNumber(), tocItem);
                if (tocItem.getPosition() < 0.0f) {
                    this.unnumberedTocItems.add(tocItem);
                }
            }
        }
    }

    public List getOutlines() {
        return this.outlineItems;
    }

    public void addOutline(OutlineItem outlineItem) {
        if (this.outlineItems == null) {
            this.outlineItems = new ArrayList();
        }
        this.outlineItems.add(outlineItem);
    }

    protected TocItem flushTocChapter(PdfWriter writer, float verticalPosition) {
        if (this.unnumberedTocItems != null) {
            int numUnnumberedTocItems = this.unnumberedTocItems.size();
            for (int i = 0; i < numUnnumberedTocItems; ++i) {
                TocItem tocItem = (TocItem)this.unnumberedTocItems.get(i);
                if (tocItem.getLevel() != 1) continue;
                tocItem.setPage(this.getPageNumber(writer));
                tocItem.setPosition(verticalPosition);
                String itemName = "chapter_" + tocItem.getNumber();
                float position = tocItem.getPosition();
                OutlineItem outline = new OutlineItem(itemName, tocItem.getPage(), 0.0f, position, null, tocItem.getTitle());
                if (this.isDestinationsSupported()) {
                    writer.getDirectContent().localDestination(itemName, new PdfDestination(2, position));
                }
                tocItem.setOutline(outline);
                this.addOutline(outline);
                this.unnumberedTocItems.remove(i);
                return tocItem;
            }
        }
        return null;
    }

    protected TocItem flushTocSection(PdfWriter writer, float verticalPosition) {
        if (this.unnumberedTocItems != null) {
            int numUnnumberedTocItems = this.unnumberedTocItems.size();
            for (int i = 0; i < numUnnumberedTocItems; ++i) {
                TocItem tocItem = (TocItem)this.unnumberedTocItems.get(i);
                int tocLevel = tocItem.getLevel();
                if (tocLevel <= 1) continue;
                tocItem.setPage(this.getPageNumber(writer));
                tocItem.setPosition(verticalPosition);
                TocItem parent = null;
                for (int j = this.tocItems.size() - 1; j >= 0; --j) {
                    TocItem ti = (TocItem)this.tocItems.get(j);
                    if (ti.getPage() <= 0 || ti.getLevel() != tocLevel - 1) continue;
                    parent = ti;
                    break;
                }
                String itemName = "section_" + tocItem.getNumber();
                float position = tocItem.getPosition();
                OutlineItem outline = new OutlineItem(itemName, tocItem.getPage(), 0.0f, position, parent.getOutline().getName(), tocItem.getTitle());
                if (this.isDestinationsSupported()) {
                    writer.getDirectContent().localDestination(itemName, new PdfDestination(2, position));
                }
                tocItem.setOutline(outline);
                this.addOutline(outline);
                this.unnumberedTocItems.remove(i);
                return tocItem;
            }
        }
        return null;
    }

    protected void flushTocItems(PdfWriter writer) {
        if (this.unnumberedTocItems != null) {
            int numUnnumberedTocItems = this.unnumberedTocItems.size();
            for (int i = 0; i < numUnnumberedTocItems; ++i) {
                TocItem tocItem = (TocItem)this.unnumberedTocItems.get(i);
                tocItem.setPage(this.getPageNumber(writer));
            }
            this.unnumberedTocItems.clear();
        }
    }

    public DocumentDataAccessor getDataAccessor() {
        return this.dataAccessor;
    }

    protected void setDataAccessor(DocumentDataAccessor dataAccessor) {
        this.dataAccessor = dataAccessor;
    }

    public DocumentTagInterceptor getTagInterceptor() {
        return this.tagInterceptor;
    }

    public void setTagInterceptor(DocumentTagInterceptor tagInterceptor) {
        this.tagInterceptor = tagInterceptor;
    }

    public ContentFilter getContentFilter() {
        return this.contentFilter;
    }

    public void setContentFilter(ContentFilter contentFilter) {
        this.contentFilter = contentFilter;
    }

    public Map getResourceRegistry() {
        return this.resourceRegistry;
    }

    public Object getResource(Object key) {
        return this.resourceRegistry.get(key);
    }

    public void registerResource(Object key, Object resource) {
        this.resourceRegistry.put(key, resource);
    }

    public Object removeResource(Object key) {
        return this.resourceRegistry.remove(key);
    }

    public DynamicContentContainer getDynamicContentContainer() {
        return this.dynamicContentContainer;
    }

    public void setDynamicContentContainer(DynamicContentContainer dynamicContentContainer) {
        this.dynamicContentContainer = dynamicContentContainer;
    }

    public float getVerticalPosition() {
        return ((PdfWriter)this.documentWriter).getVerticalPosition(true);
    }

    public void startDocument() throws SAXException {
        try {
            if (this.dataAccessor != null) {
                this.dataAccessor.startup();
            }
        }
        catch (DocumentHandlerException ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
        if (this.templateCopyWriter != null) {
            this.templateCopyWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            DocumentEventRecorder recorder;
            if (this.templateCopyWriter != null) {
                this.templateCopyWriter.write(60);
                this.templateCopyWriter.print(localName);
                int numAttribs = attributes.getLength();
                for (int i = 0; i < numAttribs; ++i) {
                    this.templateCopyWriter.write(32);
                    this.templateCopyWriter.print(attributes.getLocalName(i));
                    this.templateCopyWriter.print("=\"");
                    this.templateCopyWriter.print(attributes.getValue(i));
                    this.templateCopyWriter.write(34);
                }
                this.templateCopyWriter.write(62);
            }
            BaseDocumentTag item = null;
            item = "_DYNAMIC_CONTENT_".equals(localName) ? this.getDynamicContentContainer() : this.tagFactory.createTagInstance(this, localName);
            BaseDocumentTag topItem = this.topItem();
            item.setDocumentHandler(this);
            item.setAttributes(new AttributesImpl(attributes));
            item.setDepth(this.documentStack.size());
            item.setParentItem(topItem);
            item.setPreviousItem(this.lastItem);
            if (!(topItem == null || topItem.isVirtualContainer() || item.isDocumentRoot() || item.isStructureChecksDisabled())) {
                boolean legalChild = false;
                ChildDefinitionMap childDefs = topItem.getSupportedChilds();
                ChildDefinition childDef = childDefs.getCompatibleDefinition(item);
                if (childDef != null) {
                    legalChild = true;
                }
                if (!legalChild) {
                    if (this.strictlyCheckDocumentStructure) {
                        this.log.error((Object)("At line " + this.locator().getLineNumber() + ": Detected illegal nested tag <" + item.getName() + "> below tag <" + topItem.getName() + ">."));
                        throw new DocumentHandlerException(this.locator(), "Detected illegal nested tag <" + item.getName() + "> below tag <" + topItem.getName() + ">.");
                    }
                    this.log.warn((Object)("At line " + this.locator().getLineNumber() + ": Detected illegal nested tag <" + item.getName() + "> below tag <" + topItem.getName() + ">."));
                }
            }
            if (topItem != null) {
                topItem.flushContent();
            }
            if ((recorder = this.topEventRecorder()) != null) {
                recorder.recordEvent(new DocumentEvent(1, item, null));
            }
            item.preInitialize();
            item.initialize();
            item.checkAttributes();
            if (this.tagInterceptor == null || this.tagInterceptor.beforeOpen(item)) {
                item.openItem();
                if (this.tagInterceptor != null) {
                    this.tagInterceptor.afterOpen(item);
                }
            }
            item.setPreviousItem(null);
            this.pushItem(item);
            this.lastItem = item;
        }
        catch (DocumentHandlerException ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int effectiveLength;
        if (this.templateCopyWriter != null) {
            int offset = start;
            int endIdx = start + length;
            char c = '\u0000';
            String entity = null;
            for (int i = start; i < endIdx; ++i) {
                c = ch[i];
                switch (c) {
                    case '&': {
                        entity = "&amp;";
                        break;
                    }
                    case '<': {
                        entity = "&lt;";
                        break;
                    }
                    case '>': {
                        entity = "&gt;";
                        break;
                    }
                    case '\"': {
                        entity = "&quot;";
                        break;
                    }
                    case '\'': {
                        entity = "&apos;";
                    }
                }
                if (entity == null) continue;
                this.templateCopyWriter.write(ch, offset, i - offset);
                offset = i + 1;
                this.templateCopyWriter.write(entity);
                entity = null;
            }
            this.templateCopyWriter.write(ch, offset, endIdx - offset);
        }
        BaseDocumentTag item = this.topItem();
        int effectiveStart = start;
        if (item.isItemOpened()) {
            for (effectiveLength = length; effectiveLength > 0 && Character.isWhitespace(ch[effectiveStart]); --effectiveLength) {
                ++effectiveStart;
            }
            if (!item.isTrimBody() && effectiveStart - start >= 1) {
                --effectiveStart;
                ++effectiveLength;
            }
            if (effectiveLength == 0) {
                return;
            }
        }
        item.setItemOpened(false);
        String trimmedContent = this.trimContent(ch, effectiveStart, effectiveLength);
        item.addContent(trimmedContent);
        DocumentEventRecorder recorder = this.topEventRecorder();
        if (recorder != null) {
            recorder.recordEvent(new DocumentEvent(2, item, trimmedContent));
        }
    }

    private String trimContent(char[] ch, int start, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = ch[start + i];
            boolean whitespaceDetected = Character.isWhitespace(c);
            while (whitespaceDetected) {
                if (++i >= length) {
                    --i;
                    break;
                }
                c = ch[start + i];
                if (Character.isWhitespace(c)) continue;
                --i;
                break;
            }
            if (whitespaceDetected) {
                buf.append(' ');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        BaseDocumentTag item = this.topItem();
        try {
            String tagBody;
            DocumentEventRecorder recorder;
            if (this.templateCopyWriter != null) {
                this.templateCopyWriter.print("</");
                this.templateCopyWriter.print(localName);
                this.templateCopyWriter.print(">");
            }
            if ((recorder = this.topEventRecorder()) != null) {
                recorder.recordEvent(new DocumentEvent(3, item, item.getContent()));
            }
            item.setItemClosed(true);
            Map customAttributes = item.getCustomAttributes();
            String customBody = null;
            if (customAttributes != null) {
                customBody = (String)customAttributes.get("body");
            }
            if ((tagBody = item.getContent()) != null && tagBody.length() > 0) {
                this.templateContext.setProperty("body", tagBody);
            }
            if (customBody == null) {
                item.flushContent();
            } else {
                item.resetContent();
                item.addContent(customBody);
                item.flushContent();
            }
            if (this.tagInterceptor == null || this.tagInterceptor.beforeClose(item)) {
                item.closeItem();
                if (this.tagInterceptor != null) {
                    this.tagInterceptor.afterClose(item);
                }
            }
            this.popItem();
        }
        catch (DocumentHandlerException ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
        this.lastItem = item;
    }

    public void endDocument() throws SAXException {
        if (this.documentWriter != null && this.documentStack.isEmpty()) {
            this.documentWriter.close();
        }
        if (this.templateCopyWriter != null) {
            this.templateCopyWriter.flush();
        }
        try {
            if (this.dataAccessor != null) {
                this.dataAccessor.shutdown();
            }
        }
        catch (DocumentHandlerException ex) {
            throw new SAXException(ex.getMessage(), ex);
        }
    }

    public PrintWriter getTemplateCopyWriter() {
        return this.templateCopyWriter;
    }

    protected void setTemplateCopyWriter(PrintWriter templateCopyWriter) {
        this.templateCopyWriter = templateCopyWriter;
    }

    public void disableTemplateCopyWriter() {
        this.disabledTemplateCopyWriter = this.templateCopyWriter;
    }

    public void enableTemplateCopyWriter() {
        this.templateCopyWriter = this.disabledTemplateCopyWriter;
    }

    public AttributeHandler getAttributeHandler() {
        return this.attributeHandler;
    }

    public void setAttributeHandler(AttributeHandler attributeHandler) {
        this.attributeHandler = attributeHandler;
        attributeHandler.setDocumentHandler(this);
        if (this.styleParser != null) {
            this.styleParser.setAttributeHandler(attributeHandler);
        }
    }

    public StyleParser getStyleParser() {
        return this.styleParser;
    }

    public void setStyleParser(StyleParser styleParser) {
        this.styleParser = styleParser;
        styleParser.setAttributeHandler(this.attributeHandler);
    }

    public int getPageNumberOffset() {
        return this.pageNumberOffset;
    }

    public void setPageNumberOffset(int pageNumberOffset) {
        this.pageNumberOffset = pageNumberOffset;
    }

    public void clearReferences() {
        if (this.outlineItems != null) {
            this.outlineItems.clear();
        }
        if (this.unnumberedTocItems != null) {
            this.unnumberedTocItems.clear();
        }
        if (this.tocItems != null) {
            this.tocItems.clear();
        }
        if (this.tocItemMap != null) {
            this.tocItemMap.clear();
        }
    }

    public void resetReferences() {
        if (this.unnumberedTocItems != null) {
            this.unnumberedTocItems.clear();
        }
        if (this.outlineItems != null) {
            this.outlineItems.clear();
        }
    }

    public boolean isTocFreezed() {
        return this.tocFreezed;
    }

    public void setTocFreezed(boolean tocFreezed) {
        this.tocFreezed = tocFreezed;
    }

    public boolean isDestinationsSupported() {
        return this.destinationsSupported;
    }

    public void setDestinationsSupported(boolean destinationsSupported) {
        this.destinationsSupported = destinationsSupported;
    }

    public DocumentMetaData getMetaData() {
        return this.metaData;
    }

    private byte[] getXmpMetaData() {
        if (this.xmpMetaData != null) {
            return this.xmpMetaData;
        }
        if (this.metaData == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PdfDictionary dict = new PdfDictionary();
        if (this.metaData.getTitle() != null) {
            dict.put(PdfName.TITLE, (PdfObject)new PdfString(this.metaData.getTitle()));
        }
        if (this.metaData.getAuthor() != null) {
            dict.put(PdfName.AUTHOR, (PdfObject)new PdfString(this.metaData.getAuthor()));
        }
        if (this.metaData.getSubject() != null) {
            dict.put(PdfName.SUBJECT, (PdfObject)new PdfString(this.metaData.getSubject()));
        }
        if (this.metaData.getKeywords() != null) {
            dict.put(PdfName.KEYWORDS, (PdfObject)new PdfString(this.metaData.getKeywords()));
        }
        try {
            XmpWriter xmp = new XmpWriter((OutputStream)os, dict, this.metaData.getPdfxConformance());
            xmp.close();
        }
        catch (IOException ex) {
            this.log.error((Object)"Failed to generate XMP meta data", (Throwable)ex);
        }
        this.xmpMetaData = os.toByteArray();
        return this.xmpMetaData;
    }

    public void setMetaData(DocumentMetaData metaData) {
        this.metaData = metaData;
        this.xmpMetaData = null;
    }

    class PageEventHandler
    extends PdfPageEventHelper {
        private Map eventHandlers = new HashMap();

        PageEventHandler() {
        }

        public void setHandler(Object key, PdfPageEvent handler) {
            this.eventHandlers.put(key, handler);
        }

        public void removeHandler(Object key) {
            this.eventHandlers.remove(key);
        }

        public void clearHandlers() {
            this.eventHandlers.clear();
        }

        public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
            DocumentHandler.this.flushTocChapter(writer, paragraphPosition);
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onChapter(writer, document, paragraphPosition, title);
            }
        }

        public void onChapterEnd(PdfWriter writer, Document document, float position) {
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onChapterEnd(writer, document, position);
            }
        }

        public void onStartPage(PdfWriter writer, Document document) {
            DocumentHandler.this.getTemplateContext().setProperty("pageNumber", new Integer(DocumentHandler.this.getPageNumber(writer)));
            DocumentHandler.this.applyCurrentLogicalPageNumberStyle();
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onStartPage(writer, document);
            }
        }

        public void onEndPage(PdfWriter writer, Document document) {
            Iterator iter = this.eventHandlers.entrySet().iterator();
            DocumentHandler.this.getTemplateContext().setProperty("pageNumber", new Integer(DocumentHandler.this.getPageNumber(writer)));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)entry.getValue());
                evtHandler.onEndPage(writer, document);
                if (!evtHandler.isTemporary()) continue;
                iter.remove();
            }
        }

        public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onGenericTag(writer, document, rect, text);
            }
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            DocumentHandler.this.applyCurrentLogicalPageNumberStyle();
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onOpenDocument(writer, document);
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            DocumentHandler.this.flushTocItems(writer);
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onCloseDocument(writer, document);
                iter.remove();
            }
            writer.setPageLabels(DocumentHandler.this.pdfLabels);
            Map numberOfPagesTemplates = (Map)DocumentHandler.this.getResource("UJAC_NUMBER_OF_PAGES_TEMPLATES");
            if (numberOfPagesTemplates != null) {
                Iterator iterNumberOfPageTemplates = numberOfPagesTemplates.entrySet().iterator();
                while (iterNumberOfPageTemplates.hasNext()) {
                    Map.Entry entry = iterNumberOfPageTemplates.next();
                    DocumentFont font = (DocumentFont)entry.getKey();
                    PdfTemplate numberOfPagesTemplate = (PdfTemplate)entry.getValue();
                    com.lowagie.text.Font numberOfPagesFont = font.getFont();
                    if (numberOfPagesTemplate == null || numberOfPagesFont == null) continue;
                    BaseFont bf = numberOfPagesFont.getBaseFont();
                    if (numberOfPagesTemplate == null) {
                        return;
                    }
                    numberOfPagesTemplate.beginText();
                    numberOfPagesTemplate.setTextMatrix(0.0f, 1.0f);
                    numberOfPagesTemplate.setFontAndSize(bf, numberOfPagesFont.getSize());
                    Color fontColor = numberOfPagesFont.getColor();
                    if (fontColor != null) {
                        numberOfPagesTemplate.setColorStroke(fontColor);
                        numberOfPagesTemplate.setColorFill(fontColor);
                    }
                    String numberOfPages = String.valueOf(DocumentHandler.this.getPageNumber(writer) - 1);
                    float numberOfPagesWidth = bf.getWidthPoint(numberOfPages, numberOfPagesFont.getSize());
                    numberOfPagesTemplate.setWidth(numberOfPagesWidth + 1.0f);
                    numberOfPagesTemplate.showText(numberOfPages);
                    numberOfPagesTemplate.endText();
                }
                DocumentHandler.this.removeResource("UJAC_NUMBER_OF_PAGES_TEMPLATES");
            }
        }

        public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onParagraph(writer, document, paragraphPosition);
            }
        }

        public void onParagraphEnd(PdfWriter writer, Document document, float paragraphPosition) {
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onParagraphEnd(writer, document, paragraphPosition);
            }
        }

        public void onSection(PdfWriter writer, Document document, float paragraphPosition, int depth, Paragraph title) {
            DocumentHandler.this.flushTocSection(writer, paragraphPosition);
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onSection(writer, document, paragraphPosition, depth, title);
            }
        }

        public void onSectionEnd(PdfWriter writer, Document document, float position) {
            Iterator iter = this.eventHandlers.values().iterator();
            while (iter.hasNext()) {
                DocumentPageEventHandler evtHandler = (DocumentPageEventHandler)((Object)iter.next());
                evtHandler.onSectionEnd(writer, document, position);
            }
        }
    }
}

