/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.util.HashMap;
import java.util.Map;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinitionMap;

public class DocumentHandlerComponentRegistry {
    private static DocumentHandlerComponentRegistry theInstance = new DocumentHandlerComponentRegistry();
    private Map supportedAttributeRegistry = new HashMap();
    private Map supportedStyleAttributeRegistry = new HashMap();
    private Map childDefinitionMapRegistry = new HashMap();

    public static final DocumentHandlerComponentRegistry getInstance() {
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDefinitionMap getSupportedAttributes(BaseDocumentTag tag) {
        Class<?> tagClass = tag.getClass();
        AttributeDefinitionMap attrDefs = (AttributeDefinitionMap)this.supportedAttributeRegistry.get(tagClass);
        if (attrDefs == null) {
            Map map = this.supportedAttributeRegistry;
            synchronized (map) {
                attrDefs = tag.buildSupportedAttributes();
                this.supportedAttributeRegistry.put(tagClass, attrDefs);
            }
        }
        return attrDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDefinitionMap getSupportedStyleAttributes(BaseDocumentTag tag) {
        Class<?> tagClass = tag.getClass();
        AttributeDefinitionMap attrDefs = (AttributeDefinitionMap)this.supportedStyleAttributeRegistry.get(tagClass);
        if (attrDefs == null) {
            Map map = this.supportedStyleAttributeRegistry;
            synchronized (map) {
                attrDefs = tag.buildSupportedStyleAttributes();
                this.supportedStyleAttributeRegistry.put(tagClass, attrDefs);
            }
        }
        return attrDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildDefinitionMap getSupportedChilds(BaseDocumentTag tag) {
        Class<?> tagClass = tag.getClass();
        ChildDefinitionMap childDefs = (ChildDefinitionMap)this.childDefinitionMapRegistry.get(tagClass);
        if (childDefs == null) {
            Map map = this.childDefinitionMapRegistry;
            synchronized (map) {
                childDefs = tag.buildSupportedChilds();
                this.childDefinitionMapRegistry.put(tagClass, childDefs);
            }
        }
        return childDefs;
    }
}

