/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPrinter;
import org.ujac.print.DocumentTagFactory;
import org.ujac.util.io.NullDeviceOutputStream;
import org.ujac.util.xml.XmlUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentTransformHelper
extends DocumentPrinter {
    private DocumentHandler documentHandler = null;
    private OutputStream outputStream = null;
    private boolean supportToc = false;
    private File tmpSourceFile = null;

    public DocumentTransformHelper() {
        this.configure();
    }

    public DocumentTransformHelper(DocumentTagFactory tagFactory) {
        super(tagFactory);
        this.configure();
    }

    public DocumentTransformHelper(Map properties, DocumentTagFactory tagFactory) {
        super(tagFactory);
        this.setProperties(properties);
        this.configure();
    }

    private void configure() {
        this.setTranslateEscapeSequences(false);
        this.setParseDynamicContent(false);
        this.setEvaluateExpressions(false);
    }

    public Result prepare(OutputStream outputStream, boolean supportToc) throws DocumentHandlerException, IOException {
        this.supportToc = supportToc;
        this.outputStream = outputStream;
        this.removeInternalDocumentProperties();
        if (supportToc) {
            File tmpSourceFile = null;
            DocumentHandler documentHandler = null;
            PrintWriter templateCopyWriter = null;
            tmpSourceFile = File.createTempFile("ujac_print", "xml");
            documentHandler = this.createDocumentHandler(new NullDeviceOutputStream());
            documentHandler.setDestinationsSupported(false);
            documentHandler.clearReferences();
            documentHandler.setPageNumberOffset(0);
            documentHandler.setIncludeHeadSection(false);
            templateCopyWriter = new PrintWriter(new FileWriter(tmpSourceFile));
            documentHandler.setTemplateCopyWriter(templateCopyWriter);
        } else {
            this.documentHandler = this.createDocumentHandler(outputStream);
        }
        return this.createTransformationResult(this.documentHandler, this.getModules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws DocumentHandlerException, IOException {
        if (!this.supportToc) {
            return;
        }
        int numPages = (Integer)this.documentHandler.getTemplateContext().get("pageNumber");
        PrintWriter templateCopyWriter = this.documentHandler.getTemplateCopyWriter();
        this.documentHandler.setTemplateCopyWriter(null);
        if (templateCopyWriter != null) {
            templateCopyWriter.close();
        }
        boolean pageNumberingStartsAfterHead = this.isPageNumberingStartsAfterHead();
        try {
            this.documentHandler.setIncludeHeadSection(true);
            this.removeInternalDocumentProperties();
            if (pageNumberingStartsAfterHead) {
                this.documentHandler.setTocFreezed(true);
                this.documentHandler.resetReferences();
            } else {
                this.documentHandler.setTocFreezed(false);
                this.documentHandler.clearReferences();
            }
            this.documentHandler.reset(new NullDeviceOutputStream());
            this.printDocument(this.documentHandler, new InputSource(new FileReader(this.tmpSourceFile)), null);
            int numPagesInclToc = (Integer)this.documentHandler.getTemplateContext().get("pageNumber");
            if (!pageNumberingStartsAfterHead) {
                this.removeInternalDocumentProperties();
                this.documentHandler.setTocFreezed(false);
                this.documentHandler.resetReferences();
                this.documentHandler.reset(new NullDeviceOutputStream());
                this.printDocument(this.documentHandler, new InputSource(new FileReader(this.tmpSourceFile)), null);
            }
            this.removeInternalDocumentProperties();
            if (pageNumberingStartsAfterHead) {
                this.documentHandler.setTocFreezed(true);
                this.documentHandler.resetReferences();
            } else {
                this.documentHandler.setTocFreezed(false);
                this.documentHandler.resetReferences();
            }
            this.documentHandler.reset(this.outputStream);
            int offset = 0;
            if (pageNumberingStartsAfterHead) {
                offset = numPages - numPagesInclToc;
            }
            this.documentHandler.setPageNumberOffset(offset);
            this.documentHandler.setDestinationsSupported(true);
            this.printDocument(this.documentHandler, new InputSource(new FileReader(this.tmpSourceFile)), null);
        }
        finally {
            this.tmpSourceFile.delete();
        }
    }

    private Result createTransformationResult(DocumentHandler documentHandler, List modules) throws DocumentHandlerException, IOException {
        try {
            if (modules != null && modules.size() > 0) {
                XMLReader xmlReader = this.createXmlReader();
                xmlReader.setContentHandler(documentHandler);
                XmlUtils.disableEntityResolver(xmlReader);
                if (modules != null) {
                    int numModules = modules.size();
                    for (int i = 0; i < numModules; ++i) {
                        byte[] moduleCode = (byte[])modules.get(i);
                        xmlReader.parse(new InputSource(new ByteArrayInputStream(moduleCode)));
                    }
                }
            }
            SAXResult result = new SAXResult(documentHandler);
            return result;
        }
        catch (SAXException ex) {
            Exception cause = ex.getException();
            if (cause != null) {
                if (cause instanceof DocumentHandlerException) {
                    throw (DocumentHandlerException)cause;
                }
                throw new DocumentHandlerException(documentHandler.locator(), ex.getMessage(), cause);
            }
            throw new DocumentHandlerException(documentHandler.locator(), ex.getMessage(), ex);
        }
    }
}

