/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentPrinter;
import org.ujac.print.DocumentTagFactory;
import org.ujac.print.TagBuilder;
import org.ujac.print.TagInstantiationException;
import org.ujac.util.CollectionUtils;

public class DtdGenerator {
    private DocumentTagFactory tagFactory = null;

    public DtdGenerator(DocumentTagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public void generateDtd(Writer out) throws IOException {
        try {
            List allPossibleChilds = this.tagFactory.getAllPossibleChilds();
            int numPossibleChilds = allPossibleChilds.size();
            Iterator typeIter = this.tagFactory.getTagTypes().entrySet().iterator();
            while (typeIter.hasNext()) {
                Map.Entry typeEntry = typeIter.next();
                String name = (String)typeEntry.getKey();
                TagBuilder builder = (TagBuilder)typeEntry.getValue();
                BaseDocumentTag tag = builder.createTag(null);
                tag.setTagFactory(this.tagFactory);
                out.write("<!ELEMENT " + name);
                ChildDefinitionMap supportedChilds = tag.buildSupportedChilds();
                if (tag.isVirtualContainer()) {
                    out.write(" (");
                    boolean first = true;
                    if (tag.isTextBodyAllowed()) {
                        out.write("#PCDATA");
                        first = false;
                    }
                    for (int i = 0; i < numPossibleChilds; ++i) {
                        BaseDocumentTag childTag = (BaseDocumentTag)allPossibleChilds.get(i);
                        if (childTag.isDocumentRoot()) continue;
                        if (first) {
                            first = false;
                        } else {
                            out.write(" | ");
                        }
                        out.write(childTag.getName());
                    }
                    out.write(")*>\n");
                } else if (supportedChilds != null && supportedChilds.size() > 0) {
                    out.write(" (");
                    if (tag.isTextBodyAllowed()) {
                        out.write("#PCDATA | ");
                    }
                    HashSet<String> childSet = new HashSet<String>();
                    int numSupportedChilds = supportedChilds.size();
                    List supportedChildList = supportedChilds.getSortedChilds();
                    for (int i = 0; i < numSupportedChilds; ++i) {
                        ChildDefinition child = (ChildDefinition)supportedChildList.get(i);
                        Class childType = child.getType();
                        for (int j = 0; j < numPossibleChilds; ++j) {
                            BaseDocumentTag childTag = (BaseDocumentTag)allPossibleChilds.get(j);
                            if (!childType.isInstance(childTag)) continue;
                            childSet.add(childTag.getName());
                        }
                    }
                    Iterator iterChilds = childSet.iterator();
                    int childIdx = 0;
                    while (iterChilds.hasNext()) {
                        if (childIdx > 0) {
                            out.write(" | ");
                        }
                        out.write(iterChilds.next().toString());
                        ++childIdx;
                    }
                    out.write(")*>\n");
                } else if (tag.isTextBodyAllowed()) {
                    out.write(" (#PCDATA)>\n");
                } else {
                    out.write(" EMPTY>\n");
                }
                String aliasName = null;
                AttributeDefinitionMap supportedAttributes = tag.buildSupportedAttributes();
                if (!CollectionUtils.isEmpty(supportedAttributes)) {
                    out.write("<!ATTLIST " + name + "\n");
                    List attributes = supportedAttributes.getSortedAttributes();
                    int numSortedAttributes = supportedAttributes.size();
                    for (int i = 0; i < numSortedAttributes; ++i) {
                        AttributeDefinition attribute = (AttributeDefinition)attributes.get(i);
                        int numAliases = 0;
                        Iterator iterLocalAliases = attribute.getAliases().iterator();
                        while (iterLocalAliases.hasNext()) {
                            aliasName = iterLocalAliases.next().toString();
                            ++numAliases;
                            this.writeAttribute(out, aliasName, attribute.getType(), false);
                        }
                        this.writeAttribute(out, attribute.getName(), attribute.getType(), attribute.isRequired() && numAliases == 0);
                    }
                    out.write(">\n");
                }
                out.write("\n");
            }
        }
        catch (TagInstantiationException ex) {
            throw new IOException(ex.getMessage());
        }
        out.flush();
    }

    private void writeAttribute(Writer out, String name, int type, boolean required) throws IOException {
        out.write("  " + name + " " + DtdGenerator.attributeTypeToDtdType(type));
        out.write(" #");
        if (required) {
            out.write("REQUIRED");
        } else {
            out.write("IMPLIED");
        }
        out.write("\n");
    }

    protected static String attributeTypeToDtdType(int attributeType) {
        switch (attributeType) {
            case 3: {
                return "CDATA";
            }
            case 6: {
                return "CDATA";
            }
            case 5: {
                return "CDATA";
            }
            case 2: {
                return "CDATA";
            }
            case 14: {
                return "CDATA";
            }
            case 10: {
                return "CDATA";
            }
            case 11: {
                return "CDATA";
            }
            case 7: {
                return "CDATA";
            }
            case 8: {
                return "CDATA";
            }
            case 1: {
                return "CDATA";
            }
            case 9: {
                return "(LETTER | NOTE | LEGAL | A0 | A1 | A2 | A3 | A4 | A5 | A6 | A7 | A8 | A9 | A10 | B0 | B1 | B2 | B3 | B4 | B5)";
            }
            case 4: {
                return "CDATA";
            }
            case 12: {
                return "CDATA";
            }
            case 13: {
                return "CDATA";
            }
        }
        return "unsupported";
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("usage: org.ujac.print.DtdGenerator [<output file>]");
            System.exit(1);
        }
        try {
            OutputStreamWriter writer = null;
            DocumentTagFactory tagFactory = null;
            if (args.length < 1) {
                writer = new OutputStreamWriter(System.out);
                tagFactory = new DocumentPrinter().getTagFactory();
            } else {
                writer = new FileWriter(args[0]);
                tagFactory = args.length > 1 ? (DocumentTagFactory)Class.forName(args[1]).newInstance() : new DocumentPrinter().getTagFactory();
            }
            DtdGenerator dg = new DtdGenerator(tagFactory);
            dg.generateDtd(writer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

