/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.SetFieldTag;
import org.ujac.util.BeanUtils;
import org.ujac.util.table.Column;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.template.TemplateException;

public class AddRowTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "add-row";
    private String tableName = null;
    private boolean distinct = false;
    private Table table = null;
    private Row row = null;
    private Map fieldValues;

    public AddRowTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a row to the specified table.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.ALTER_TABLE).addDefinition(CommonAttributes.ALTER_DISTINCT);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(SetFieldTag.class, 0, 999));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.tableName = this.getStringAttribute(CommonAttributes.ALTER_TABLE, false, null);
        this.distinct = this.getBooleanAttribute(CommonAttributes.ALTER_DISTINCT, true, null);
        Object to = this.documentHandler.getTemplateContext().getProperty(this.tableName);
        if (to == null) {
            throw new TagAttributeException(this.locator(), "Can't add row to undefined table '" + this.tableName + "'.");
        }
        this.table = (Table)to;
        try {
            if (this.distinct) {
                this.fieldValues = new HashMap();
            } else {
                this.row = this.table.addRow();
            }
        }
        catch (TableException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to add row to table '" + this.tableName + "': " + ex.getMessage(), ex);
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.distinct) {
            try {
                int numRows = this.table.getRowCount();
                int numValues = this.fieldValues.size();
                int[] fieldIds = new int[numValues];
                Object[] fieldVals = new Object[numValues];
                Set valueEntries = this.fieldValues.entrySet();
                Iterator iterValueEntries = valueEntries.iterator();
                int idx = 0;
                while (iterValueEntries.hasNext()) {
                    Map.Entry entry = iterValueEntries.next();
                    String key = (String)entry.getKey();
                    Column col = this.table.getColumn(key);
                    fieldIds[idx] = col.getIndex();
                    fieldVals[idx] = entry.getValue();
                    ++idx;
                }
                boolean rowMatched = false;
                for (int i = 0; i < numRows; ++i) {
                    Object val;
                    Object rowVal;
                    Row row = this.table.getRow(i);
                    int j = 0;
                    if (j >= numValues || !BeanUtils.equals(rowVal = row.getObject(fieldIds[j]), val = fieldVals[j])) continue;
                    rowMatched = true;
                    break;
                }
                if (!rowMatched) {
                    this.row = this.table.addRow();
                    for (int j = 0; j < numValues; ++j) {
                        this.row.setObject(fieldIds[j], fieldVals[j]);
                    }
                }
            }
            catch (TableException ex) {
                throw new DocumentHandlerException(this.locator(), "Failed to perform distinct checks: " + ex.getMessage(), ex);
            }
        }
        this.documentHandler.getTemplateContext().setProperty(this.tableName, this.table);
    }

    public Table getTable() {
        return this.table;
    }

    public void setFieldValue(String fieldName, String value) throws DocumentHandlerException {
        try {
            Column column = this.table.getColumn(fieldName);
            Object val = null;
            switch (column.getType()) {
                case 2: {
                    val = new Integer(this.documentHandler.evalInt(value));
                    break;
                }
                case 5: {
                    val = new Float(this.documentHandler.evalFloat(value));
                    break;
                }
                case 4: {
                    val = new Long(this.documentHandler.evalLong(value));
                    break;
                }
                case 6: {
                    val = new Double(this.documentHandler.evalDouble(value));
                    break;
                }
                case 1: {
                    val = this.documentHandler.executeTemplate(value);
                    break;
                }
                case 8: {
                    val = this.documentHandler.evalDate(value);
                    break;
                }
                case 9: {
                    val = this.documentHandler.evalTime(value);
                    break;
                }
                case 10: {
                    val = this.documentHandler.evalTimestamp(value);
                    break;
                }
                default: {
                    val = this.documentHandler.evalObject(value);
                }
            }
            if (this.distinct) {
                this.fieldValues.put(fieldName, val);
            } else {
                this.row.setObject(fieldName, val);
            }
        }
        catch (TableException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to set value '" + value + "' for field '" + fieldName + "'.", ex);
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Failed to evaluate value '" + value + "' for field '" + fieldName + "'.", ex);
        }
    }
}

