/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.PrintTableTag;

public class AlterColumnTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "alter-column";
    private PrintTableTag printTableTag = null;

    public AlterColumnTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Alters a column at the surrounding &lt;print-table&gt; tag.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.COLUMN_NAME).addDefinition(CommonAttributes.COLUMN_WIDTH).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.COLUMN_TITLE);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.printTableTag = (PrintTableTag)this.documentHandler.latestOfType(PrintTableTag.class);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (!this.printTableTag.isFirstLoop()) {
            return;
        }
        String name = this.getStringAttribute(CommonAttributes.COLUMN_NAME, true, null);
        float width = this.getFloatAttribute(CommonAttributes.COLUMN_WIDTH, -1.0f, true, null);
        int hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, -1, true, null);
        String title = this.getTextAttribute(CommonAttributes.COLUMN_TITLE, true, null);
        this.printTableTag.alterColumn(name, width, hAlign, title, this.getContent());
    }
}

