/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AssertionException;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.util.exi.ExpressionException;

public class AssertTag
extends BaseDocumentTag {
    public static final String TAG_NAME = "assert";

    public AssertTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Tests the given condition and throws an exception in case the result isn't true.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CONDITION);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String condition = this.getStringAttribute(CommonAttributes.CONDITION, false, null);
        try {
            boolean result = this.documentHandler.evalBoolean("${" + condition + "}");
            if (!result) {
                throw new AssertionException(this.locator(), "Assertion failed: " + condition + "!");
            }
        }
        catch (ExpressionException ex) {
            throw new AssertionException(this.locator(), "Assertion failed: " + condition + ": " + ex.getMessage(), ex);
        }
    }
}

