/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.pdf.PdfPCell;
import java.awt.Color;
import org.ujac.print.AttributeHandler;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.util.BeanUtils;

public class CellAttributes
implements Cloneable {
    public static final float DEFAULT_PADDING = 2.0f;
    public static final int DEFAULT_HALIGN = 0;
    public static final int DEFAULT_VALIGN = 6;
    private float leading = 0.0f;
    private float lineSpacing = 1.2f;
    private int hAlign = -1;
    private int vAlign = -1;
    protected Color bgColor = null;
    protected int borderStyle = 0;
    protected Color borderColor = null;
    protected float borderWidth = 0.0f;
    protected Color borderLeftColor = null;
    protected float borderLeftWidth = 0.0f;
    protected Color borderRightColor = null;
    protected float borderRightWidth = 0.0f;
    protected Color borderTopColor = null;
    protected float borderTopWidth = 0.0f;
    protected Color borderBottomColor = null;
    protected float borderBottomWidth = 0.0f;
    protected float padding = 2.0f;
    protected float paddingLeft = 2.0f;
    protected float paddingRight = 2.0f;
    protected float paddingTop = 2.0f;
    protected float paddingBottom = 2.0f;
    protected float fixedHeight = -1.0f;
    protected boolean noWrap = false;
    protected int colspan = 1;
    protected boolean fillRow = false;

    public CellAttributes(CommonAttributesHolder commonAttributesHolder) {
        if (commonAttributesHolder != null) {
            this.lineSpacing = commonAttributesHolder.getLineSpacing();
            this.leading = commonAttributesHolder.getLeading();
        }
    }

    public void parseAttributes(BaseDocumentTag tag, CellAttributes parentAttributes) throws TagAttributeException {
        this.parseCommonAttributes(tag, parentAttributes);
    }

    public void parseTableAttributes(BaseDocumentTag tag, CellAttributes parentAttributes) throws TagAttributeException {
        this.parseCommonAttributes(tag, parentAttributes);
        AttributeHandler attrHandler = tag.getAttributeHandler();
        Object attrVal = tag.getAttribute(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT, null, true, CommonAttributes.CELL_HORIZONTAL_ALIGNMENT, attrHandler.getHorizontalAlignmentHandler());
        this.hAlign = attrVal != null ? ((Number)attrVal).intValue() : -1;
        attrVal = tag.getAttribute(CommonAttributes.CELL_VERTICAL_ALIGNMENT, null, true, CommonAttributes.CELL_VERTICAL_ALIGNMENT, attrHandler.getVerticalAlignmentHandler());
        this.vAlign = attrVal != null ? ((Number)attrVal).intValue() : -1;
    }

    public void parseRowAttributes(BaseDocumentTag tag, CellAttributes parentAttributes) throws TagAttributeException {
        this.parseCommonAttributes(tag, parentAttributes);
    }

    private void parseCommonAttributes(BaseDocumentTag tag, CellAttributes parentAttributes) throws TagAttributeException {
        AttributeHandler attrHandler;
        Object attrVal;
        if (parentAttributes != null) {
            this.leading = parentAttributes.getLeading();
            this.lineSpacing = parentAttributes.getLineSpacing();
            this.bgColor = parentAttributes.getBgColor();
            this.borderStyle = parentAttributes.getBorderStyle();
            this.borderWidth = parentAttributes.getBorderWidth();
            this.borderColor = parentAttributes.getBorderColor();
            this.borderLeftWidth = parentAttributes.getBorderLeftWidth();
            this.borderLeftColor = parentAttributes.getBorderLeftColor();
            this.borderRightWidth = parentAttributes.getBorderRightWidth();
            this.borderRightColor = parentAttributes.getBorderRightColor();
            this.borderTopWidth = parentAttributes.getBorderTopWidth();
            this.borderTopColor = parentAttributes.getBorderTopColor();
            this.borderBottomWidth = parentAttributes.getBorderBottomWidth();
            this.borderBottomColor = parentAttributes.getBorderBottomColor();
            this.fixedHeight = parentAttributes.getFixedHeight();
            this.noWrap = parentAttributes.isNoWrap();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.LEADING, null, true, CommonStyleAttributes.LEADING, (attrHandler = tag.getAttributeHandler()).getDimensionHandler())) != null) {
            this.leading = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.LINE_SPACING, null, true, CommonStyleAttributes.LINE_SPACING, attrHandler.getDimensionHandler())) != null) {
            this.lineSpacing = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.BACKGROUND_COLOR, null, true, CommonStyleAttributes.BACKGROUND_COLOR, attrHandler.getColorHandler())) != null) {
            this.bgColor = (Color)attrVal;
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.BORDER_STYLE, null, true, CommonStyleAttributes.BORDER_STYLE, attrHandler.getBorderHandler())) != null) {
            this.borderStyle = ((Number)attrVal).intValue();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.BORDER_WIDTH, null, true, CommonStyleAttributes.BORDER_WIDTH, attrHandler.getDimensionHandler())) != null) {
            this.borderLeftWidth = this.borderWidth = ((Number)attrVal).floatValue();
            this.borderRightWidth = this.borderWidth;
            this.borderTopWidth = this.borderWidth;
            this.borderBottomWidth = this.borderWidth;
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.BORDER_COLOR, null, true, CommonStyleAttributes.BORDER_COLOR, attrHandler.getColorHandler())) != null) {
            this.borderLeftColor = this.borderColor = (Color)attrVal;
            this.borderRightColor = this.borderColor;
            this.borderTopColor = this.borderColor;
            this.borderBottomColor = this.borderColor;
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_LEFT_WIDTH, attrHandler.getDimensionHandler())) != null) {
            this.borderLeftWidth = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_RIGHT_WIDTH, attrHandler.getDimensionHandler())) != null) {
            this.borderRightWidth = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_TOP_WIDTH, attrHandler.getDimensionHandler())) != null) {
            this.borderTopWidth = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_BOTTOM_WIDTH, attrHandler.getDimensionHandler())) != null) {
            this.borderBottomWidth = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_LEFT_COLOR, attrHandler.getColorHandler())) != null) {
            this.borderLeftColor = (Color)attrVal;
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_RIGHT_COLOR, attrHandler.getColorHandler())) != null) {
            this.borderRightColor = (Color)attrVal;
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_TOP_COLOR, attrHandler.getColorHandler())) != null) {
            this.borderTopColor = (Color)attrVal;
        }
        if ((attrVal = tag.getAttribute(null, null, true, CommonStyleAttributes.BORDER_BOTTOM_COLOR, attrHandler.getColorHandler())) != null) {
            this.borderBottomColor = (Color)attrVal;
        }
        this.padding = 2.0f;
        this.paddingLeft = 2.0f;
        this.paddingRight = 2.0f;
        this.paddingTop = 2.0f;
        this.paddingBottom = 2.0f;
        if (parentAttributes != null) {
            this.padding = parentAttributes.getPadding();
            this.paddingLeft = parentAttributes.getPaddingLeft();
            this.paddingRight = parentAttributes.getPaddingRight();
            this.paddingTop = parentAttributes.getPaddingTop();
            this.paddingBottom = parentAttributes.getPaddingBottom();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.PADDING, null, true, CommonAttributes.PADDING, attrHandler.getDimensionHandler())) != null) {
            this.paddingLeft = this.padding = ((Number)attrVal).floatValue();
            this.paddingRight = this.padding;
            this.paddingTop = this.padding;
            this.paddingBottom = this.padding;
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.PADDING_LEFT, null, true, CommonStyleAttributes.PADDING_LEFT, attrHandler.getDimensionHandler())) != null) {
            this.paddingLeft = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.PADDING_RIGHT, null, true, CommonStyleAttributes.PADDING_RIGHT, attrHandler.getDimensionHandler())) != null) {
            this.paddingRight = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.PADDING_TOP, null, true, CommonStyleAttributes.PADDING_TOP, attrHandler.getDimensionHandler())) != null) {
            this.paddingTop = ((Number)attrVal).floatValue();
        }
        if ((attrVal = tag.getAttribute(CommonAttributes.PADDING_BOTTOM, null, true, CommonStyleAttributes.PADDING_BOTTOM, attrHandler.getDimensionHandler())) != null) {
            this.paddingBottom = ((Number)attrVal).floatValue();
        }
        if (tag.isAttributeSupported(CommonAttributes.NO_WRAP) && (attrVal = tag.getAttribute(CommonAttributes.NO_WRAP, null, true, CommonStyleAttributes.NO_WRAP, attrHandler.getBooleanHandler())) != null) {
            this.noWrap = (Boolean)attrVal;
        }
        if (tag.isAttributeSupported(CommonAttributes.CELL_HEIGHT) && (attrVal = tag.getAttribute(CommonAttributes.CELL_HEIGHT, null, true, CommonStyleAttributes.CELL_HEIGHT, attrHandler.getDimensionHandler())) != null) {
            this.fixedHeight = ((Number)attrVal).floatValue();
        }
        if (tag.isAttributeSupported(CommonAttributes.COLSPAN) && (attrVal = tag.getAttribute(CommonAttributes.COLSPAN, null, true, null, attrHandler.getIntegerHandler())) != null) {
            this.colspan = ((Number)attrVal).intValue();
        }
        if (tag.isAttributeSupported(CommonAttributes.FILL_ROW) && (attrVal = tag.getAttribute(CommonAttributes.FILL_ROW, null, true, null, attrHandler.getBooleanHandler())) != null) {
            this.fillRow = (Boolean)attrVal;
        }
        attrVal = null;
        if (tag.isAttributeSupported(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT)) {
            attrVal = tag.getAttribute(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT, null, true, CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT, attrHandler.getHorizontalAlignmentHandler());
        }
        if (attrVal == null && tag.isAttributeSupported(CommonAttributes.HORIZONTAL_ALIGNMENT)) {
            attrVal = tag.getAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, null, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT, attrHandler.getHorizontalAlignmentHandler());
        }
        if (attrVal != null) {
            this.hAlign = ((Number)attrVal).intValue();
        } else if (parentAttributes != null) {
            this.hAlign = parentAttributes.getHAlign();
        }
        attrVal = null;
        if (tag.isAttributeSupported(CommonAttributes.CELL_VERTICAL_ALIGNMENT)) {
            attrVal = tag.getAttribute(CommonAttributes.CELL_VERTICAL_ALIGNMENT, null, true, CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT, attrHandler.getVerticalAlignmentHandler());
        }
        if (attrVal == null && tag.isAttributeSupported(CommonAttributes.VERTICAL_ALIGNMENT)) {
            attrVal = tag.getAttribute(CommonAttributes.VERTICAL_ALIGNMENT, null, true, CommonStyleAttributes.VERTICAL_ALIGNMENT, attrHandler.getVerticalAlignmentHandler());
        }
        if (attrVal != null) {
            this.vAlign = ((Number)attrVal).intValue();
        } else if (parentAttributes != null) {
            this.vAlign = parentAttributes.getVAlign();
        }
    }

    public void merge(CellAttributes attr) {
        boolean boolValue;
        int intVal;
        Color colorVal;
        float floatVal = attr.getLeading();
        if (floatVal >= 0.0f) {
            this.leading = floatVal;
        }
        if ((floatVal = attr.getLineSpacing()) >= 0.0f) {
            this.lineSpacing = floatVal;
        }
        if ((colorVal = attr.getBgColor()) != null) {
            this.bgColor = colorVal;
        }
        if ((floatVal = attr.getBorderWidth()) >= 0.0f) {
            this.borderLeftWidth = this.borderWidth = floatVal;
            this.borderRightWidth = this.borderWidth;
            this.borderTopWidth = this.borderWidth;
            this.borderBottomWidth = this.borderWidth;
        }
        if ((intVal = attr.getBorderStyle()) >= 0) {
            this.borderStyle = intVal;
        }
        if ((colorVal = attr.getBorderColor()) != null) {
            this.borderLeftColor = this.borderColor = colorVal;
            this.borderRightColor = this.borderColor;
            this.borderTopColor = this.borderColor;
            this.borderBottomColor = this.borderColor;
        }
        if ((floatVal = attr.getBorderLeftWidth()) >= 0.0f) {
            this.borderLeftWidth = floatVal;
        }
        if ((floatVal = attr.getBorderRightWidth()) >= 0.0f) {
            this.borderRightWidth = floatVal;
        }
        if ((floatVal = attr.getBorderTopWidth()) >= 0.0f) {
            this.borderTopWidth = floatVal;
        }
        if ((floatVal = attr.getBorderBottomWidth()) >= 0.0f) {
            this.borderBottomWidth = floatVal;
        }
        if ((colorVal = attr.getBorderLeftColor()) != null) {
            this.borderLeftColor = colorVal;
        }
        if ((colorVal = attr.getBorderRightColor()) != null) {
            this.borderRightColor = colorVal;
        }
        if ((colorVal = attr.getBorderTopColor()) != null) {
            this.borderTopColor = colorVal;
        }
        if ((colorVal = attr.getBorderBottomColor()) != null) {
            this.borderBottomColor = colorVal;
        }
        if ((floatVal = attr.getPadding()) >= 0.0f) {
            this.paddingLeft = this.padding = floatVal;
            this.paddingRight = this.padding;
            this.paddingTop = this.padding;
            this.paddingBottom = this.padding;
        }
        if ((floatVal = attr.getPaddingLeft()) >= 0.0f) {
            this.paddingLeft = floatVal;
        }
        if ((floatVal = attr.getPaddingRight()) >= 0.0f) {
            this.paddingRight = floatVal;
        }
        if ((floatVal = attr.getPaddingTop()) >= 0.0f) {
            this.paddingTop = floatVal;
        }
        if ((floatVal = attr.getPaddingBottom()) >= 0.0f) {
            this.paddingBottom = floatVal;
        }
        this.noWrap = boolValue = attr.isNoWrap();
        this.fillRow = boolValue = attr.isFillRow();
        floatVal = attr.getFixedHeight();
        if (floatVal >= 0.0f) {
            this.fixedHeight = floatVal;
        }
        if ((intVal = attr.getColspan()) >= 0) {
            this.colspan = intVal;
        }
        if ((intVal = attr.getHAlign()) >= 0) {
            this.hAlign = intVal;
        }
        if ((intVal = attr.getVAlign()) >= 0) {
            this.vAlign = intVal;
        }
    }

    public void setupCell(PdfPCell cell) {
        float leading = this.getLeading();
        float lineSpacing = this.getLineSpacing();
        cell.setLeading(leading, lineSpacing);
        if (cell != null) {
            int hAlign;
            Color borderBottomColor;
            Color borderTopColor;
            Color borderRightColor;
            Color borderLeftColor;
            float borderBottomWidth;
            float borderTopWidth;
            float borderRightWidth;
            float borderLeftWidth;
            float borderWidth;
            Color bgColor = this.getBgColor();
            if (bgColor != null) {
                cell.setBackgroundColor(bgColor);
            }
            if ((borderWidth = this.getBorderWidth()) > 0.0f) {
                cell.setBorderWidth(borderWidth);
            }
            if ((borderLeftWidth = this.getBorderLeftWidth()) != borderWidth) {
                cell.setBorderWidthLeft(borderLeftWidth);
                cell.setUseVariableBorders(true);
            }
            if ((borderRightWidth = this.getBorderRightWidth()) != borderWidth) {
                cell.setBorderWidthRight(borderRightWidth);
                cell.setUseVariableBorders(true);
            }
            if ((borderTopWidth = this.getBorderTopWidth()) != borderWidth) {
                cell.setBorderWidthTop(borderTopWidth);
                cell.setUseVariableBorders(true);
            }
            if ((borderBottomWidth = this.getBorderBottomWidth()) != borderWidth) {
                cell.setBorderWidthBottom(borderBottomWidth);
                cell.setUseVariableBorders(true);
            }
            if (this.colspan > 0) {
                cell.setColspan(this.colspan);
            }
            cell.setBorder(this.getBorderStyle());
            Color borderColor = this.getBorderColor();
            if (borderColor != null) {
                cell.setBorderColor(borderColor);
            }
            if (!BeanUtils.equals(borderLeftColor = this.getBorderLeftColor(), borderColor)) {
                cell.setBorderColorLeft(borderLeftColor);
                cell.setUseVariableBorders(true);
            }
            if (!BeanUtils.equals(borderRightColor = this.getBorderRightColor(), borderColor)) {
                cell.setBorderColorRight(borderRightColor);
                cell.setUseVariableBorders(true);
            }
            if (!BeanUtils.equals(borderTopColor = this.getBorderTopColor(), borderColor)) {
                cell.setBorderColorTop(borderTopColor);
                cell.setUseVariableBorders(true);
            }
            if (!BeanUtils.equals(borderBottomColor = this.getBorderBottomColor(), borderColor)) {
                cell.setBorderColorBottom(borderBottomColor);
                cell.setUseVariableBorders(true);
            }
            if ((hAlign = this.getHAlign()) < 0) {
                hAlign = 0;
            }
            cell.setHorizontalAlignment(hAlign);
            int vAlign = this.getVAlign();
            if (vAlign < 0) {
                vAlign = 6;
            }
            cell.setVerticalAlignment(vAlign);
            cell.setPaddingLeft(this.getPaddingLeft());
            cell.setPaddingRight(this.getPaddingRight());
            cell.setPaddingTop(this.getPaddingTop());
            cell.setPaddingBottom(this.getPaddingBottom());
            cell.setNoWrap(this.isNoWrap());
            float fixedHeigth = this.getFixedHeight();
            if (fixedHeigth > 0.0f) {
                cell.setFixedHeight(fixedHeigth);
            }
        }
    }

    public Object clone() {
        CellAttributes clone = null;
        try {
            clone = (CellAttributes)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Failed to clone CellAttributes instance: " + ex.getMessage(), ex);
        }
        return clone;
    }

    public float getLeading() {
        return this.leading;
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public int getHAlign() {
        return this.hAlign;
    }

    public void setHAlign(int hAlign) {
        this.hAlign = hAlign;
    }

    public int getVAlign() {
        return this.vAlign;
    }

    public void setVAlign(int vAlign) {
        this.vAlign = vAlign;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Color getBorderLeftColor() {
        return this.borderLeftColor;
    }

    public void setBorderLeftColor(Color borderLeftColor) {
        this.borderLeftColor = borderLeftColor;
    }

    public float getBorderLeftWidth() {
        return this.borderLeftWidth;
    }

    public void setBorderLeftWidth(float borderLeftWidth) {
        this.borderLeftWidth = borderLeftWidth;
    }

    public Color getBorderRightColor() {
        return this.borderRightColor;
    }

    public void setBorderRightColor(Color borderRightColor) {
        this.borderRightColor = borderRightColor;
    }

    public float getBorderRightWidth() {
        return this.borderRightWidth;
    }

    public void setBorderRightWidth(float borderRightWidth) {
        this.borderRightWidth = borderRightWidth;
    }

    public Color getBorderTopColor() {
        return this.borderTopColor;
    }

    public void setBorderTopColor(Color borderTopColor) {
        this.borderTopColor = borderTopColor;
    }

    public float getBorderTopWidth() {
        return this.borderTopWidth;
    }

    public void setBorderTopWidth(float borderTopWidth) {
        this.borderTopWidth = borderTopWidth;
    }

    public Color getBorderBottomColor() {
        return this.borderBottomColor;
    }

    public void setBorderBottomColor(Color borderBottomColor) {
        this.borderBottomColor = borderBottomColor;
    }

    public float getBorderBottomWidth() {
        return this.borderBottomWidth;
    }

    public void setBorderBottomWidth(float borderBottomWidth) {
        this.borderBottomWidth = borderBottomWidth;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setPadding(float padding) {
        this.padding = padding;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(float paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(float paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(float paddingRight) {
        this.paddingRight = paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }

    public boolean isNoWrap() {
        return this.noWrap;
    }

    public void setNoWrap(boolean noWrap) {
        this.noWrap = noWrap;
    }

    public float getFixedHeight() {
        return this.fixedHeight;
    }

    public void setFixedHeight(float fixedHeight) {
        this.fixedHeight = fixedHeight;
    }

    public int getColspan() {
        return this.colspan;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    public boolean isFillRow() {
        return this.fillRow;
    }

    public void setFillRow(boolean fillRow) {
        this.fillRow = fillRow;
    }
}

