/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import java.awt.Color;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.CellContainer;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DateFormatTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NumberFormatTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.SpaceTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TableTag;

public class CellTag
extends BaseDocumentTag
implements ElementContainer,
CellContainer,
FontHolder,
StyleHolder {
    public static final String TAG_NAME = "cell";
    private CellAttributes cellAttributes = null;
    protected CellContainer cellContainer = null;
    private Cell cell = null;
    private int elementCount = 0;
    private int cellCount = 0;
    private int colspan = 0;
    private boolean fillRow = false;

    public CellTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a cell to the surrounding table.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.COLSPAN).addDefinition(CommonAttributes.FILL_ROW).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.NO_WRAP);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.COLSPAN).addDefinition(CommonStyleAttributes.FILL_ROW).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.NO_WRAP);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 1)).addDefinition(new ChildDefinition(ParagraphTag.class, 0, 1)).addDefinition(new ChildDefinition(CellTag.class, 0, 1)).addDefinition(new ChildDefinition(TableTag.class, 0, 1)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(SpaceTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(NumberFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(DateFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(ListTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.cellContainer = this.documentHandler.latestCellContainer();
        CommonAttributesHolder lineSpacingHolder = this.getCommonAttributesHolder();
        this.cellAttributes = new CellAttributes(lineSpacingHolder);
        this.cellAttributes.parseAttributes(this, null);
        if (this.isAttributeDefined(CommonAttributes.COLSPAN)) {
            this.colspan = this.getIntegerAttribute(CommonAttributes.COLSPAN, true, null);
        }
        if (this.isAttributeDefined(CommonAttributes.FILL_ROW)) {
            this.fillRow = this.getBooleanAttribute(CommonAttributes.FILL_ROW, true, null);
            if (this.fillRow) {
                this.colspan = this.cellContainer.getRemainingColumns();
            }
        }
    }

    public void openItem() throws DocumentHandlerException {
        float borderWidth;
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.cell = new Cell();
        Color bgColor = this.cellAttributes.getBgColor();
        if (bgColor != null) {
            this.cell.setBackgroundColor(bgColor);
        }
        if ((borderWidth = this.cellAttributes.getBorderWidth()) > 0.0f) {
            this.cell.setBorderWidth(borderWidth);
        }
        if (this.colspan > 0) {
            this.cell.setColspan(this.colspan);
        }
        this.cell.setBorder(this.cellAttributes.getBorderStyle());
        Color borderColor = this.cellAttributes.getBorderColor();
        if (borderColor != null) {
            this.cell.setBorderColor(borderColor);
        }
        this.cell.setHorizontalAlignment(this.cellAttributes.getHAlign());
        this.cell.setVerticalAlignment(this.cellAttributes.getVAlign());
        this.cell.setMaxLines(this.cellAttributes.isNoWrap() ? 1 : 0);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.elementCount == 0 && this.cellCount == 0) {
            try {
                this.cell.addElement((Element)this.addChunk(new Phrase(0.0f), this.getLeading(), this.getLineSpacing()));
            }
            catch (DocumentException ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to add phrase to the " + this.getName() + ": " + ex.getMessage(), ex);
            }
        }
        this.cellContainer.addCell(this, this.cell);
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.cellCount > 0) {
            throw new DocumentHandlerException(this.locator(), "Can't hold elements and cells within a cell.");
        }
        ++this.cellCount;
        try {
            this.cell.addElement(element);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add element to the " + this.getName() + ": " + ex.getMessage(), ex);
        }
    }

    public boolean isTopLevel() {
        return false;
    }

    public float getLeading() {
        return this.cellAttributes.getLeading();
    }

    public float getLineSpacing() {
        return this.cellAttributes.getLineSpacing();
    }

    public void addCell(BaseDocumentTag item, Cell cell) throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.elementCount > 0) {
            throw new DocumentHandlerException(this.locator(), "Can't hold elements and cells within a cell.");
        }
        ++this.cellCount;
        try {
            cell.addElement((Element)cell);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add cell to the " + this.getName() + ": " + ex.getMessage(), ex);
        }
    }

    public int getRemainingColumns() {
        return 1;
    }

    public CellAttributes getCellAttributes() {
        return this.cellAttributes;
    }
}

