/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.TocItem;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.SectionTag;
import org.ujac.util.template.TemplateContext;

public class ChapterTag
extends SectionTag {
    public static final String PROP_CAPTER_ID = "chapterId";
    public static final String TAG_NAME = "chapter";
    private static final AttributeDefinition CHAPTER_FONT = CommonAttributes.FONT.cloneAttrDef("The name of the font definition to use for the chapter contents.");
    private static final AttributeDefinition CHAPTER_FONT_NAME_STYLE = CommonStyleAttributes.FONT_NAME.cloneAttrDef("The name of the font definition to use for the chapter contents.");
    private static final AttributeDefinition SECTION_NUMBER_STYLE = new AttributeDefinition("number-style", 1, false, "The style of the chapter number: 0 = trailing dot, 1 = no trailing dot");
    private static final AttributeDefinition SECTION_NUMBER_STYLE_STYLE = new AttributeDefinition("number-style", 1, false, "The style of the chapter number: 0 = trailing dot, 1 = no trailing dot");
    private int numberStyle = 0;
    private Paragraph title = null;

    public ChapterTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a chapter to the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CHAPTER_NUMBER).addDefinition(CommonAttributes.CHAPTER_TITLE).addDefinition(CommonAttributes.CHAPTER_TITLE_FONT).addDefinition(CHAPTER_FONT).addDefinition(CommonAttributes.SPACING_BEFORE).addDefinition(CommonAttributes.SPACING_AFTER).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.TOC_RELEVANCE).addDefinition(SECTION_NUMBER_STYLE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.INDENTATION).addDefinition(CommonStyleAttributes.CHART_TITLE_FONT).addDefinition(CHAPTER_FONT_NAME_STYLE).addDefinition(CommonStyleAttributes.SPACING_BEFORE).addDefinition(CommonStyleAttributes.SPACING_AFTER).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.TOC_RELEVANCE).addDefinition(SECTION_NUMBER_STYLE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.numberStyle = 0;
        if (this.isAttributeDefined(SECTION_NUMBER_STYLE, SECTION_NUMBER_STYLE_STYLE)) {
            this.numberStyle = this.getIntegerAttribute(SECTION_NUMBER_STYLE, 0, true, SECTION_NUMBER_STYLE_STYLE);
        }
    }

    protected void createSection() throws DocumentHandlerException {
        String titleStr = this.getTextAttribute(CommonAttributes.CHAPTER_TITLE, true, null);
        DocumentFont titleDocFont = this.getTitleFont();
        Font titleFont = null;
        titleFont = titleDocFont != null ? titleDocFont.getFont() : new Font();
        this.title = new Paragraph(titleStr, titleFont);
        this.extendLeading((Phrase)this.title, titleFont, this.getLeading(), this.getLineSpacing());
        this.title.setSpacingBefore(this.getSpacingBefore());
        this.title.setSpacingAfter(this.getSpacingAfter());
        int chapterId = 1;
        if (this.isAttributeDefined(CommonAttributes.CHAPTER_NUMBER)) {
            chapterId = this.getIntegerAttribute(CommonAttributes.CHAPTER_NUMBER, 1, true, null);
        } else {
            TemplateContext ctx = this.documentHandler.getTemplateContext();
            Integer chapId = (Integer)ctx.getProperty(PROP_CAPTER_ID);
            chapId = chapId == null ? new Integer(1) : new Integer(chapId + 1);
            ctx.setProperty(PROP_CAPTER_ID, chapId);
            chapterId = chapId;
        }
        this.section = new Chapter(this.title, chapterId);
        this.section.setNumberStyle(this.numberStyle);
        this.getDocumentHandler().addTocItem(new TocItem(1, Integer.toString(chapterId), titleStr, this.tocRelevance));
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)this.section);
    }

    public Document handleNewPage(Rectangle size, Rectangle margins) throws DocumentHandlerException {
        this.section.add((Object)Chunk.NEXTPAGE);
        return this.documentHandler.getDocument();
    }
}

