/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.text.Format;
import java.util.Date;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.PhraseHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.text.FormatHelper;

public class DateFormatTag
extends BaseDocumentTag {
    private static final AttributeDefinition FORMAT = new AttributeDefinition("format", 4, true, "The format string according to the definition of class java.text.DecimalFormat.");
    private static final AttributeDefinition VALUE = new AttributeDefinition("value", 4, false, "The value to be formatted");
    public static final String TAG_NAME = "date-format";
    private PhraseHolder phraseHolder = null;
    private String formatAttr = null;
    private Format format = null;
    private String valueAttr = null;

    public DateFormatTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Formats the given value using the specified number format. The given number format must be specified according to the specifications of the SDK class java.text.DecimalFormat.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(FORMAT).addDefinition(VALUE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.phraseHolder = this.documentHandler.latestPhraseHolder();
        if (this.phraseHolder == null) {
            throw new DocumentHandlerException(this.locator(), "Item '" + this.getName() + "' is not supported here.");
        }
        this.valueAttr = this.getStringAttribute(VALUE, false, null);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.formatAttr = this.getStringAttribute(FORMAT, true, null);
        this.format = this.documentHandler.lookupFormat(this.formatAttr);
        FormatHelper formatHelper = this.documentHandler.getFormatHelper();
        if (this.format == null) {
            this.format = formatHelper.createDateFormat(this.formatAttr);
            this.documentHandler.registerFormat(this.formatAttr, this.format);
        }
        Object value = null;
        try {
            value = this.documentHandler.evalObject(this.valueAttr);
        }
        catch (ExpressionException ex) {
            throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
        }
        if (!(value instanceof Date)) {
            throw new DocumentHandlerException(this.locator(), "Unable to format non-date values at date-format item.");
        }
        this.phraseHolder.addChunk(this, this.format.format(value), this.getFont());
    }
}

