/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPageEventHandler;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.HeaderFooterPartTag;
import org.ujac.print.tag.NewPageTag;

public abstract class HeaderFooterTag
extends BaseElementTag
implements FontHolder,
StyleHolder {
    public static final float DEFAULT_RULE_PADDING = 2.0f;
    public static final AttributeDefinition RULE_WIDTH = new AttributeDefinition("rule-width", 14, false, "The width of the horizontal ruler line");
    public static final AttributeDefinition RULE_COLOR = new AttributeDefinition("rule-color", 5, false, "The color of the horizontal ruler line");
    private float ruleWidth = 0.0f;
    private Color ruleColor = null;
    protected NewPageTag newPageTag = null;
    protected List headerFooterParts = new ArrayList();

    public HeaderFooterTag(String name) {
        super(name);
    }

    public boolean isStyleable() {
        return true;
    }

    public void addPart(HeaderFooterPartTag part) {
        this.headerFooterParts.add(part);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.newPageTag = (NewPageTag)this.documentHandler.latestOfType("new-page");
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.headerFooterParts.clear();
        if (!this.isValid()) {
            return;
        }
        if (this.isInNewPageTag()) {
            this.newPageTag.queuePageEventHandler(this.getName(), (PdfPageEvent)new PageEventHandler());
        } else {
            this.documentHandler.setPageEventHandler(this.getName(), (PdfPageEvent)new PageEventHandler());
        }
        this.ruleWidth = this.getDimensionAttribute(RULE_WIDTH, 0.0f, true, RULE_WIDTH);
        this.ruleColor = this.getColorAttribute(RULE_COLOR, Color.black, true, RULE_COLOR);
    }

    public DocumentFont getFont() {
        return super.getFont();
    }

    public float getRuleWidth() {
        return this.ruleWidth;
    }

    public Color getRuleColor() {
        return this.ruleColor;
    }

    protected abstract void drawRule(PdfWriter var1, Document var2);

    protected boolean isInNewPageTag() {
        return this.newPageTag != null;
    }

    public float getLineSpacing() {
        ElementContainer elementContainer = this.getElementContainer();
        return elementContainer.getLineSpacing();
    }

    class PageEventHandler
    extends DocumentPageEventHandler {
        PageEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEndPage(PdfWriter writer, Document document) {
            DocumentHandler documentHandler = HeaderFooterTag.this.getDocumentHandler();
            Document oldDocument = documentHandler.getDocument();
            DocWriter oldWriter = documentHandler.setDocumentAndWriter(document, (DocWriter)writer);
            try {
                int numItems = HeaderFooterTag.this.headerFooterParts.size();
                for (int i = 0; i < numItems; ++i) {
                    HeaderFooterPartTag tag = (HeaderFooterPartTag)HeaderFooterTag.this.headerFooterParts.get(i);
                    tag.onEndPage(writer, document);
                }
                HeaderFooterTag.this.drawRule(writer, document);
            }
            finally {
                documentHandler.setDocumentAndWriter(oldDocument, oldWriter);
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            int numItems = HeaderFooterTag.this.headerFooterParts.size();
            for (int i = 0; i < numItems; ++i) {
                HeaderFooterPartTag tag = (HeaderFooterPartTag)HeaderFooterTag.this.headerFooterParts.get(i);
                tag.onCloseDocument(writer, document);
            }
            HeaderFooterTag.this.drawRule(writer, document);
        }
    }
}

