/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.HeaderFooterTag;
import org.ujac.print.tag.HeaderPartTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.SwitchTag;

public class HeaderTag
extends HeaderFooterTag {
    public static final String TAG_NAME = "header";
    private static final AttributeDefinition PADDING_BOTTOM = CommonStyleAttributes.PADDING_BOTTOM.cloneAttrDef("The padding between the horizontal ruler line and the content");
    private static final AttributeDefinition PADDING_BOTTOM_STYLE = CommonStyleAttributes.PADDING_BOTTOM.cloneAttrDef("The padding between the horizontal ruler line and the content");
    private float paddingBottom = 2.0f;

    public HeaderTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the header for the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(RULE_WIDTH).addDefinition(RULE_COLOR).addDefinition(PADDING_BOTTOM);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(RULE_WIDTH).addDefinition(RULE_COLOR).addDefinition(PADDING_BOTTOM_STYLE);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(HeaderPartTag.class, 0, 999));
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.paddingBottom = this.getDimensionAttribute(CommonAttributes.PADDING_BOTTOM, 2.0f, true, CommonStyleAttributes.PADDING_BOTTOM);
    }

    protected void drawRule(PdfWriter writer, Document document) {
        float ruleWidth = this.getRuleWidth();
        if (ruleWidth <= 0.0f) {
            return;
        }
        Rectangle pageSize = document.getPageSize();
        float left = document.left();
        float right = document.right();
        float top = pageSize.getTop() - document.topMargin() + this.paddingBottom;
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        cb.setLineWidth(ruleWidth);
        cb.setColorStroke(this.getRuleColor());
        cb.moveTo(left, top);
        cb.lineTo(right, top);
        cb.closePathStroke();
        cb.restoreState();
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }
}

