/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.template.TemplateException;

public class LogTag
extends BaseDocumentTag {
    private static final AttributeDefinition LEVEL = new AttributeDefinition("level", new String[]{"debug", "info", "warn", "error", "fatal"}, true, "The log level.");
    private static final AttributeDefinition CONDITION = CommonAttributes.CONDITION.cloneAttrDef().setRequired(false);
    public static final String TAG_NAME = "log";
    private String condition = null;

    public LogTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Writing the tag's content to log.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(LEVEL).addDefinition(CONDITION);
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.condition = this.getStringAttribute(CONDITION, false, null);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.condition != null) {
            try {
                if (!this.documentHandler.evalBoolean(this.condition)) {
                    return;
                }
            }
            catch (ExpressionException ex) {
                throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
            }
        }
        String content = null;
        try {
            content = this.documentHandler.executeTemplate(this.getContent());
        }
        catch (TemplateException ex) {
            throw new TagAttributeException(this.locator(), "Body evaluation failed: " + ex.getMessage(), ex);
        }
        String level = this.getStringAttribute(LEVEL, true, null);
        if ("debug".equals(level)) {
            this.log.debug((Object)content);
            return;
        }
        if ("info".equals(level)) {
            this.log.info((Object)content);
            return;
        }
        if ("warn".equals(level)) {
            this.log.warn((Object)content);
            return;
        }
        if ("error".equals(level)) {
            this.log.error((Object)content);
            return;
        }
        if ("fatal".equals(level)) {
            this.log.fatal((Object)content);
            return;
        }
    }
}

