/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentEvent;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentTagInterceptor;
import org.ujac.print.ParameterDefinition;
import org.ujac.print.ParameterHolder;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.MacroDefTag;
import org.ujac.print.tag.ParameterTag;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.template.TemplateException;

public class MacroTag
extends BaseDocumentTag
implements ParameterHolder {
    private static final AttributeDefinition MACRO_NAME = new AttributeDefinition("name", 4, true, "The name of the macro definition to use.");
    public static final String TAG_NAME = "macro";
    private MacroDefTag macroDef = null;
    private String name = null;
    private Map parameters = null;

    public MacroTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Uses a document macro, this macro must have been specified previously by a 'macro-def' item.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(MACRO_NAME);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(ParameterTag.class, 0, 999));
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        Map customAttributes = this.getCustomAttributes();
        if (customAttributes != null) {
            this.name = (String)customAttributes.get("name");
            if (this.name == null) {
                this.name = (String)customAttributes.get("tagName");
                if (this.name != null) {
                    customAttributes.put("name", this.name);
                }
            }
        }
        this.name = this.getStringAttribute(MACRO_NAME, false, null);
        this.macroDef = this.documentHandler.lookupMacroDefinition(this.name);
        if (this.macroDef == null) {
            throw new DocumentHandlerException(this.locator(), "No definition found for macro '" + this.name + "'.");
        }
        Iterator iterParamDefs = this.macroDef.getParameterDefs().entrySet().iterator();
        while (iterParamDefs.hasNext()) {
            Map.Entry pdEntry = iterParamDefs.next();
            ParameterDefinition pd = (ParameterDefinition)pdEntry.getValue();
            this.addAttributeDefinition(new AttributeDefinition(pd.getName(), pd.getType(), !pd.isOptional(), pd.getDescription()));
        }
        super.checkAttributes();
    }

    protected void checkAttributes() throws TagAttributeException {
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.parameters = new HashMap();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        List documentEvents = this.macroDef.getDocumentEvents();
        int numEvents = documentEvents.size();
        TemplateContext oldTemplateContext = null;
        Map parameters = this.parameters;
        Map parameterDefs = this.macroDef.getParameterDefs();
        Set paramDefSet = parameterDefs.entrySet();
        Iterator iterParamDefs = paramDefSet.iterator();
        while (iterParamDefs.hasNext()) {
            Map.Entry pdEntry = iterParamDefs.next();
            ParameterDefinition pd = (ParameterDefinition)pdEntry.getValue();
            String pdName = pd.getName();
            if (this.isAttributeDefined(pdName)) {
                String attr;
                String value = attr = this.getRawAttribute(pdName);
                if ("${body}".equals(attr)) {
                    try {
                        value = this.documentHandler.executeTemplate(attr);
                    }
                    catch (TemplateException ex) {
                        throw new TagAttributeException(this.locator(), "Attribute evaluation failed: " + ex.getMessage(), ex);
                    }
                }
                parameters.put(pdName, value);
            }
            if (parameters.containsKey(pdName)) continue;
            if (!pd.isOptional()) {
                throw new TagAttributeException(this.locator(), "Required attribute '" + pd.getName() + "' was not defined for macro '" + this.name + "'.");
            }
            parameters.put(pdName, pd.getDefaultValue());
        }
        if (parameters.size() > 0) {
            oldTemplateContext = this.documentHandler.getTemplateContext();
            TemplateContext localTemplateContext = new TemplateContext(oldTemplateContext);
            localTemplateContext.putAll(parameters);
            this.documentHandler.setTemplateContext(localTemplateContext);
        }
        DocumentTagInterceptor tagInterceptor = this.documentHandler.getTagInterceptor();
        block8: for (int i = 0; i < numEvents; ++i) {
            DocumentEvent event = (DocumentEvent)documentEvents.get(i);
            BaseDocumentTag item = event.getItem();
            switch (event.getType()) {
                case 1: {
                    BaseDocumentTag topItem = item.getParentItem();
                    if (topItem == this) {
                        topItem = topItem.getParentItem();
                    }
                    if (topItem != null) {
                        topItem.flushContent();
                    }
                    item.preInitialize();
                    item.initialize();
                    if (tagInterceptor == null || tagInterceptor.beforeOpen(item)) {
                        item.openItem();
                        if (tagInterceptor != null) {
                            tagInterceptor.afterOpen(item);
                        }
                    }
                    this.documentHandler.pushItem(item);
                    continue block8;
                }
                case 2: {
                    String content = event.getContent();
                    if (content.length() <= 0) continue block8;
                    item.setItemOpened(false);
                    item.addContent(content);
                    if (i != numEvents - 1) continue block8;
                    item.flushContent();
                    continue block8;
                }
                case 3: {
                    item.setItemClosed(true);
                    item.flushContent();
                    if (tagInterceptor == null || tagInterceptor.beforeClose(item)) {
                        item.closeItem();
                        if (tagInterceptor != null) {
                            tagInterceptor.afterClose(item);
                        }
                    }
                    this.documentHandler.popItem();
                    continue block8;
                }
                default: {
                    throw new DocumentHandlerException(this.locator(), "Encountered illegal event type '" + event.getType() + "!");
                }
            }
        }
        if (oldTemplateContext != null) {
            this.documentHandler.setTemplateContext(oldTemplateContext);
        }
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public ParameterDefinition getParameterDefinition(String name) {
        return (ParameterDefinition)this.macroDef.getParameterDefs().get(name);
    }
}

