/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PhraseHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.AnnotationTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.ChartTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DateFormatTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NumberFormatTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.SpaceTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.util.StringUtils;

public class ParagraphTag
extends BaseElementTag
implements ElementContainer,
PhraseHolder,
FontHolder,
StyleHolder {
    public static final String TAG_NAME = "paragraph";
    private float spacingBefore = 0.0f;
    private float spacingAfter = 0.0f;
    private float leading = 0.0f;
    private float lineSpacing = 1.2f;
    private int align = 0;
    private boolean keepTogether = false;
    private Paragraph paragraph = null;

    public ParagraphTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a paragraph to its parent item.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.SPACING_BEFORE).addDefinition(CommonAttributes.SPACING_AFTER).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.KEEP_TOGETHER).addDefinition(CommonAttributes.BACKGROUND_COLOR);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.SPACING_BEFORE).addDefinition(CommonStyleAttributes.SPACING_AFTER).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.KEEP_TOGETHER).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(NumberFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(DateFormatTag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(AnnotationTag.class, 0, 999)).addDefinition(new ChildDefinition(ChartTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(SpaceTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(OutlineTag.class, 0, 999)).addDefinition(new ChildDefinition(ListTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.paragraph = null;
        if (!this.isValid()) {
            return;
        }
        this.spacingBefore = this.getDimensionAttribute(CommonAttributes.SPACING_BEFORE, 0.0f, true, CommonStyleAttributes.SPACING_BEFORE);
        this.spacingAfter = this.getDimensionAttribute(CommonAttributes.SPACING_AFTER, 0.0f, true, CommonStyleAttributes.SPACING_AFTER);
        CommonAttributesHolder commonAttributesHolder = this.getCommonAttributesHolder();
        this.leading = this.isAttributeDefined(CommonAttributes.LEADING, CommonStyleAttributes.LEADING) ? this.getDimensionAttribute(CommonAttributes.LEADING, true, CommonStyleAttributes.LEADING) : commonAttributesHolder.getLeading();
        this.lineSpacing = this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING) ? this.getDimensionAttribute(CommonAttributes.LINE_SPACING, true, CommonStyleAttributes.LINE_SPACING) : commonAttributesHolder.getLineSpacing();
        this.align = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.keepTogether = this.getBooleanAttribute(CommonAttributes.KEEP_TOGETHER, false, true, CommonStyleAttributes.KEEP_TOGETHER);
    }

    public String getActualContent() {
        if (this.paragraph == null) {
            return super.getActualContent();
        }
        return this.getPhraseContent((Phrase)this.paragraph);
    }

    public void flushContent() throws DocumentHandlerException {
        Paragraph para;
        if (!this.isValid()) {
            return;
        }
        if (this.paragraph == null) {
            this.createParagraph();
        }
        if (this.isIgnoreFlush()) {
            return;
        }
        if (this.isTrimNextHead()) {
            this.trimContentHead();
            this.setTrimNextHead(false);
        }
        if (this.isItemClosed() && this.isTrimBody()) {
            this.trimContentTail();
        }
        if ((para = (Paragraph)this.addChunk((Phrase)this.paragraph, this.getLeading(), this.getLineSpacing())) != null) {
            this.paragraph = para;
        }
        this.resetContent();
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        this.flushContent();
        ElementContainer elementContainer = this.getElementContainer();
        this.paragraph.setSpacingBefore(this.spacingBefore);
        this.paragraph.setSpacingAfter(this.spacingAfter);
        this.paragraph.setKeepTogether(this.keepTogether);
        elementContainer.addElement(this, (Element)this.paragraph);
    }

    public void addChunk(BaseDocumentTag item, String chunk, DocumentFont font) throws DocumentHandlerException {
        if (this.paragraph == null) {
            this.createParagraph();
            if (this.isTrimBody()) {
                chunk = StringUtils.trimHead(chunk);
            }
        }
        this.addChunk(item, (Phrase)this.paragraph, chunk, font, this.getLeading(), this.getLineSpacing());
    }

    public void addChunk(BaseDocumentTag item, Chunk chunk) {
        if (this.paragraph == null) {
            this.createParagraph();
        }
        this.addChunk((Phrase)this.paragraph, chunk, this.getLeading(), this.getLineSpacing());
    }

    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public float getLeading() {
        return this.leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (this.paragraph == null) {
            this.createParagraph();
        }
        this.paragraph.add((Object)element);
        if (element instanceof Phrase) {
            this.extendLeading((Phrase)this.paragraph, (Phrase)element);
        }
    }

    public boolean isTopLevel() {
        return false;
    }

    private void createParagraph() {
        this.paragraph = new Paragraph(0.0f);
        this.paragraph.setAlignment(this.align);
        this.paragraph.setLeading(this.leading, this.lineSpacing);
    }
}

