/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import org.ujac.print.DocumentHandler;
import org.ujac.print.tag.ImageBuilder;

public class PdfImageBuilder
implements ImageBuilder {
    public boolean checkFormat(byte[] imageData) {
        if (imageData.length < 5) {
            return false;
        }
        return imageData[0] == 37 && imageData[1] == 80 && imageData[2] == 68 && imageData[3] == 70 && imageData[4] == 45;
    }

    public Image buildImage(DocumentHandler documentHandler, byte[] imageData, String path, float width, float height, int page) throws IOException {
        try {
            PdfWriter pdfWriter = (PdfWriter)documentHandler.getDocumentWriter();
            PdfReader reader = new PdfReader(imageData);
            if (page < 0 || page > reader.getNumberOfPages()) {
                throw new IOException("Page number for imported Pdf-Image is out of range: " + page);
            }
            PdfImportedPage importedPage = pdfWriter.getImportedPage(reader, page);
            Rectangle bbox = importedPage.getBoundingBox();
            float left = bbox.getLeft();
            float bottom = bbox.getBottom();
            if (left != 0.0f || bottom != 0.0f) {
                importedPage.setMatrix(1.0f, 0.0f, 0.0f, 1.0f, -left, -bottom);
            }
            return Image.getInstance((PdfTemplate)importedPage);
        }
        catch (BadElementException ex) {
            throw new IOException("Unable to create PDF image: " + ex.getMessage());
        }
    }
}

