/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.Condition;
import org.ujac.print.DocumentHandler;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.FontHolder;
import org.ujac.print.PdfCellContainer;
import org.ujac.print.PdfHelper;
import org.ujac.print.PdfTableHolder;
import org.ujac.print.StyleHolder;
import org.ujac.print.tag.AlterColumnTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.BaseLoopTag;
import org.ujac.print.tag.CellAttributes;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DefineColumnTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.InsertColumnTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.PrintRowTag;
import org.ujac.print.tag.RemoveColumnTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.DefaultColumn;
import org.ujac.util.table.GroupRow;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.template.TemplateContext;
import org.ujac.util.text.FormatHelper;
import org.xml.sax.Locator;

public class PrintTableTag
extends BaseLoopTag
implements PdfCellContainer,
PdfTableHolder,
FontHolder,
Condition,
StyleHolder {
    private static final AttributeDefinition PRINT_HEADER = new AttributeDefinition("print-header", 3, false, "Tells whether to print the header row or not.");
    private static final AttributeDefinition LEVEL_FILTER = new AttributeDefinition("level-filter", 1, false, "The maximum level of importance to support, any column with a higher level than the specified one is hidden.");
    public static final int DIRECTION_BEFORE = 1;
    public static final int DIRECTION_AFTER = 2;
    public static final String TAG_NAME = "print-table";
    public static final int MAX_SEGMENT_SIZE = 100;
    private CellAttributes cellAttributes = null;
    private BaseDocumentTag latestChild = null;
    private List headerItems = new ArrayList();
    private Table table = null;
    private PdfPTable pTable = null;
    private int numCells = 0;
    private int numRows = 0;
    private float width = 0.0f;
    private int hAlign = 0;
    private boolean splitRows = false;
    private boolean splitLate = true;
    private float spacingBefore = 0.0f;
    private float spacingAfter = 0.0f;
    private int levelFilter = -1;
    private List columnList = new ArrayList();
    private List defaultCellContents = new ArrayList();
    private Map columnIndex = null;
    private Column[] columns = null;
    private float[] widths = null;
    protected boolean outputStarted = false;
    private boolean printHeader = true;
    private boolean blockOpen = false;
    private boolean columnDefinitionsCleared = false;

    public PrintTableTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Executes the nested items for each row of the specified table. Creates a table according to the column layout hints of the table.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.FONT).addDefinition(CommonAttributes.LOOP_VARIABLE).addDefinition(CommonAttributes.SEQUENCE).addDefinition(CommonAttributes.TABLE_WIDTH).addDefinition(CommonAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.CELL_HORIZONTAL_ALIGNMENT).addDefinition(CommonAttributes.CELL_VERTICAL_ALIGNMENT).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(CommonAttributes.BORDER_STYLE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR).addDefinition(CommonAttributes.PADDING).addDefinition(CommonAttributes.PADDING_LEFT).addDefinition(CommonAttributes.PADDING_RIGHT).addDefinition(CommonAttributes.PADDING_TOP).addDefinition(CommonAttributes.PADDING_BOTTOM).addDefinition(CommonAttributes.NO_WRAP).addDefinition(PRINT_HEADER).addDefinition(CommonAttributes.SPACING_BEFORE).addDefinition(CommonAttributes.SPACING_AFTER).addDefinition(CommonAttributes.TABLE_SPLIT_ROWS).addDefinition(CommonAttributes.TABLE_SPLIT_LATE).addDefinition(LEVEL_FILTER);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(CommonStyleAttributes.TABLE_WIDTH).addDefinition(CommonStyleAttributes.HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonStyleAttributes.CELL_HORIZONTAL_ALIGNMENT).addDefinition(CommonStyleAttributes.CELL_VERTICAL_ALIGNMENT).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(CommonStyleAttributes.BORDER_STYLE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR).addDefinition(CommonStyleAttributes.PADDING).addDefinition(CommonStyleAttributes.PADDING_LEFT).addDefinition(CommonStyleAttributes.PADDING_RIGHT).addDefinition(CommonStyleAttributes.PADDING_TOP).addDefinition(CommonStyleAttributes.PADDING_BOTTOM).addDefinition(CommonStyleAttributes.NO_WRAP).addDefinition(PRINT_HEADER).addDefinition(CommonStyleAttributes.SPACING_BEFORE).addDefinition(CommonStyleAttributes.SPACING_AFTER).addDefinition(CommonStyleAttributes.TABLE_SPLIT_ROWS).addDefinition(CommonStyleAttributes.TABLE_SPLIT_LATE).addDefinition(LEVEL_FILTER);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(InsertColumnTag.class, 0, 999)).addDefinition(new ChildDefinition(AlterColumnTag.class, 0, 999)).addDefinition(new ChildDefinition(RemoveColumnTag.class, 0, 999)).addDefinition(new ChildDefinition(DefineColumnTag.class, 0, 999)).addDefinition(new ChildDefinition(PrintRowTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public boolean isTextBodyAllowed() {
        return false;
    }

    public Column[] getVisibleColumns() {
        if (this.columns == null) {
            FormatHelper formatHelper = this.documentHandler.getFormatHelper();
            int numColumns = this.columnList.size();
            this.columns = new Column[numColumns];
            this.widths = new float[numColumns];
            block7: for (int i = 0; i < numColumns; ++i) {
                Column column;
                this.columns[i] = column = (Column)this.columnList.get(i);
                this.widths[i] = column.getLayoutHints().getWidth();
                if (column.getFormat() != null) continue;
                switch (column.getType()) {
                    case 2: 
                    case 4: {
                        column.setFormat(formatHelper.getIntegerFormat());
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        column.setFormat(formatHelper.getDoubleFormat());
                        continue block7;
                    }
                    case 8: {
                        column.setFormat(formatHelper.getDateFormat());
                        continue block7;
                    }
                    case 9: {
                        column.setFormat(formatHelper.getTimeFormat());
                        continue block7;
                    }
                    case 10: {
                        column.setFormat(formatHelper.getTimestampFormat());
                    }
                }
            }
        }
        return this.columns;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        this.columnIndex = null;
        this.outputStarted = false;
        if (!this.isValid()) {
            return;
        }
        this.cellAttributes = new CellAttributes(this.getCommonAttributesHolder());
        this.cellAttributes.parseTableAttributes(this, null);
        try {
            this.table = (Table)this.getSequenceHolder();
        }
        catch (ClassCastException ex) {
            throw new DocumentHandlerException(this.locator(), "Only tables are allowed as sequences at print-table tag!");
        }
        if (this.table == null) {
            throw new DocumentHandlerException(this.locator(), "The attribute 'sequence' doesn't resolve to a table, check your document properties!");
        }
        this.table.setFormatHelper(this.documentHandler.getFormatHelper());
        this.columnList.clear();
        this.columns = null;
        this.printHeader = this.getBooleanAttribute(PRINT_HEADER, true, true, null);
        this.levelFilter = this.getIntegerAttribute(LEVEL_FILTER, -1, true, null);
        this.width = this.getFloatAttribute(CommonAttributes.TABLE_WIDTH, 100.0f, true, CommonStyleAttributes.TABLE_WIDTH);
        Column[] columns = this.table.getVisibleColumns(this.levelFilter);
        for (int i = 0; i < columns.length; ++i) {
            this.columnList.add(columns[i]);
            this.defaultCellContents.add(null);
        }
        this.hAlign = this.getHorizontalAlignmentAttribute(CommonAttributes.HORIZONTAL_ALIGNMENT, true, CommonStyleAttributes.HORIZONTAL_ALIGNMENT);
        this.splitRows = this.getBooleanAttribute(CommonAttributes.TABLE_SPLIT_ROWS, false, CommonStyleAttributes.TABLE_SPLIT_ROWS);
        this.splitLate = this.getBooleanAttribute(CommonAttributes.TABLE_SPLIT_LATE, false, CommonStyleAttributes.TABLE_SPLIT_LATE);
        this.spacingBefore = this.getDimensionAttribute(CommonAttributes.SPACING_BEFORE, 0.0f, true, CommonStyleAttributes.SPACING_BEFORE);
        this.spacingAfter = this.getDimensionAttribute(CommonAttributes.SPACING_AFTER, 0.0f, true, CommonStyleAttributes.SPACING_AFTER);
    }

    public void openItem(boolean resetData) throws DocumentHandlerException {
        if (resetData) {
            this.numCells = 0;
            this.headerItems.clear();
            this.outputStarted = true;
        }
        if (!this.isValid()) {
            return;
        }
        this.pTable = new PdfPTable(this.columns.length);
        if (this.width > 0.0f) {
            this.pTable.setWidthPercentage(this.width);
        }
        try {
            this.pTable.setWidths(this.widths);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Invalid table widths:'" + this.widths.toString() + "': " + ex.getMessage(), ex);
        }
        this.pTable.setHorizontalAlignment(this.hAlign);
        this.pTable.setSplitRows(this.splitRows);
        this.pTable.setSplitLate(this.splitLate);
        if (resetData) {
            this.pTable.setSpacingBefore(this.spacingBefore);
        }
    }

    public void closeItem() throws DocumentHandlerException {
        super.closeItem();
        if (!this.isValid()) {
            return;
        }
        if (this.pTable == null) {
            return;
        }
        this.flushTableSegment(true);
    }

    private void flushTableSegment(boolean lastSegment) throws DocumentHandlerException {
        if (this.numCells % this.columns.length > 0) {
            Locator locator = this.locator();
            if (this.latestChild != null) {
                locator = this.latestChild.locator();
            }
            throw new DocumentHandlerException(locator, "The last row is not filled completely, check the table cells!");
        }
        if (lastSegment) {
            this.pTable.setSpacingAfter(this.spacingAfter);
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)this.pTable);
        this.numCells = 0;
        this.numRows = 0;
    }

    protected boolean preRepeatChildItems() throws DocumentHandlerException {
        Row row = (Row)this.getCurrentValue();
        if (row != null) {
            boolean reallyBreaked = false;
            if (row.isStartsBlock()) {
                this.blockOpen = true;
            }
            if (row.isStartsBlock() && this.getNumContentRows() > 0) {
                reallyBreaked = this.splitTable(row.isStartNewPage(), true);
            } else if (row.isStartNewPage()) {
                reallyBreaked = this.splitTable(true, true);
            }
            if (row.isStartNewPage() && !reallyBreaked) {
                try {
                    this.documentHandler.getDocument(true).newPage();
                }
                catch (Exception ex) {
                    throw new DocumentHandlerException(this.locator(), "Unable to open a new page: " + ex.getMessage(), ex);
                }
            }
        }
        return true;
    }

    protected void postRepeatChildItems() throws DocumentHandlerException {
        Row row = (Row)this.getCurrentValue();
        if (row.isEndsBlock()) {
            if (!this.fitsPage()) {
                try {
                    this.documentHandler.getDocument().newPage();
                }
                catch (Exception ex) {
                    throw new DocumentHandlerException(this.locator(), "Unable to start a new page: " + ex.getMessage(), ex);
                }
            }
            this.splitTable(false, true);
            this.blockOpen = false;
        }
    }

    protected void preLoopChildItems() throws DocumentHandlerException {
        if (!this.printHeader) {
            return;
        }
        String loopVariable = this.getLoopVariable();
        String loopIdxVariable = this.getLoopIdxVariable();
        Row headerRow = this.table.getHeaderRow();
        int numColumns = this.table.getColumnCount();
        try {
            for (int i = 0; i < numColumns; ++i) {
                LayoutHints layoutHints = this.table.getColumn(i).getLayoutHints();
                if (layoutHints == null) continue;
                headerRow.setString(i, layoutHints.getHeader());
            }
            TemplateContext ctx = this.getDocumentHandler().getTemplateContext();
            ctx.setProperty(loopVariable, headerRow);
            this.setCurrentValue(headerRow);
            ctx.setProperty(loopIdxVariable, new Integer(-1));
        }
        catch (TableException ex) {
            throw new DocumentHandlerException(this.locator(), "Table access failure: " + ex.getMessage(), ex);
        }
        this.repeatChildItems();
    }

    protected void postLoopChildItems() throws DocumentHandlerException {
        Row currentRow = (Row)this.getCurrentValue();
        if (currentRow != null && "footer".equals(currentRow.getType())) {
            return;
        }
        String loopVariable = this.getLoopVariable();
        String loopIdxVariable = this.getLoopIdxVariable();
        GroupRow footerRow = new GroupRow(this.table, "footer", null);
        int numColumns = this.table.getColumnCount();
        try {
            int i;
            if ("header".equals(currentRow.getType())) {
                for (i = 0; i < numColumns; ++i) {
                    footerRow.setObject(i, null);
                    footerRow.setVisible(i, false);
                }
            } else {
                for (i = 0; i < numColumns; ++i) {
                    footerRow.setObject(i, currentRow.getObject(i));
                    footerRow.setVisible(i, false);
                }
            }
            TemplateContext ctx = this.getDocumentHandler().getTemplateContext();
            ctx.setProperty(loopVariable, footerRow);
            this.setCurrentValue(footerRow);
            ctx.setProperty(loopIdxVariable, new Integer(-1));
        }
        catch (TableException ex) {
            throw new DocumentHandlerException(this.locator(), "Table access failure: " + ex.getMessage(), ex);
        }
        this.repeatChildItems();
    }

    protected String getDefaultContent(int idx) {
        return (String)this.defaultCellContents.get(idx);
    }

    public boolean isOutputStarted() {
        return this.outputStarted;
    }

    public void addCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
        if (!this.isOutputStarted()) {
            this.openItem(true);
        }
        this.latestChild = item;
        this.numCells += Math.max(cell.getColspan(), 1);
        this.pTable.addCell(cell);
        if (this.numCells % this.getVisibleColumns().length == 0) {
            ++this.numRows;
            if (!this.blockOpen && this.numRows >= 100) {
                this.splitTable(false, true);
            }
        }
    }

    public int getRemainingPdfColumns() {
        Column[] columns = this.getVisibleColumns();
        int numColumns = columns.length;
        return numColumns - this.numCells % numColumns;
    }

    public PdfTableHolder getPdfTable() {
        return this;
    }

    public void addHeaderCell(BaseDocumentTag item, PdfPCell cell) throws DocumentHandlerException {
        this.addCell(item, cell);
        this.headerItems.add(cell);
    }

    public boolean fitsPage() throws DocumentHandlerException {
        DocumentHandler documentHandler = this.getDocumentHandler();
        PdfWriter writer = (PdfWriter)documentHandler.getDocumentWriter();
        try {
            return PdfHelper.fitsPage(writer, documentHandler.getDocument(), this.getTable());
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Fits page check failed: " + ex.getMessage(), ex);
        }
    }

    public boolean splitTable(boolean newPage, boolean keepHeader) throws DocumentHandlerException {
        if (!this.isValid()) {
            return false;
        }
        if (this.numCells == 0) {
            return false;
        }
        int numHeaderRows = this.pTable.getHeaderRows();
        this.flushTableSegment(false);
        if (newPage) {
            try {
                this.documentHandler.getDocument(true).newPage();
            }
            catch (Exception ex) {
                throw new DocumentHandlerException(this.locator(), "Unable to open a new page: " + ex.getMessage(), ex);
            }
        }
        this.openItem(false);
        if (keepHeader) {
            if (!newPage) {
                this.pTable.setSkipFirstHeader(true);
            }
            int numHeaderItems = this.headerItems.size();
            for (int i = 0; i < numHeaderItems; ++i) {
                PdfPCell headerItem = (PdfPCell)this.headerItems.get(i);
                this.pTable.addCell(headerItem);
            }
            this.pTable.setHeaderRows(numHeaderRows);
        } else {
            this.headerItems.clear();
        }
        return true;
    }

    public void defineColumn(String name, float width, int hAlign, String title, String defaultContents) throws DocumentHandlerException {
        if (this.columns != null) {
            return;
        }
        if (!this.columnDefinitionsCleared) {
            this.columnList.clear();
            this.defaultCellContents.clear();
            this.columnDefinitionsCleared = true;
        }
        int numColumns = this.columnList.size();
        Column col = null;
        try {
            col = this.table.getColumn(name);
        }
        catch (ColumnNotDefinedException ex) {
            // empty catch block
        }
        if (col != null) {
            LayoutHints lh = col.getLayoutHints();
            if (lh != null) {
                lh.setWidth(width);
                lh.setHeader(title);
                lh.setHeaderAlign(hAlign);
                lh.setVisible(true);
            } else {
                col.setLayoutHints(new LayoutHints(width, title, hAlign));
            }
            for (int i = 0; i < numColumns; ++i) {
                Column tmpCol = (Column)this.columnList.get(i);
                if (!tmpCol.getName().equals(name)) continue;
                this.defaultCellContents.set(i, defaultContents);
                return;
            }
            this.columnList.add(col);
            this.defaultCellContents.add(defaultContents);
            return;
        }
        DummyColumn newCol = new DummyColumn(name);
        newCol.setLayoutHints(new LayoutHints(width, title, hAlign));
        this.columnList.add(newCol);
        this.defaultCellContents.add(defaultContents);
    }

    public void insertColumn(String name, float width, int hAlign, String title, String reference, int direction, String defaultContents) throws DocumentHandlerException {
        if (this.columns != null) {
            return;
        }
        int numColumns = this.columnList.size();
        int coldx = -1;
        int referenceIdx = -1;
        for (int i = 0; i < numColumns; ++i) {
            Column col = (Column)this.columnList.get(i);
            if (col.getName().equals(name)) {
                coldx = i;
                if (referenceIdx != -1) break;
            }
            if (!col.getName().equals(reference)) continue;
            referenceIdx = i;
            if (coldx != -1) break;
        }
        if (coldx != -1) {
            return;
        }
        if (referenceIdx == -1) {
            throw new DocumentHandlerException(this.locator(), "The column name '" + reference + "' does not exist.");
        }
        if (direction == 2) {
            ++referenceIdx;
        }
        DummyColumn newCol = new DummyColumn(name);
        newCol.setLayoutHints(new LayoutHints(width, title, hAlign));
        if (referenceIdx >= numColumns) {
            this.columnList.add(newCol);
            this.defaultCellContents.add(defaultContents);
        } else {
            this.columnList.add(referenceIdx, newCol);
            this.defaultCellContents.add(referenceIdx, defaultContents);
        }
    }

    public void alterColumn(String name, float width, int hAlign, String title, String defaultContents) throws DocumentHandlerException {
        if (this.columns != null) {
            return;
        }
        int numColumns = this.columnList.size();
        int coldx = -1;
        for (int i = 0; i < numColumns; ++i) {
            Column col = (Column)this.columnList.get(i);
            this.defaultCellContents.set(i, defaultContents);
            if (!col.getName().equals(name)) continue;
            coldx = i;
            LayoutHints layoutHints = col.getLayoutHints();
            if (layoutHints == null) {
                layoutHints = new LayoutHints();
                col.setLayoutHints(layoutHints);
            }
            if ((double)width >= 0.0) {
                layoutHints.setWidth(width);
            }
            if (hAlign >= 0) {
                layoutHints.setAlign(hAlign);
            }
            if (title == null) break;
            layoutHints.setHeader(title);
            break;
        }
        if (coldx < 0) {
            throw new DocumentHandlerException(this.locator(), "The column name '" + name + "' is undefined.");
        }
    }

    public void removeColumn(String name) throws DocumentHandlerException {
        if (this.columns != null) {
            return;
        }
        int numColumns = this.columnList.size();
        for (int i = 0; i < numColumns; ++i) {
            Column col = (Column)this.columnList.get(i);
            if (!col.getName().equals(name)) continue;
            this.columnList.remove(i);
            return;
        }
        throw new DocumentHandlerException(this.locator(), "The column name '" + name + "', which was requested to remove, does not exist.");
    }

    protected PdfPTable getTable() {
        return this.pTable;
    }

    protected int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.columnList.size();
    }

    public int getNumContentRows() {
        if (this.pTable == null) {
            return 0;
        }
        return this.pTable.size() - this.pTable.getHeaderRows();
    }

    protected int getColumnIndex(String columnName) {
        Integer idx;
        Column[] columns = this.getVisibleColumns();
        int numColumns = columns.length;
        if (this.columnIndex == null) {
            this.columnIndex = new HashMap();
            for (int i = 0; i < numColumns; ++i) {
                Column col = columns[i];
                this.columnIndex.put(col.getName(), new Integer(i));
            }
        }
        if ((idx = (Integer)this.columnIndex.get(columnName)) == null) {
            return -1;
        }
        return idx;
    }

    public CellAttributes getCellAttributes() {
        return this.cellAttributes;
    }

    public float getLineSpacing() {
        if (this.cellAttributes != null) {
            return this.cellAttributes.getLineSpacing();
        }
        return 1.2f;
    }

    public float getLeading() {
        if (this.cellAttributes != null) {
            return this.cellAttributes.getLeading();
        }
        return 0.0f;
    }

    public class DummyColumn
    extends DefaultColumn {
        private static final long serialVersionUID = 3618696418123134000L;

        protected DummyColumn(String name) {
            super(null, name, -1);
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            this.writeData(s);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            this.readData(s);
        }
    }
}

