/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import java.io.IOException;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;

public class RegisterFontTag
extends BaseDocumentTag {
    private static final AttributeDefinition SOURCE = new AttributeDefinition("source", 4, true, "The location of the TTF file at the resource loader.");
    private static final AttributeDefinition EMBEDDED = new AttributeDefinition("embedded", 3, false, "The font file needs to be embedded or not.");
    private static final AttributeDefinition CACHED = new AttributeDefinition("cached", 3, false, "The font file needs to be cached or not.");
    public static final String TAG_NAME = "register-font";
    private String family = null;
    private Object source = null;
    private int style = 0;
    private boolean embedded = true;
    private boolean cached = true;

    public RegisterFontTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Registers the specified TTF font.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.FONT_FAMILY).addDefinition(SOURCE).addDefinition(EMBEDDED).addDefinition(CACHED).addDefinition(CommonAttributes.FONT_STYLE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.family = this.getStringAttribute(CommonAttributes.FONT_FAMILY, true, null);
        this.source = this.evalAttribute(SOURCE);
        String styleAttr = this.getStringAttribute(CommonAttributes.FONT_STYLE, true, null);
        if (styleAttr != null) {
            this.style = Font.getStyleValue((String)styleAttr);
        }
        this.embedded = this.getBooleanAttribute(EMBEDDED, true, true, null);
        this.cached = this.getBooleanAttribute(CACHED, true, true, null);
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        try {
            byte[] fontData = null;
            fontData = this.source instanceof byte[] ? (byte[])this.source : this.documentHandler.loadResource(this.source.toString());
            this.documentHandler.registerFont(this.family, fontData, this.style, this.embedded, this.cached);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Error while loading font from location '" + this.source + "': " + ex.getMessage(), ex);
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Error while loading font from location '" + this.source + "': " + ex.getMessage(), ex);
        }
    }
}

