/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.util.text.FormatHelper;

public class ResourceBundleTag
extends BaseDocumentTag {
    private static final AttributeDefinition BUNDLE_NAME = CommonAttributes.NAME.cloneAttrDef("The name of the resource bundle.");
    private static final AttributeDefinition BUNDLE_SOURCE = new AttributeDefinition("source", 4, false, "The location of the resource bundle at the resource loader.");
    public static final String TAG_NAME = "resource-bundle";
    private String name = null;
    private String source = null;

    public ResourceBundleTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Loads a localized resource bundle through the resource loader.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(BUNDLE_NAME).addDefinition(BUNDLE_SOURCE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.name = this.getStringAttribute(BUNDLE_NAME, false, null);
        this.source = this.getStringAttribute(BUNDLE_SOURCE, true, null);
        FormatHelper formatHelper = this.documentHandler.getFormatHelper();
        Locale locale = formatHelper.getLocale();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.source, locale);
            this.documentHandler.getTemplateContext().setProperty(this.name, bundle);
        }
        catch (MissingResourceException e) {
            throw new DocumentHandlerException(this.locator(), "Unable to load resource bundle '" + this.source + "': " + e.getMessage(), e);
        }
    }
}

