/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.CommonAttributesHolder;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.NewPageHandler;
import org.ujac.print.StyleHolder;
import org.ujac.print.TocItem;
import org.ujac.print.tag.AddRowTag;
import org.ujac.print.tag.AnchorTag;
import org.ujac.print.tag.AnnotationTag;
import org.ujac.print.tag.AssertTag;
import org.ujac.print.tag.BarcodePdf417Tag;
import org.ujac.print.tag.BarcodeTag;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.BaseFontTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.DatamatrixTag;
import org.ujac.print.tag.DefineTableTag;
import org.ujac.print.tag.ElseTag;
import org.ujac.print.tag.ForeachTag;
import org.ujac.print.tag.IfTag;
import org.ujac.print.tag.ImageTag;
import org.ujac.print.tag.ImportTag;
import org.ujac.print.tag.ListTag;
import org.ujac.print.tag.LogTag;
import org.ujac.print.tag.MacroTag;
import org.ujac.print.tag.NewLineTag;
import org.ujac.print.tag.NewPageTag;
import org.ujac.print.tag.OutlineTag;
import org.ujac.print.tag.ParagraphTag;
import org.ujac.print.tag.PdfTableTag;
import org.ujac.print.tag.PhraseTag;
import org.ujac.print.tag.SetPropertyTag;
import org.ujac.print.tag.SwitchTag;
import org.ujac.print.tag.TableTag;

public class SectionTag
extends BaseElementTag
implements ElementContainer,
StyleHolder,
NewPageHandler {
    public static final String TAG_NAME = "section";
    private static final AttributeDefinition SECTION_FONT = CommonAttributes.FONT.cloneAttrDef("The name of the font definition to use for the section contents.");
    private static final AttributeDefinition SECTION_FONT_NAME_STYLE = CommonStyleAttributes.FONT_NAME.cloneAttrDef("The name of the font definition to use for the section contents.");
    private static final AttributeDefinition SECTION_SPACING_BEFORE = CommonAttributes.SPACING_BEFORE.cloneAttrDef("The vertical spacing before the chapter title.");
    private static final AttributeDefinition SECTION_SPACING_BEFORE_STYLE = CommonStyleAttributes.SPACING_BEFORE.cloneAttrDef("The vertical spacing before the chapter title.");
    private static final AttributeDefinition SECTION_SPACING_AFTER = CommonAttributes.SPACING_AFTER.cloneAttrDef("The vertical spacing after the chapter title.");
    private static final AttributeDefinition SECTION_SPACING_AFTER_STYLE = CommonStyleAttributes.SPACING_AFTER.cloneAttrDef("The vertical spacing after the chapter title.");
    private SectionTag parentSection;
    private DocumentFont titleFont = null;
    protected Section section = null;
    private float spacingBefore = 0.0f;
    private float spacingAfter = 0.0f;
    private float leading = 0.0f;
    private float lineSpacing = 1.2f;
    protected String tocRelevance = null;

    public SectionTag() {
        super(TAG_NAME);
    }

    public SectionTag(String name) {
        super(name);
    }

    public String getDescription() {
        return "Adds a chapter to the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(CommonAttributes.SECTION_NUMBER_DEPTH).addDefinition(CommonAttributes.INDENTATION).addDefinition(CommonAttributes.SECTION_TITLE).addDefinition(CommonAttributes.SECTION_TITLE_FONT).addDefinition(SECTION_FONT).addDefinition(SECTION_SPACING_BEFORE).addDefinition(SECTION_SPACING_AFTER).addDefinition(CommonAttributes.LEADING).addDefinition(CommonAttributes.LINE_SPACING).addDefinition(CommonAttributes.TOC_RELEVANCE);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.INDENTATION).addDefinition(CommonStyleAttributes.SECTION_TITLE_FONT).addDefinition(SECTION_FONT_NAME_STYLE).addDefinition(SECTION_SPACING_BEFORE_STYLE).addDefinition(SECTION_SPACING_AFTER_STYLE).addDefinition(CommonStyleAttributes.LEADING).addDefinition(CommonStyleAttributes.LINE_SPACING).addDefinition(CommonAttributes.TOC_RELEVANCE);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(SectionTag.class, 0, 999)).addDefinition(new ChildDefinition(BaseFontTag.class, 0, 999)).addDefinition(new ChildDefinition(MacroTag.class, 0, 999)).addDefinition(new ChildDefinition(IfTag.class, 0, 999)).addDefinition(new ChildDefinition(ElseTag.class, 0, 999)).addDefinition(new ChildDefinition(LogTag.class, 0, 999)).addDefinition(new ChildDefinition(SwitchTag.class, 0, 999)).addDefinition(new ChildDefinition(ForeachTag.class, 0, 999)).addDefinition(new ChildDefinition(PhraseTag.class, 0, 999)).addDefinition(new ChildDefinition(ParagraphTag.class, 0, 999)).addDefinition(new ChildDefinition(TableTag.class, 0, 999)).addDefinition(new ChildDefinition(PdfTableTag.class, 0, 999)).addDefinition(new ChildDefinition(AnchorTag.class, 0, 999)).addDefinition(new ChildDefinition(AnnotationTag.class, 0, 999)).addDefinition(new ChildDefinition(ImageTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodeTag.class, 0, 999)).addDefinition(new ChildDefinition(DatamatrixTag.class, 0, 999)).addDefinition(new ChildDefinition(BarcodePdf417Tag.class, 0, 999)).addDefinition(new ChildDefinition(ListTag.class, 0, 999)).addDefinition(new ChildDefinition(SetPropertyTag.class, 0, 999)).addDefinition(new ChildDefinition(DefineTableTag.class, 0, 999)).addDefinition(new ChildDefinition(AddRowTag.class, 0, 999)).addDefinition(new ChildDefinition(AssertTag.class, 0, 999)).addDefinition(new ChildDefinition(NewLineTag.class, 0, 999)).addDefinition(new ChildDefinition(NewPageTag.class, 0, 999)).addDefinition(new ChildDefinition(OutlineTag.class, 0, 999)).addDefinition(new ChildDefinition(ImportTag.class, 0, 999));
    }

    public boolean isStyleable() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.parentSection = (SectionTag)this.documentHandler.latestOfType(SectionTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        String titleFontName = this.getStringAttribute(CommonAttributes.SECTION_TITLE_FONT, true, CommonAttributes.SECTION_TITLE_FONT);
        this.titleFont = titleFontName == null ? this.getLocalFont() : this.documentHandler.getFont(titleFontName);
        this.spacingBefore = this.getDimensionAttribute(CommonAttributes.SPACING_BEFORE, true, CommonStyleAttributes.SPACING_BEFORE);
        this.spacingAfter = this.getDimensionAttribute(CommonAttributes.SPACING_AFTER, true, CommonStyleAttributes.SPACING_AFTER);
        CommonAttributesHolder commonAttributesHolder = this.getCommonAttributesHolder();
        this.leading = this.isAttributeDefined(CommonAttributes.LEADING, CommonStyleAttributes.LEADING) ? this.getDimensionAttribute(CommonAttributes.LEADING, true, CommonStyleAttributes.LEADING) : commonAttributesHolder.getLeading();
        this.lineSpacing = this.isAttributeDefined(CommonAttributes.LINE_SPACING, CommonStyleAttributes.LINE_SPACING) ? this.getDimensionAttribute(CommonAttributes.LINE_SPACING, true, CommonStyleAttributes.LINE_SPACING) : commonAttributesHolder.getLineSpacing();
        this.tocRelevance = this.getStringAttribute(CommonAttributes.TOC_RELEVANCE, "all", true, CommonStyleAttributes.TOC_RELEVANCE);
        this.createSection();
        if (this.isAttributeDefined(CommonAttributes.INDENTATION, CommonStyleAttributes.INDENTATION)) {
            this.section.setIndentation(this.getDimensionAttribute(CommonAttributes.INDENTATION, 0.0f, true, CommonStyleAttributes.INDENTATION));
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.spacingAfter > 0.0f) {
            Paragraph sap = new Paragraph(0.0f);
            sap.setSpacingAfter(this.spacingAfter);
            this.section.add((Object)sap);
        }
    }

    protected void createSection() throws DocumentHandlerException {
        String titleStr = this.getTextAttribute(CommonAttributes.SECTION_TITLE, true, null);
        DocumentFont titleDocFont = this.getTitleFont();
        Font titleFont = null;
        titleFont = titleDocFont != null ? titleDocFont.getFont() : new Font();
        Paragraph title = new Paragraph(titleStr, titleFont);
        this.extendLeading((Phrase)title, titleFont, this.getLeading(), this.getLineSpacing());
        Section sec = this.parentSection.getSection();
        int numberDepth = this.getIntegerAttribute(CommonAttributes.SECTION_NUMBER_DEPTH, 2, true, null);
        if (this.spacingBefore != 0.0f) {
            Paragraph sbp = new Paragraph(0.0f);
            sbp.setSpacingBefore(this.spacingBefore);
            sec.add((Object)sbp);
        }
        title.setSpacingAfter(this.getSpacingAfter());
        this.section = sec.addSection(title, numberDepth);
        this.section.setNumberStyle(sec.getNumberStyle());
        String number = ((Chunk)this.section.getTitle().getChunks().get(0)).getContent().trim();
        this.getDocumentHandler().addTocItem(new TocItem(numberDepth, number, titleStr, this.tocRelevance));
    }

    public Section getSection() {
        return this.section;
    }

    public void addElement(BaseDocumentTag item, Element element) throws DocumentHandlerException {
        if (item instanceof ParagraphTag) {
            ParagraphTag tag = (ParagraphTag)item;
            float leading = tag.getLeading();
            float lineSpacing = tag.getLineSpacing();
            this.extendLeading((Phrase)((Paragraph)element), item.getFont().getFont(), leading, lineSpacing);
        }
        this.section.add((Object)element);
    }

    public boolean isTopLevel() {
        return false;
    }

    public float getLeading() {
        return this.leading;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public DocumentFont getTitleFont() {
        return this.titleFont;
    }

    public Document handleNewPage(Rectangle size, Rectangle margins) throws DocumentHandlerException {
        this.section.add((Object)Chunk.NEXTPAGE);
        return this.documentHandler.getDocument();
    }
}

