/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;
import org.ujac.util.text.FormatHelper;

public class SetFormatTag
extends BaseDocumentTag {
    private static final AttributeDefinition DATA_TYPE = new AttributeDefinition("type", new String[]{"int", "float", "long", "double", "String", "Date", "Time", "Timestamp", "Object"}, true, "The type for which to define the format, supported types are: int, long, float, double, String, Date, Time, Timestamp and Object.");
    private static final AttributeDefinition FORMAT = new AttributeDefinition("format", 4, false, "The format for the specified type. For more info see JAVA SDK documentation for types java.text.DecimalFormat and java.text.SimpleDateFormat.");
    public static final String TAG_NAME = "set-format";
    private String type = null;
    private String formatString = null;

    public SetFormatTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the output format for the given data type.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(DATA_TYPE).addDefinition(FORMAT);
    }

    public boolean isStructureChecksDisabled() {
        return true;
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.type = this.getStringAttribute(DATA_TYPE, false, null);
        this.formatString = this.getStringAttribute(FORMAT, true, null);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        FormatHelper formatHelper = this.documentHandler.getFormatHelper();
        Format format = this.documentHandler.lookupFormat(this.formatString);
        if (format == null) {
            if (this.type.equalsIgnoreCase("int")) {
                format = formatHelper.setIntegerFormat(this.formatString);
            } else if (this.type.equalsIgnoreCase("double")) {
                format = formatHelper.setDoubleFormat(this.formatString);
            } else if (this.type.equalsIgnoreCase("Date")) {
                format = formatHelper.setDateFormat(this.formatString);
            } else if (this.type.equalsIgnoreCase("Time")) {
                format = formatHelper.setTimeFormat(this.formatString);
            } else if (this.type.equalsIgnoreCase("Timestamp")) {
                format = formatHelper.setTimestampFormat(this.formatString);
            }
            this.documentHandler.registerFormat(this.formatString, format);
        } else if (this.type.equalsIgnoreCase("int")) {
            formatHelper.setIntegerFormat((NumberFormat)format);
        } else if (this.type.equalsIgnoreCase("double")) {
            formatHelper.setDoubleFormat((NumberFormat)format);
        } else if (this.type.equalsIgnoreCase("Date")) {
            formatHelper.setDateFormat((DateFormat)format);
        } else if (this.type.equalsIgnoreCase("Time")) {
            formatHelper.setTimeFormat((DateFormat)format);
        } else if (this.type.equalsIgnoreCase("Timestamp")) {
            formatHelper.setTimestampFormat((DateFormat)format);
        }
    }
}

