/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.tag.BaseElementTag;

public class SpaceTag
extends BaseElementTag {
    private static final AttributeDefinition COUNT = new AttributeDefinition("count", 1, false, "The amount of spaces to insert, default is 1.");
    public static final String TAG_NAME = "space";
    private int count = 1;

    public SpaceTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Leading and trailing spaces are mostly killed by trimming the content, so if you like to explicitely print a certain amount of spaces into the document, you can do this by using this item.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(COUNT);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        if (this.isAttributeDefined(COUNT)) {
            this.count = this.getIntegerAttribute(COUNT, true, null);
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        int count = this.count;
        char[] buf = new char[count];
        for (int i = 0; i < count; ++i) {
            buf[i] = 32;
        }
        ElementContainer elementContainer = this.getElementContainer();
        elementContainer.addElement(this, (Element)new Phrase(new String(buf)));
    }
}

