/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag;

import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.BaseDocumentTag;
import org.ujac.print.DocumentHandlerException;

public class ViewerPreferencesTag
extends BaseDocumentTag {
    private static final AttributeDefinition PAGE_LAYOUT = new AttributeDefinition("page-layout", new String[]{"SinglePage", "OneColumn", "TwoColumnLeft", "TwoColumnRight"}, false, "Defines the page layout.");
    private static final AttributeDefinition PAGE_MODE = new AttributeDefinition("page-mode", new String[]{"UseNone", "UseOutlines", "UseThumbs", "UseOutlines|UseThumbs"}, false, "Defines the page mode for non full screen viewer mode.");
    private static final AttributeDefinition NON_FULL_SCREEN_PAGE_MODE = new AttributeDefinition("non-full-screen-page-mode", new String[]{"SinglePage", "OneColumn", "TwoColumnLeft", "TwoColumnRight"}, false, "Defines the page mode for non full screen mode.");
    private static final AttributeDefinition FULL_SCREEN = new AttributeDefinition("full-screen", 3, false, "Tells whether or not to display the document in full screen mode.");
    private static final AttributeDefinition HIDE_TOOLBAR = new AttributeDefinition("hide-toolbar", 3, false, "Tells whether or not to hide the viewer's tool bar.");
    private static final AttributeDefinition HIDE_MENUBAR = new AttributeDefinition("hide-menubar", 3, false, "Tells whether or not to hide the viewer's menu bar.");
    private static final AttributeDefinition HIDE_WINDOW_UI = new AttributeDefinition("hide-window-ui", 3, false, "Tells whether or not to hide the viewer's user interface.");
    private static final AttributeDefinition ZOOM = new AttributeDefinition("zoom", 2, false, "Tells what zoom level needs to be set when pdf is opened. Any value given is multiplied by 100. So the % should be 0.0 to 1.0");
    private static final AttributeDefinition FIT_WINDOW = new AttributeDefinition("fit-window", 3, false, "Tells whether or not to use the fit window option.");
    private static final AttributeDefinition CENTER_WINDOW = new AttributeDefinition("center-window", 3, false, "Tells whether or not to use the center window option.");
    private static final AttributeDefinition DIRECTION = new AttributeDefinition("direction", new String[]{"L2R", "R2L"}, false, "Defines the view direction.");
    private static final AttributeDefinition DISPLAY_DOC_TITLE = new AttributeDefinition("display-doc-title", 3, false, "Tells whether or not to display the document title.");
    public static final String TAG_NAME = "viewer-preferences";

    public ViewerPreferencesTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Defines the viewer preferences for the generated document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(PAGE_LAYOUT).addDefinition(PAGE_MODE).addDefinition(NON_FULL_SCREEN_PAGE_MODE).addDefinition(FULL_SCREEN).addDefinition(HIDE_TOOLBAR).addDefinition(HIDE_MENUBAR).addDefinition(HIDE_WINDOW_UI).addDefinition(ZOOM).addDefinition(FIT_WINDOW).addDefinition(CENTER_WINDOW).addDefinition(DIRECTION).addDefinition(DISPLAY_DOC_TITLE);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
    }

    public void openItem() throws DocumentHandlerException {
        String attr;
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        PdfWriter writer = (PdfWriter)this.getDocumentHandler().getDocumentWriter();
        int viewerPreferences = 0;
        if (this.isAttributeDefined(PAGE_LAYOUT)) {
            attr = this.getStringAttribute(PAGE_LAYOUT, true, null);
            if ("SinglePage".equals(attr)) {
                viewerPreferences |= 1;
            } else if ("OneColumn".equals(attr)) {
                viewerPreferences |= 2;
            } else if ("TwoColumnLeft".equals(attr)) {
                viewerPreferences |= 4;
            } else if ("TwoColumnRight".equals(attr)) {
                viewerPreferences |= 8;
            }
        }
        if (this.isAttributeDefined(PAGE_MODE)) {
            attr = this.getStringAttribute(PAGE_MODE, true, null);
            if ("UseNone".equals(attr)) {
                viewerPreferences |= 0x40;
            } else if ("UseOutlines".equals(attr)) {
                viewerPreferences |= 0x80;
            } else if ("UseThumbs".equals(attr)) {
                viewerPreferences |= 0x100;
            } else if ("UseOutlines|UseThumbs".equals(attr)) {
                viewerPreferences |= 0x180;
            }
        }
        if (this.isAttributeDefined(NON_FULL_SCREEN_PAGE_MODE)) {
            attr = this.getStringAttribute(NON_FULL_SCREEN_PAGE_MODE, true, null);
            if ("UseNone".equals(attr)) {
                viewerPreferences |= 0x40000;
            } else if ("UseOutlines".equals(attr)) {
                viewerPreferences |= 0x80000;
            } else if ("UseThumbs".equals(attr)) {
                viewerPreferences |= 0x100000;
            } else if ("UseOutlines|UseThumbs".equals(attr)) {
                viewerPreferences |= 0x180000;
            }
        }
        if (this.isAttributeDefined(FULL_SCREEN) && this.getBooleanAttribute(FULL_SCREEN, true, null)) {
            viewerPreferences |= 0x200;
        }
        if (this.isAttributeDefined(HIDE_TOOLBAR) && this.getBooleanAttribute(HIDE_TOOLBAR, true, null)) {
            viewerPreferences |= 0x1000;
        }
        if (this.isAttributeDefined(HIDE_MENUBAR) && this.getBooleanAttribute(HIDE_MENUBAR, true, null)) {
            viewerPreferences |= 0x2000;
        }
        if (this.isAttributeDefined(HIDE_WINDOW_UI) && this.getBooleanAttribute(HIDE_WINDOW_UI, true, null)) {
            viewerPreferences |= 0x4000;
        }
        if (this.isAttributeDefined(FIT_WINDOW) && this.getBooleanAttribute(FIT_WINDOW, true, null)) {
            viewerPreferences |= 0x8000;
        }
        if (this.isAttributeDefined(CENTER_WINDOW) && this.getBooleanAttribute(CENTER_WINDOW, true, null)) {
            viewerPreferences |= 0x10000;
        }
        if (this.isAttributeDefined(DIRECTION)) {
            attr = this.getStringAttribute(NON_FULL_SCREEN_PAGE_MODE, true, null);
            if ("L2R".equals(attr)) {
                viewerPreferences |= 0x400000;
            } else if ("R2L".equals(attr)) {
                viewerPreferences |= 0x800000;
            }
        }
        if (this.isAttributeDefined(DISPLAY_DOC_TITLE) && this.getBooleanAttribute(DISPLAY_DOC_TITLE, true, null)) {
            viewerPreferences |= 0x20000;
        }
        if (this.isAttributeDefined(ZOOM)) {
            float zoomLevel = this.getFloatAttribute(ZOOM, 0.0f, true, null);
            writer.setOpenAction(PdfAction.gotoLocalPage((int)1, (PdfDestination)new PdfDestination(0, -1.0f, -1.0f, zoomLevel), (PdfWriter)writer));
        }
        writer.setViewerPreferences(viewerPreferences);
    }
}

