/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.ChildDefinition;
import org.ujac.print.ChildDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.ElementContainer;
import org.ujac.print.JavascriptContainer;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.BaseElementTag;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.JavascriptTag;
import org.ujac.print.tag.acroform.FloatingFormElement;
import org.ujac.util.BeanUtils;

public abstract class BaseAcroFieldTag
extends BaseElementTag
implements JavascriptContainer {
    public static final AttributeDefinition FIELD_NAME = new AttributeDefinition("name", 12, true, "The field name.");
    public static final AttributeDefinition FIELD_VALUE = new AttributeDefinition("value", 4, false, "The field's value.");
    public static final AttributeDefinition FIELD_STATUS = new AttributeDefinition("status", 3, false, "The initial status (true/false).");
    public static final AttributeDefinition FIELD_X = new AttributeDefinition("x", 14, false, "The field's horizontal position on the current page.");
    public static final AttributeDefinition FIELD_Y = new AttributeDefinition("y", 14, false, "The field's vertical position on the current page.");
    public static final AttributeDefinition FIELD_WIDTH = new AttributeDefinition("width", 14, false, "The field's width.");
    public static final AttributeDefinition FIELD_HEIGHT = new AttributeDefinition("height", 14, false, "The field's heigth.");
    public static final AttributeDefinition FIELD_EDITABLE = new AttributeDefinition("editable", 3, false, "Tells whether the field should be editable or not, default is true.");
    public static final AttributeDefinition BORDER_TYPE = new AttributeDefinition("border-type", new String[]{"inset", "beveled", "dashed", "solid", "underline"}, false, "The field's border type.");
    public static final AttributeDefinition FORM_URL = new AttributeDefinition("url", 4, false, "The URL to post the form values to.");
    protected String fieldName = null;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected float borderWidth = 1.0f;
    protected Color borderColor = null;
    protected int borderType = 0;
    protected String javascript = null;

    public BaseAcroFieldTag(String name) {
        super(name);
    }

    public String getDescription() {
        return "Adds an Acro Field to the document.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.RENDERED).addDefinition(FIELD_NAME).addDefinition(FIELD_X).addDefinition(FIELD_Y).addDefinition(FIELD_WIDTH).addDefinition(FIELD_HEIGHT).addDefinition(CommonAttributes.BACKGROUND_COLOR).addDefinition(BORDER_TYPE).addDefinition(CommonAttributes.BORDER_WIDTH).addDefinition(CommonAttributes.BORDER_COLOR);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedAttributes().addDefinition(FIELD_X).addDefinition(FIELD_Y).addDefinition(FIELD_WIDTH).addDefinition(FIELD_HEIGHT).addDefinition(CommonStyleAttributes.BACKGROUND_COLOR).addDefinition(BORDER_TYPE).addDefinition(CommonStyleAttributes.BORDER_WIDTH).addDefinition(CommonStyleAttributes.BORDER_COLOR);
    }

    public ChildDefinitionMap buildSupportedChilds() {
        return super.buildSupportedChilds().addDefinition(new ChildDefinition(JavascriptTag.class, 0, 1));
    }

    public boolean isTextBodyAllowed() {
        return true;
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        if (this.isAttributeSupported(FIELD_NAME)) {
            this.fieldName = this.getStringAttribute(FIELD_NAME, true, null);
        }
        if (this.isAttributeSupported(FIELD_X)) {
            this.x = this.getDimensionAttribute(FIELD_X, true, FIELD_X);
        }
        if (this.isAttributeSupported(FIELD_Y)) {
            this.y = this.getDimensionAttribute(FIELD_Y, true, FIELD_Y);
        }
        if (this.isAttributeSupported(FIELD_WIDTH)) {
            this.width = this.getDimensionAttribute(FIELD_WIDTH, true, FIELD_WIDTH);
        }
        if (this.isAttributeSupported(FIELD_HEIGHT)) {
            this.height = this.getDimensionAttribute(FIELD_HEIGHT, true, FIELD_HEIGHT);
        }
        if (this.isAttributeSupported(BORDER_TYPE)) {
            String strBorderType = this.getStringAttribute(BORDER_TYPE, "solid", true, BORDER_TYPE);
            this.borderType = this.borderTypeFromString(strBorderType);
        }
        if (this.isAttributeSupported(CommonAttributes.BORDER_WIDTH)) {
            this.borderWidth = this.getDimensionAttribute(CommonAttributes.BORDER_WIDTH, 1.0f, true, CommonStyleAttributes.BORDER_WIDTH);
        }
        if (this.isAttributeSupported(CommonAttributes.BORDER_COLOR)) {
            this.borderColor = this.getColorAttribute(CommonAttributes.BORDER_COLOR, DEFAULT_FONT_COLOR, true, CommonStyleAttributes.BORDER_COLOR);
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
        if (this.isVisibleElement()) {
            if (!this.isAttributeDefined(FIELD_X) && !this.isAttributeDefined(FIELD_Y)) {
                ElementContainer elementContainer = this.getElementContainer();
                elementContainer.addElement(this, (Element)new FloatingFormElement(this, this.getPdfWriter(), this.width, this.height));
            } else {
                this.render(this.getPdfWriter(), null);
            }
        } else {
            this.addFormField(this.getAcroForm());
        }
    }

    public PdfAcroForm getAcroForm() {
        PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
        return writer.getAcroForm();
    }

    public PdfWriter getPdfWriter() {
        PdfWriter writer = (PdfWriter)this.documentHandler.getDocumentWriter();
        return writer;
    }

    public void addJavaScript(String code) {
        this.setJavascript(code);
    }

    public abstract PdfFormField addFormField(PdfAcroForm var1) throws DocumentHandlerException;

    public boolean isVisibleElement() {
        return true;
    }

    public PdfFormField render(PdfWriter writer, Rectangle fieldPosition) throws DocumentHandlerException {
        PdfFormField formField = this.addFormField(this.getAcroForm());
        if (fieldPosition != null) {
            formField.setWidget(fieldPosition, PdfAnnotation.HIGHLIGHT_INVERT);
        }
        if (formField != null) {
            writer.addAnnotation((PdfAnnotation)formField);
        }
        return formField;
    }

    protected void applyJavaScript(PdfFormField formField) {
        if (!BeanUtils.isEmpty(this.javascript)) {
            PdfAction action = PdfAction.javaScript((String)this.javascript, (PdfWriter)this.getPdfWriter());
            formField.setAction(action);
        }
    }

    protected Rectangle getFieldDimensions() {
        if (this.isAttributeDefined(FIELD_X) || this.isAttributeDefined(FIELD_Y)) {
            return new Rectangle(this.x, this.y, this.x + this.width, this.y + this.height);
        }
        return new Rectangle(this.width, this.height);
    }

    protected float getBorderWidth() {
        return this.borderWidth;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected int getBorderType() {
        return this.borderType;
    }

    protected Color getTextColor() {
        DocumentFont font = this.getFont();
        return font.getColor();
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }

    protected int borderTypeFromString(String borderType) throws TagAttributeException {
        if (borderType == null) {
            return 0;
        }
        String borderTypeLower = borderType.toLowerCase();
        if ("inset".equals(borderTypeLower)) {
            return 3;
        }
        if ("beveled".equals(borderTypeLower)) {
            return 2;
        }
        if ("dashed".equals(borderTypeLower)) {
            return 1;
        }
        if ("solid".equals(borderTypeLower)) {
            return 0;
        }
        if ("underline".equals(borderTypeLower)) {
            return 4;
        }
        throw new TagAttributeException(this.locator(), "Invalid border type '" + borderTypeLower + "'");
    }
}

