/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;

public class FloatingFormElement
extends PdfPTable
implements PdfPCellEvent {
    private BaseAcroFieldTag tag;
    private PdfWriter writer;

    public FloatingFormElement(BaseAcroFieldTag tag, PdfWriter writer, float width, float height) {
        super(1);
        this.tag = tag;
        this.writer = writer;
        this.setHorizontalAlignment(0);
        float[] widths = new float[]{width};
        try {
            this.setTotalWidth(widths);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setLockedWidth(true);
        PdfPCell cell = new PdfPCell();
        cell.setFixedHeight(height);
        cell.setCellEvent((PdfPCellEvent)this);
        cell.setBorder(0);
        this.addCell(cell);
    }

    public void cellLayout(PdfPCell cell, Rectangle pos, PdfContentByte[] canvases) {
        try {
            Rectangle fieldPosition = new Rectangle(pos.getLeft(), pos.getBottom() - 5.0f, pos.getRight(), pos.getTop() - 5.0f);
            this.tag.render(this.writer, fieldPosition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

