/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;
import java.io.IOException;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;

public class HiddenFieldAcroFieldTag
extends BaseAcroFieldTag {
    public static final String TAG_NAME = "hidden-field";
    protected String fieldValue = null;
    protected boolean status = false;

    public HiddenFieldAcroFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a hidden field to the documents AcroForm.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(FIELD_NAME).addDefinition(FIELD_VALUE);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.fieldValue = this.getStringAttribute(FIELD_VALUE, true, null);
    }

    public PdfFormField addFormField(PdfAcroForm form) throws DocumentHandlerException {
        try {
            DocumentFont font = this.getFont();
            BaseFont bf = font.getFont().getBaseFont();
            PdfWriter pdfWriter = this.getPdfWriter();
            TextField tf = new TextField(pdfWriter, new Rectangle(0.0f, 0.0f, 0.0f, 0.0f), this.fieldName);
            tf.setFont(bf);
            int rotation = this.documentHandler.getDocument().getPageSize().getRotation();
            tf.setRotation(rotation);
            tf.setFontSize(font.getSize());
            tf.setText(this.fieldValue);
            tf.setOptions(1);
            PdfFormField ff = tf.getTextField();
            pdfWriter.addAnnotation((PdfAnnotation)ff);
            return null;
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
    }

    public boolean isVisibleElement() {
        return false;
    }
}

