/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RadioCheckField;
import java.awt.Color;
import java.io.IOException;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.print.tag.acroform.RadioGroupAcroFieldTag;
import org.ujac.util.template.TemplateException;

public class RadioButtonAcroFieldTag
extends BaseAcroFieldTag {
    public static final String TAG_NAME = "radio-button";
    protected RadioGroupAcroFieldTag radioButtonGroup = null;
    protected String fieldValue = null;
    protected int borderStyle = 3;

    public RadioButtonAcroFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a radio button to the documents AcroForm.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(FORM_URL).addDefinition(CommonAttributes.FONT).addDefinition(FIELD_VALUE).removeDefinition(FIELD_NAME);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME);
    }

    public void initialize() throws DocumentHandlerException {
        super.initialize();
        this.radioButtonGroup = (RadioGroupAcroFieldTag)this.documentHandler.latestOfType(RadioGroupAcroFieldTag.class);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.fieldValue = this.getStringAttribute(FIELD_VALUE, true, null);
        if (this.isAttributeSupported(CommonAttributes.FONT)) {
            this.setLocalFont(this.getStringAttribute(CommonAttributes.FONT, true, CommonStyleAttributes.FONT_NAME));
        }
        if (this.isAttributeDefined(BORDER_TYPE, BORDER_TYPE)) {
            String strBorderStyle = this.getStringAttribute(BORDER_TYPE, "solid", true, BORDER_TYPE);
            this.borderStyle = this.borderTypeFromString(strBorderStyle);
        } else {
            this.borderType = this.radioButtonGroup.getBorderType();
        }
        this.borderWidth = this.isAttributeDefined(CommonAttributes.BORDER_WIDTH, CommonStyleAttributes.BORDER_WIDTH) ? this.getDimensionAttribute(CommonAttributes.BORDER_WIDTH, 1.0f, true, CommonStyleAttributes.BORDER_WIDTH) : this.radioButtonGroup.getBorderWidth();
        this.borderColor = this.isAttributeDefined(CommonAttributes.BORDER_COLOR, CommonStyleAttributes.BORDER_COLOR) ? this.getColorAttribute(CommonAttributes.BORDER_COLOR, Color.lightGray, true, CommonStyleAttributes.BORDER_COLOR) : this.radioButtonGroup.getBorderColor();
        if (this.isAttributeDefined(CommonAttributes.BACKGROUND_COLOR, CommonStyleAttributes.BACKGROUND_COLOR)) {
            this.setBackgroundColor(this.getColorAttribute(CommonAttributes.BACKGROUND_COLOR, null, true, CommonStyleAttributes.BACKGROUND_COLOR));
        } else {
            this.setBackgroundColor(this.radioButtonGroup.getBackgroundColor());
        }
    }

    public PdfFormField addFormField(PdfAcroForm form) throws DocumentHandlerException {
        PdfWriter pdfWriter = (PdfWriter)this.getDocumentHandler().getDocumentWriter();
        try {
            DocumentFont font = this.getFont();
            BaseFont bf = font.getFont().getBaseFont();
            RadioCheckField cf = new RadioCheckField(pdfWriter, this.getFieldDimensions(), this.radioButtonGroup.getRadioGroupName(), this.fieldValue);
            cf.setChecked(this.fieldValue.equals(this.radioButtonGroup.getRadioValue()));
            cf.setFont(bf);
            int rotation = this.documentHandler.getDocument().getPageSize().getRotation();
            cf.setRotation(rotation);
            cf.setFontSize(font.getSize());
            cf.setBorderStyle(this.getBorderStyle());
            cf.setBorderWidth(this.getBorderWidth());
            cf.setBorderColor(this.getBorderColor());
            cf.setBackgroundColor(this.getBackgroundColor());
            cf.setTextColor(this.getTextColor());
            cf.setOptions(0);
            cf.setCheckType(2);
            PdfFormField ff = cf.getRadioField();
            this.applyJavaScript(ff);
            this.radioButtonGroup.getRadioGroup().addKid(ff);
            return ff;
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
    }

    public PdfFormField render(PdfWriter writer, Rectangle fieldPosition) throws DocumentHandlerException {
        PdfFormField formField = super.render(writer, fieldPosition);
        String label = null;
        try {
            label = this.documentHandler.executeTemplate(this.getContent());
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        DocumentFont docFont = this.getFont();
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        cb.beginText();
        cb.setFontAndSize(docFont.getFont().getBaseFont(), docFont.getSize());
        float x = this.x;
        float y = this.y;
        if (fieldPosition != null) {
            x = fieldPosition.getLeft();
            y = fieldPosition.getBottom();
        }
        cb.moveText(x + this.width * 1.2f, y + this.borderWidth);
        cb.showText(label);
        cb.endText();
        cb.restoreState();
        writer.addAnnotation((PdfAnnotation)formField);
        return formField;
    }

    protected float getBorderWidth() {
        return this.borderWidth;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected int getBorderStyle() {
        return this.borderStyle;
    }

    protected Color getTextColor() {
        return null;
    }
}

