/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.acroform;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TextField;
import java.io.IOException;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentFont;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.TagAttributeException;
import org.ujac.print.tag.CommonAttributes;
import org.ujac.print.tag.CommonStyleAttributes;
import org.ujac.print.tag.acroform.BaseAcroFieldTag;
import org.ujac.util.template.TemplateException;

public class TextFieldAcroFieldTag
extends BaseAcroFieldTag {
    public static final AttributeDefinition FIELD_TYPE = new AttributeDefinition("type", new String[]{"simple", "multiline", "password"}, false, "The field type. Default is 'simple'.");
    public static final AttributeDefinition TEXT_ALIGN = new AttributeDefinition("text-align", new String[]{"left", "center", "right"}, false, "The field text alignment.  Default is 'left'.");
    public static final String TAG_NAME = "text-field";
    protected String type = null;
    protected int alignment = 0;

    public TextFieldAcroFieldTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Adds a text field to the documents AcroForm.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(CommonAttributes.CLASS).addDefinition(CommonAttributes.STYLE).addDefinition(FIELD_TYPE).addDefinition(CommonAttributes.FONT).addDefinition(TEXT_ALIGN);
    }

    protected AttributeDefinitionMap buildSupportedStyleAttributes() {
        return super.buildSupportedStyleAttributes().addDefinition(CommonStyleAttributes.FONT_NAME).addDefinition(TEXT_ALIGN);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        this.type = this.getStringAttribute(FIELD_TYPE, "simple", true, null);
        this.alignment = this.textAlignmentFromString(this.getStringAttribute(TEXT_ALIGN, "left", true, null));
    }

    public PdfFormField addFormField(PdfAcroForm form) throws DocumentHandlerException {
        String text = null;
        try {
            text = this.documentHandler.executeTemplate(this.getContent());
        }
        catch (TemplateException ex) {
            throw new DocumentHandlerException(this.locator(), "Content evaluation failed: " + ex.getMessage(), ex);
        }
        try {
            DocumentFont font = this.getFont();
            BaseFont bf = font.getFont().getBaseFont();
            PdfWriter pdfWriter = this.getPdfWriter();
            TextField tf = new TextField(pdfWriter, this.getFieldDimensions(), this.fieldName);
            tf.setFont(bf);
            int rotation = this.documentHandler.getDocument().getPageSize().getRotation();
            tf.setRotation(rotation);
            tf.setFontSize(font.getSize());
            tf.setText(text);
            tf.setBorderStyle(this.getBorderType());
            tf.setBorderWidth(this.getBorderWidth());
            tf.setBorderColor(this.getBorderColor());
            tf.setBackgroundColor(this.getBackgroundColor());
            tf.setTextColor(this.getTextColor());
            tf.setAlignment(this.alignment);
            if ("multiline".equals(this.type)) {
                tf.setOptions(4096);
            } else if ("password".equals(this.type)) {
                tf.setOptions(8192);
            } else {
                tf.setOptions(0);
            }
            PdfFormField ff = tf.getTextField();
            this.applyJavaScript(ff);
            return ff;
        }
        catch (DocumentException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DocumentHandlerException(this.locator(), "Unable to add FormField: " + ex.getMessage(), ex);
        }
    }

    protected int textAlignmentFromString(String alignment) throws TagAttributeException {
        if (alignment == null) {
            return 0;
        }
        if ("left".equals(alignment = alignment.toLowerCase())) {
            return 0;
        }
        if ("center".equals(alignment)) {
            return 1;
        }
        if ("right".equals(alignment)) {
            return 2;
        }
        throw new TagAttributeException(this.locator(), "Invalid text alignment '" + alignment + "'");
    }
}

