/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.print.tag.graphics;

import com.lowagie.text.pdf.PdfContentByte;
import org.ujac.print.AttributeDefinition;
import org.ujac.print.AttributeDefinitionMap;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.tag.graphics.BaseGraphicsTag;

public class DrawCircleTag
extends BaseGraphicsTag {
    private static final AttributeDefinition RADIUS = new AttributeDefinition("radius", 14, true, "The radius of the circle to draw.");
    private static final AttributeDefinition CIRCLE_X = X.cloneAttrDef("The horizontal position of the center of the circle.");
    private static final AttributeDefinition CIRCLE_Y = Y.cloneAttrDef("The vertical position of the center of the circle.");
    public static final String TAG_NAME = "draw-circle";

    public DrawCircleTag() {
        super(TAG_NAME);
    }

    public String getDescription() {
        return "Draws a circle.";
    }

    protected AttributeDefinitionMap buildSupportedAttributes() {
        return super.buildSupportedAttributes().addDefinition(FILL).addDefinition(CIRCLE_X).addDefinition(CIRCLE_Y).addDefinition(RADIUS);
    }

    public void openItem() throws DocumentHandlerException {
        super.openItem();
        if (!this.isValid()) {
            return;
        }
        boolean fill = this.getBooleanAttribute(FILL, false, true, null);
        float x = this.getDimensionAttribute(CIRCLE_X, true, null);
        float y = this.getDimensionAttribute(CIRCLE_Y, true, null);
        float radius = this.getDimensionAttribute(RADIUS, true, null);
        PdfContentByte cb = this.graphicsTag.getContentByte();
        cb.circle(x, y, radius);
        if (fill) {
            cb.fillStroke();
        } else {
            cb.stroke();
        }
    }

    public void closeItem() throws DocumentHandlerException {
        if (!this.isValid()) {
            return;
        }
    }
}

