/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.ujac.util.TypeConverter;
import org.ujac.util.TypeConverterException;
import org.ujac.util.text.FormatHelper;
import org.ujac.util.types.BooleanType;
import org.ujac.util.types.DataType;
import org.ujac.util.types.DateType;
import org.ujac.util.types.DoubleType;
import org.ujac.util.types.FloatType;
import org.ujac.util.types.IntegerType;
import org.ujac.util.types.LongType;
import org.ujac.util.types.ShortType;
import org.ujac.util.types.StringType;
import org.ujac.util.types.TimeType;
import org.ujac.util.types.TimestampType;

public class DefaultTypeConverter
implements TypeConverter {
    private Map dataTypeRegistry = new HashMap();
    private DataType[] typeIdMap = new DataType[12];
    private FormatHelper formatHelper = null;

    public DefaultTypeConverter() {
        this(FormatHelper.createInstance());
    }

    public DefaultTypeConverter(FormatHelper formatHelper) {
        this.formatHelper = formatHelper;
        this.registerDataTypes();
    }

    protected void registerDataTypes() {
        this.registerDataType(String.class, new StringType());
        DataType dataType = new BooleanType();
        this.registerDataType(Boolean.class, dataType);
        this.registerDataType(Boolean.TYPE, dataType);
        dataType = new IntegerType();
        this.registerDataType(Integer.class, dataType);
        this.registerDataType(Integer.TYPE, dataType);
        dataType = new LongType();
        this.registerDataType(Long.class, dataType);
        this.registerDataType(Long.TYPE, dataType);
        dataType = new ShortType();
        this.registerDataType(Short.class, dataType);
        this.registerDataType(Short.TYPE, dataType);
        dataType = new DoubleType();
        this.registerDataType(Double.class, dataType);
        this.registerDataType(Double.TYPE, dataType);
        dataType = new FloatType();
        this.registerDataType(Float.class, dataType);
        this.registerDataType(Float.TYPE, dataType);
        this.registerDataType(Date.class, new DateType());
        this.registerDataType(Time.class, new TimeType());
        this.registerDataType(Timestamp.class, new TimestampType());
    }

    public void registerDataType(Class clazz, DataType typeHandler) {
        this.dataTypeRegistry.put(clazz, typeHandler);
        this.typeIdMap[typeHandler.getTypeId()] = typeHandler;
    }

    public DataType getDataType(Class clazz) {
        return (DataType)this.dataTypeRegistry.get(clazz);
    }

    public DataType getDataType(int typeId) {
        return this.typeIdMap[typeId];
    }

    public Object convertObject(Class clazz, Object value) throws TypeConverterException {
        DataType typeHandler = this.getDataType(clazz);
        if (typeHandler == null) {
            if (clazz.isInstance(value)) {
                return value;
            }
            throw new TypeConverterException("No type handler registerd for class " + clazz.getName());
        }
        return typeHandler.convertObject(value, this.formatHelper);
    }

    public Object convertObject(int typeId, Object value) throws TypeConverterException {
        DataType typeHandler = this.getDataType(typeId);
        if (typeHandler == null) {
            throw new TypeConverterException("No type handler registerd for type ID " + typeId);
        }
        return typeHandler.convertObject(value, this.formatHelper);
    }

    public String formatValue(Class clazz, Object value) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        DataType typeHandler = this.getDataType(clazz);
        if (typeHandler == null) {
            throw new TypeConverterException("No type handler registerd for class " + clazz.getName());
        }
        return typeHandler.formatValue(value, this.formatHelper);
    }

    public String formatValue(int typeId, Object value) throws TypeConverterException {
        if (value == null) {
            return null;
        }
        DataType typeHandler = this.getDataType(typeId);
        if (typeHandler == null) {
            throw new TypeConverterException("No type handler registerd for type ID " + typeId);
        }
        return typeHandler.formatValue(value, this.formatHelper);
    }
}

