/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.ujac.print.DocumentHandlerException;
import org.ujac.print.DocumentPrinter;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionType;

public class DocumentationGenerator {
    private ExpressionInterpreter exi = null;

    public DocumentationGenerator(ExpressionInterpreter exi) {
        this.exi = exi;
    }

    private void generateDocumentation(InputStream documentationTempleteStream, OutputStream outputStream) throws DocumentHandlerException, IOException {
        ArrayList<ExpressionType> typeHandlers = new ArrayList<ExpressionType>();
        Iterator typeIter = this.exi.getTypeHandlers().iterator();
        while (typeIter.hasNext()) {
            ExpressionType typeHandler = (ExpressionType)typeIter.next();
            typeHandlers.add(typeHandler);
        }
        Collections.sort(typeHandlers, new TypeNameComparator());
        HashMap<String, ArrayList<ExpressionType>> properties = new HashMap<String, ArrayList<ExpressionType>>();
        properties.put("typeHandlers", typeHandlers);
        DocumentPrinter docPrinter = new DocumentPrinter(documentationTempleteStream, properties);
        docPrinter.printDocument(outputStream);
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("usage: org.ujac.util.exi.DocumentationGenerator [<output file> <expression interpreter class>]");
            System.exit(1);
        }
        try {
            OutputStream outputStream = null;
            if (args.length < 1) {
                outputStream = System.out;
            } else {
                outputStream = new FileOutputStream(args[0]);
                if (args.length > 1) {
                    System.setProperty("org.ujac.expression.interpreter", args[1]);
                }
            }
            ExpressionInterpreter exi = ExpressionInterpreter.createInstance();
            DocumentationGenerator dg = new DocumentationGenerator(exi);
            InputStream documentationTempleteStream = DocumentationGenerator.class.getClassLoader().getResourceAsStream("org/ujac/util/exi/documentation-template.xml");
            dg.generateDocumentation(documentationTempleteStream, outputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (DocumentHandlerException ex) {
            ex.printStackTrace();
        }
    }

    private static class TypeNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            ExpressionType item1 = (ExpressionType)o1;
            ExpressionType item2 = (ExpressionType)o2;
            return item1.getType().getName().compareTo(item2.getType().getName());
        }
    }
}

