/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionOperation;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.ExpressionType;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.Operation;
import org.ujac.util.exi.TypeCastException;
import org.ujac.util.text.FormatHelper;

public abstract class BaseType
implements ExpressionType {
    protected ExpressionInterpreter interpreter;
    protected Map operations = new HashMap();

    protected String execToString(ExpressionTuple expr, FormatHelper formatHelper) {
        Object value = expr.getObject().getValue();
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public BaseType(ExpressionInterpreter interpreter) {
        this.interpreter = interpreter;
        this.addOperation("isDefined", new ObjectDefinedOperation());
        this.addOperation("notDefined", new ObjectNotDefinedOperation());
        this.addOperation("toString", new ToStringOperation());
        BaseExpressionOperation op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new NotEqualOperation();
        this.addOperation("!=", op);
        this.addOperation("ne", op);
        this.addOperation("instanceof", new InstanceofOperation());
    }

    public ExpressionOperation getOperation(Operation operation) {
        return (ExpressionOperation)this.operations.get(operation.getName());
    }

    public Set getOperationNames() {
        return this.operations.keySet();
    }

    public Map getOperations() {
        return this.operations;
    }

    public void addOperation(String name, ExpressionOperation operation) {
        this.operations.put(name, operation);
    }

    public void removeOperation(String name) {
        this.operations.remove(name);
    }

    public void removeAllOperations() {
        this.operations.clear();
    }

    public Object evalTuple(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
        ExpressionOperation op = this.getOperation(expr.getOperation());
        if (op == null) {
            if (expr.getObject().getValue() == null) {
                throw new ExpressionException("Unable to execute operation '" + expr.getOperation() + "' on null value at expression '" + expr.getCode() + "'.");
            }
            throw new ExpressionException("Operation '" + expr.getOperation() + "' is not supported for type " + this.getType().getName() + " at expression '" + expr.getCode() + "'.");
        }
        return op.evaluate(expr, ctx);
    }

    public String getTypeName() {
        Class type = this.getType();
        if (type.isArray()) {
            return type.getComponentType().getName() + "[]";
        }
        return type.getName();
    }

    public String getAlias() {
        return null;
    }

    public String getDescription() {
        return "A type handler for " + this.getTypeName() + " values.";
    }

    public Object typeCast(Object value) throws TypeCastException {
        throw new TypeCastException("Type casts are not supported for type " + this.getType() + "!");
    }

    public class InstanceofOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = BaseType.this.interpreter.evalStringOperand(operand, ctx);
            Object objectValue = expr.getObject().getValue();
            if (objectValue == null) {
                return new Boolean(false);
            }
            try {
                Class<?> operandClass = Class.forName(operandValue);
                return new Boolean(operandClass.isInstance(objectValue));
            }
            catch (ClassNotFoundException ex) {
                throw new OperandException("No class definition found for operand '" + operandValue + "' at operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = BaseType.this.interpreter.evalOperand(operand, ctx);
            Object objectValue = expr.getObject().getValue();
            if (objectValue == null || operandValue == null) {
                return new Boolean(objectValue != operandValue);
            }
            return new Boolean(!objectValue.equals(operandValue));
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = BaseType.this.interpreter.evalOperand(operand, ctx);
            Object objectValue = expr.getObject().getValue();
            if (objectValue == null || operandValue == null) {
                return new Boolean(objectValue == operandValue);
            }
            return new Boolean(objectValue.equals(operandValue));
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }

    public class ToStringOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            return BaseType.this.execToString(expr, ctx.getFormatHelper());
        }

        public String getDescription() {
            return "Serves a textual representation of the object.";
        }
    }

    public class ObjectNotDefinedOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            return new Boolean(expr.getObject().getValue() == null);
        }

        public String getDescription() {
            return "Checks if the object is not defined.";
        }
    }

    public class ObjectDefinedOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            return new Boolean(expr.getObject().getValue() != null);
        }

        public String getDescription() {
            return "Tells whether the object is defined or not.";
        }
    }
}

