/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.text.NumberFormat;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.type.BaseType;
import org.ujac.util.text.FormatHelper;

public class CharType
extends BaseType {
    protected String execToString(ExpressionTuple expr, FormatHelper formatHelper) {
        Number value = (Number)expr.getObject().getValue();
        NumberFormat format = formatHelper.getIntegerFormat();
        if (format != null) {
            return format.format(value);
        }
        return value.toString();
    }

    public CharType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new EqualOperation();
        this.addOperation("==", op);
        this.addOperation("eq", op);
        op = new NotEqualOperation();
        this.addOperation("!=", op);
        this.addOperation("ne", op);
        op = new GreaterOperation();
        this.addOperation(">", op);
        this.addOperation("gt", op);
        op = new GreaterEqualOperation();
        this.addOperation(">=", op);
        this.addOperation("ge", op);
        op = new LessOperation();
        this.addOperation("<", op);
        this.addOperation("lt", op);
        op = new LessEqualOperation();
        this.addOperation("<=", op);
        this.addOperation("le", op);
        op = new AddOperation();
        this.addOperation("+", op);
        this.addOperation("concat", op);
        this.addOperation("min", new MinOperation());
        this.addOperation("max", new MaxOperation());
    }

    public Class getType() {
        return Character.class;
    }

    public String getAlias() {
        return "char";
    }

    public class MaxOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            Character object = (Character)expr.getObject().getValue();
            if (object.charValue() > operandValue) {
                return object;
            }
            return new Character(operandValue);
        }

        public String getDescription() {
            return "Gets the maximum of the object and the operand value.";
        }
    }

    public class MinOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            Character object = (Character)expr.getObject().getValue();
            if (object.charValue() > operandValue) {
                return object;
            }
            return new Character(operandValue);
        }

        public String getDescription() {
            return "Gets the minimum of the object and the operand value.";
        }
    }

    public class AddOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = CharType.this.interpreter.evalStringOperand(operand, ctx);
            StringBuffer buf = new StringBuffer();
            buf.append(((Character)expr.getObject().getValue()).charValue());
            buf.append(operandValue);
            return buf.toString();
        }

        public String getDescription() {
            return "Calculates the sum of the object and the operand value.";
        }
    }

    public class LessEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            return new Boolean(((Character)expr.getObject().getValue()).charValue() <= operandValue);
        }

        public String getDescription() {
            return "Checks if the object is smaller than or equal to the operand.";
        }
    }

    public class GreaterEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            return new Boolean(((Character)expr.getObject().getValue()).charValue() >= operandValue);
        }

        public String getDescription() {
            return "Checks if the object is greater than or equal to the operand.";
        }
    }

    public class LessOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            return new Boolean(((Character)expr.getObject().getValue()).charValue() < operandValue);
        }

        public String getDescription() {
            return "Checks if the object is smaller than the operand.";
        }
    }

    public class GreaterOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            return new Boolean(((Character)expr.getObject().getValue()).charValue() > operandValue);
        }

        public String getDescription() {
            return "Checks if the object is greater than the operand.";
        }
    }

    public class NotEqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            return new Boolean(((Character)expr.getObject().getValue()).charValue() != operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for inequality.";
        }
    }

    public class EqualOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            char operandValue = CharType.this.interpreter.evalCharOperand(operand, ctx);
            return new Boolean(((Character)expr.getObject().getValue()).charValue() == operandValue);
        }

        public String getDescription() {
            return "Compares the object with the operand for equality.";
        }
    }
}

