/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.util.Map;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;

public class MapType
extends BaseType {
    public MapType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new IsEmptyOperation();
        this.addOperation("isEmpty", op);
        op = new NotEmptyOperation();
        this.addOperation("notEmpty", op);
        op = new SizeOperation();
        this.addOperation("size", op);
        op = new ContainsKeyOperation();
        this.addOperation("containsKey", op);
        op = new NotContainsKeyOperation();
        this.addOperation("notContainsKey", op);
        op = new GetOperation();
        this.addOperation(".", op);
        this.addOperation("[]", op);
        this.addOperation("get", op);
        op = new EntriesOperation();
        this.addOperation("entries", op);
    }

    public Class getType() {
        return Map.class;
    }

    public class EntriesOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Map map = (Map)expr.getObject().getValue();
            return map.entrySet().iterator();
        }

        public String getDescription() {
            return "Gets an element from the map by its key.";
        }
    }

    public class GetOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = MapType.this.interpreter.evalOperand(operand, ctx);
            Map map = (Map)expr.getObject().getValue();
            return map.get(operandValue);
        }

        public String getDescription() {
            return "Gets an element from the map by its key.";
        }
    }

    public class NotContainsKeyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = MapType.this.interpreter.evalOperand(operand, ctx);
            Map map = (Map)expr.getObject().getValue();
            return new Boolean(!map.containsKey(operandValue));
        }

        public String getDescription() {
            return "Checks if the map not contains the key, specified by the operand.";
        }
    }

    public class ContainsKeyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Object operandValue = MapType.this.interpreter.evalOperand(operand, ctx);
            Map map = (Map)expr.getObject().getValue();
            return new Boolean(map.containsKey(operandValue));
        }

        public String getDescription() {
            return "Checks if the map contains the key, specified by the operand value.";
        }
    }

    public class SizeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Map map = (Map)expr.getObject().getValue();
            return new Integer(map.size());
        }

        public String getDescription() {
            return "Determines the size of the map.";
        }
    }

    public class NotEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Map map = (Map)expr.getObject().getValue();
            return new Boolean(!map.isEmpty());
        }

        public String getDescription() {
            return "Checks if the map is not empty.";
        }
    }

    public class IsEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Map map = (Map)expr.getObject().getValue();
            return new Boolean(map.isEmpty());
        }

        public String getDescription() {
            return "Tells whether the map is empty or not.";
        }
    }
}

