/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.util.ResourceBundle;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;

public class ResourceBundleType
extends BaseType {
    public ResourceBundleType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new IsEmptyOperation();
        this.addOperation("isEmpty", op);
        op = new NotEmptyOperation();
        this.addOperation("notEmpty", op);
        op = new ContainsKeyOperation();
        this.addOperation("containsKey", op);
        op = new NotContainsKeyOperation();
        this.addOperation("notContainsKey", op);
        op = new GetOperation();
        this.addOperation(".", op);
        this.addOperation("[]", op);
        this.addOperation("get", op);
    }

    public Class getType() {
        return ResourceBundle.class;
    }

    public class GetOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = ResourceBundleType.this.interpreter.evalStringOperand(operand, ctx);
            ResourceBundle bundle = (ResourceBundle)expr.getObject().getValue();
            return bundle.getString(operandValue);
        }

        public String getDescription() {
            return "Gets an element from the bundle by its name.";
        }
    }

    public class NotContainsKeyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = ResourceBundleType.this.interpreter.evalStringOperand(operand, ctx);
            ResourceBundle bundle = (ResourceBundle)expr.getObject().getValue();
            return new Boolean(bundle.getString(operandValue) == null);
        }

        public String getDescription() {
            return "Checks if the bundle not contains the key, specified by the operand.";
        }
    }

    public class ContainsKeyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = ResourceBundleType.this.interpreter.evalStringOperand(operand, ctx);
            ResourceBundle bundle = (ResourceBundle)expr.getObject().getValue();
            return new Boolean(bundle.getString(operandValue) != null);
        }

        public String getDescription() {
            return "Checks if the bundle contains the key, specified by the operand value.";
        }
    }

    public class NotEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            ResourceBundle bundle = (ResourceBundle)expr.getObject().getValue();
            return new Boolean(bundle.getKeys().hasMoreElements());
        }

        public String getDescription() {
            return "Checks if the bundle is not empty.";
        }
    }

    public class IsEmptyOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            ResourceBundle bundle = (ResourceBundle)expr.getObject().getValue();
            return new Boolean(!bundle.getKeys().hasMoreElements());
        }

        public String getDescription() {
            return "Tells whether the bundle is empty or not.";
        }
    }
}

