/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import org.ujac.util.BeanUtils;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.GroupRow;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.Table;
import org.ujac.util.table.TypeMismatchException;

public class RowType
extends BaseType {
    public RowType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new ReferenceOperation();
        this.addOperation(".", op);
        this.addOperation("[]", op);
        this.addOperation("getField", op);
        op = new FormatValueOperation();
        this.addOperation("formatValue", op);
        op = new HasRowsOperation();
        this.addOperation("hasRows", op);
        op = new NoRowsOperation();
        this.addOperation("noRows", op);
        op = new RowCountOperation();
        this.addOperation("rowCount", op);
        op = new ColumnCountOperation();
        this.addOperation("columnCount", op);
        op = new HasColumnOperation();
        this.addOperation("hasColumn", op);
        op = new RowTypeOperation();
        this.addOperation("rowType", op);
        op = new IsVisibleOperation();
        this.addOperation("isVisible", op);
        op = new IsVisibleOperation();
        this.addOperation("isVisible", op);
    }

    public Class getType() {
        return Row.class;
    }

    public class IsVisibleOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = RowType.this.interpreter.evalStringOperand(operand, ctx);
            Row row = (Row)expr.getObject().getValue();
            try {
                return new Boolean(row.isVisible(operandValue));
            }
            catch (ColumnNotDefinedException e) {
                throw new OperandException("Unknown column '" + operandValue + "' for table at expression '" + expr.getCode() + "'.");
            }
        }

        public String getDescription() {
            return "Checks whether the field, specified by the operand is visible or not.";
        }
    }

    public class RowTypeOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Row row = (Row)expr.getObject().getValue();
            return row.getType();
        }

        public String getDescription() {
            return "Gets the type of the row.";
        }
    }

    public class FormatValueOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = RowType.this.interpreter.evalStringOperand(operand, ctx);
            Row row = (Row)expr.getObject().getValue();
            Table table = row.getTable();
            try {
                if (BeanUtils.equals(operandValue, "groupName") && row instanceof GroupRow) {
                    GroupRow gr = (GroupRow)row;
                    return gr.getGroupName();
                }
                if (operandValue == null) {
                    throw new OperandException("No valid operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "! Quotes forgotten?");
                }
                Column col = table.getColumn(operandValue);
                int colIdx = col.getIndex();
                if (!row.isVisible(colIdx)) {
                    return "";
                }
                String result = row.getString(colIdx);
                if (result == null) {
                    return "-";
                }
                return result;
            }
            catch (ColumnNotDefinedException e) {
                StringBuffer msg = new StringBuffer("Unknown column '" + operandValue + "' for table at expression '" + expr.getCode() + "'. ");
                msg.append("Valid columns are: ");
                int numColumns = table.getColumnCount();
                try {
                    for (int i = 0; i < numColumns; ++i) {
                        if (i > 0) {
                            msg.append(", ");
                        }
                        msg.append(table.getColumn(i).getName());
                    }
                }
                catch (ColumnNotDefinedException ex) {
                    // empty catch block
                }
                msg.append(".");
                throw new OperandException(msg.toString());
            }
            catch (TypeMismatchException e) {
                throw new OperandException("Unable to format value of column '" + operandValue + "'.");
            }
        }

        public String getDescription() {
            return "Gets the formatted value of the field specified by the operand at this row.";
        }
    }

    public class ReferenceOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = RowType.this.interpreter.evalStringOperand(operand, ctx);
            if (operandValue == null) {
                throw new OperandException("Row index evaluated to null value: '" + operand + "'");
            }
            Row row = (Row)expr.getObject().getValue();
            try {
                Table table = row.getTable();
                int colIdx = table.getColumnIndex(operandValue);
                return row.getObject(colIdx);
            }
            catch (ColumnNotDefinedException e) {
                if ("rowType".equals(operandValue)) {
                    return row.getType();
                }
                if ("groupName".equals(operandValue)) {
                    if (row instanceof GroupRow) {
                        GroupRow gr = (GroupRow)row;
                        return gr.getGroupName();
                    }
                    return null;
                }
                if ("startNewPage".equals(operandValue)) {
                    return new Boolean(row.isStartNewPage());
                }
                if ("startsBlock".equals(operandValue)) {
                    return new Boolean(row.isStartsBlock());
                }
                if ("endsBlock".equals(operandValue)) {
                    return new Boolean(row.isEndsBlock());
                }
                StringBuffer msg = new StringBuffer("Unknown column '" + operandValue + "' for table at expression '" + expr.getCode() + "'. ");
                msg.append("Valid columns are: ");
                Table table = row.getTable();
                int numColumns = table.getColumnCount();
                try {
                    for (int i = 0; i < numColumns; ++i) {
                        if (i > 0) {
                            msg.append(", ");
                        }
                        msg.append(table.getColumn(i).getName());
                    }
                }
                catch (ColumnNotDefinedException ex) {
                    // empty catch block
                }
                msg.append(".");
                throw new OperandException(msg.toString());
            }
        }

        public String getDescription() {
            return "Accesses the field specified by the operand at this row.";
        }
    }

    public class HasColumnOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = RowType.this.interpreter.evalStringOperand(operand, ctx);
            Row row = (Row)expr.getObject().getValue();
            try {
                return new Boolean(row.getTable().getColumn(operandValue) != null);
            }
            catch (ColumnNotDefinedException ex) {
                return Boolean.FALSE;
            }
        }

        public String getDescription() {
            return "Checks it the table that holds the row contains a column that matches the name, specified by the operand.";
        }
    }

    public class ColumnCountOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Row row = (Row)expr.getObject().getValue();
            return new Integer(row.getTable().getColumnCount());
        }

        public String getDescription() {
            return "Gets the number of columns from the table that holds the row.";
        }
    }

    public class RowCountOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            try {
                Row row = (Row)expr.getObject().getValue();
                return new Integer(row.getTable().getRowCount());
            }
            catch (OperationNotSupportedException ex) {
                throw new ExpressionException(ex.getMessage());
            }
        }

        public String getDescription() {
            return "Gets the number of rows from the table that holds the row.";
        }
    }

    public class NoRowsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Row row = (Row)expr.getObject().getValue();
            return new Boolean(row.getTable().isEmpty());
        }

        public String getDescription() {
            return "Checks if the table that holds the row, has no rows.";
        }
    }

    public class HasRowsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Row row = (Row)expr.getObject().getValue();
            return new Boolean(!row.getTable().isEmpty());
        }

        public String getDescription() {
            return "Checks if the table that holds the row, has rows.";
        }
    }
}

