/*
 * Decompiled with CFR 0.152.
 */
package org.ujac.util.exi.type;

import java.util.ArrayList;
import java.util.Iterator;
import org.ujac.util.exi.BaseExpressionOperation;
import org.ujac.util.exi.ExpressionContext;
import org.ujac.util.exi.ExpressionException;
import org.ujac.util.exi.ExpressionInterpreter;
import org.ujac.util.exi.ExpressionTuple;
import org.ujac.util.exi.NoOperandException;
import org.ujac.util.exi.Operand;
import org.ujac.util.exi.OperandException;
import org.ujac.util.exi.OperandNotSupportedException;
import org.ujac.util.exi.type.BaseType;
import org.ujac.util.table.Column;
import org.ujac.util.table.ColumnNotDefinedException;
import org.ujac.util.table.DataTable;
import org.ujac.util.table.LayoutHints;
import org.ujac.util.table.OperationNotSupportedException;
import org.ujac.util.table.Row;
import org.ujac.util.table.RowNotDefinedException;
import org.ujac.util.table.Table;
import org.ujac.util.table.TableException;
import org.ujac.util.table.TypeMismatchException;

public class TableType
extends BaseType {
    public TableType(ExpressionInterpreter interpreter) {
        super(interpreter);
        BaseExpressionOperation op = new ReferenceOperation();
        this.addOperation(".", op);
        this.addOperation("[]", op);
        this.addOperation("getField", op);
        op = new GetRowOperation();
        this.addOperation("getRow", op);
        op = new FormatValueOperation();
        this.addOperation("formatValue", op);
        op = new HasRowsOperation();
        this.addOperation("hasRows", op);
        this.addOperation("notEmpty", op);
        op = new NoRowsOperation();
        this.addOperation("noRows", op);
        this.addOperation("isEmpty", op);
        op = new RowCountOperation();
        this.addOperation("rowCount", op);
        this.addOperation("size", op);
        op = new ColumnCountOperation();
        this.addOperation("columnCount", op);
        op = new ColumnsOperation();
        this.addOperation("columns", op);
        op = new VisibleColumnsOperation();
        this.addOperation("visibleColumns", op);
        op = new HasColumnOperation();
        this.addOperation("hasColumn", op);
        op = new RotateOperation();
        this.addOperation("rotate", op);
    }

    public Class getType() {
        return Table.class;
    }

    public class RotateOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new NoOperandException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Table table = (Table)expr.getObject().getValue();
            try {
                Column[] visibleColumns = table.getVisibleColumns();
                DataTable rotatedTable = new DataTable(table.getFormatHelper());
                Column rCol = rotatedTable.addColumn("header", 11);
                rCol.setLayoutHints(new LayoutHints(10.0f, null));
                for (int i = 0; i < visibleColumns.length; ++i) {
                    Row rRow = rotatedTable.addRow();
                    rRow.setString(rCol.getIndex(), visibleColumns[i].getLayoutHints().getHeader());
                }
                int rowIdx = 0;
                Iterator iterTable = table.iterator();
                while (iterTable.hasNext()) {
                    Row row = (Row)iterTable.next();
                    rCol = rotatedTable.addColumn("row" + rowIdx, 11);
                    rCol.setLayoutHints(new LayoutHints(10.0f, null));
                    for (int i = 0; i < visibleColumns.length; ++i) {
                        Row rRow = rotatedTable.getRow(i);
                        rRow.setObject(rCol.getIndex(), row.getObject(i));
                    }
                    ++rowIdx;
                }
                return rotatedTable;
            }
            catch (TableException e) {
                throw new ExpressionException("Failed to rotate table at expression '" + expr.getCode() + "'.");
            }
        }

        public String getDescription() {
            return "Rotates the table, specified by the object. It serves a table, that holds the same values as the original table, but rotated by 90 degrees. The first column of the rotated table holds the title row of the original table.";
        }
    }

    public class FormatValueOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = TableType.this.interpreter.evalStringOperand(operand, ctx);
            Table table = (Table)expr.getObject().getValue();
            try {
                return table.getString(0, operandValue);
            }
            catch (RowNotDefinedException e) {
                throw new ExpressionException("No row defined for table at expression '" + expr.getCode() + "'.");
            }
            catch (ColumnNotDefinedException e) {
                StringBuffer msg = new StringBuffer("Unknown column '" + operandValue + "' for table at expression '" + expr.getCode() + "'. ");
                msg.append("Valid columns are: ");
                int numColumns = table.getColumnCount();
                try {
                    for (int i = 0; i < numColumns; ++i) {
                        if (i > 0) {
                            msg.append(", ");
                        }
                        msg.append(table.getColumn(i).getName());
                    }
                }
                catch (ColumnNotDefinedException ex) {
                    // empty catch block
                }
                msg.append(".");
                throw new OperandException(msg.toString());
            }
            catch (TypeMismatchException e) {
                throw new OperandException("Unable to format value of column '" + operandValue + "'.");
            }
        }

        public String getDescription() {
            return "Gets the formatted value of the field specified by the operand at this row.";
        }
    }

    public class GetRowOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            int operandValue = TableType.this.interpreter.evalIntOperand(operand, ctx, false);
            Table table = (Table)expr.getObject().getValue();
            try {
                return table.getRow(operandValue);
            }
            catch (OperationNotSupportedException e) {
                throw new ExpressionException("Table accessed at expression '" + expr.getCode() + "' does not support the 'getRow' operation.");
            }
            catch (RowNotDefinedException e) {
                throw new ExpressionException("Row #" + operandValue + " is not defined for table at expression '" + expr.getCode() + "'.");
            }
        }

        public String getDescription() {
            return "Accesses the field specified by the operand at the first row of the table.";
        }
    }

    public class ReferenceOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = TableType.this.interpreter.evalStringOperand(operand, ctx);
            Table table = (Table)expr.getObject().getValue();
            try {
                return table.getObject(0, operandValue);
            }
            catch (RowNotDefinedException e) {
                throw new ExpressionException("No row defined for table at expression '" + expr.getCode() + "'.");
            }
            catch (ColumnNotDefinedException e) {
                StringBuffer msg = new StringBuffer("Unknown column '" + operandValue + "' for table at expression '" + expr.getCode() + "'. ");
                msg.append("Valid columns are: ");
                int numColumns = table.getColumnCount();
                try {
                    for (int i = 0; i < numColumns; ++i) {
                        if (i > 0) {
                            msg.append(", ");
                        }
                        msg.append(table.getColumn(i).getName());
                    }
                }
                catch (ColumnNotDefinedException ex) {
                    // empty catch block
                }
                msg.append(".");
                throw new OperandException(msg.toString());
            }
        }

        public String getDescription() {
            return "Accesses the field specified by the operand at the first row of the table.";
        }
    }

    public class HasColumnOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand == null) {
                throw new NoOperandException("No operand given for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            String operandValue = TableType.this.interpreter.evalStringOperand(operand, ctx);
            Table table = (Table)expr.getObject().getValue();
            try {
                return new Boolean(table.getColumn(operandValue) != null);
            }
            catch (ColumnNotDefinedException ex) {
                return Boolean.FALSE;
            }
        }

        public String getDescription() {
            return "Checks it the table contains a column that matches the name, specified by the operand.";
        }
    }

    public class VisibleColumnsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Table table = (Table)expr.getObject().getValue();
            Operand operand = expr.getOperand();
            if (operand != null) {
                int level = TableType.this.interpreter.evalIntOperand(operand, ctx, false);
                return table.getVisibleColumns(level);
            }
            return table.getVisibleColumns();
        }

        public String getDescription() {
            return "Gets the number of columns from the table, specified by the object.";
        }
    }

    public class ColumnsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            try {
                Table table = (Table)expr.getObject().getValue();
                int numColumns = table.getColumnCount();
                ArrayList<Column> columns = new ArrayList<Column>();
                for (int i = 0; i < numColumns; ++i) {
                    columns.add(table.getColumn(i));
                }
                return columns;
            }
            catch (TableException ex) {
                throw new ExpressionException("Table processing failed: " + ex.getMessage(), ex);
            }
        }

        public String getDescription() {
            return "Gets the number of columns from the table, specified by the object.";
        }
    }

    public class ColumnCountOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Table table = (Table)expr.getObject().getValue();
            return new Integer(table.getColumnCount());
        }

        public String getDescription() {
            return "Gets the number of columns from the table, specified by the object.";
        }
    }

    public class RowCountOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            try {
                Table table = (Table)expr.getObject().getValue();
                return new Integer(table.getRowCount());
            }
            catch (OperationNotSupportedException ex) {
                throw new ExpressionException(ex.getMessage());
            }
        }

        public String getDescription() {
            return "Gets the number of rows from the table, specified by the object.";
        }
    }

    public class NoRowsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Table table = (Table)expr.getObject().getValue();
            return new Boolean(table.isEmpty());
        }

        public String getDescription() {
            return "Checks if the table, specified by the object has no rows.";
        }
    }

    public class HasRowsOperation
    extends BaseExpressionOperation {
        public Object evaluate(ExpressionTuple expr, ExpressionContext ctx) throws ExpressionException {
            Operand operand = expr.getOperand();
            if (operand != null) {
                throw new OperandNotSupportedException("No operand supported for operation: " + expr.getOperation() + " on object " + expr.getObject() + "!");
            }
            Table table = (Table)expr.getObject().getValue();
            return new Boolean(!table.isEmpty());
        }

        public String getDescription() {
            return "Checks if the table, specified by the object has rows.";
        }
    }
}

